/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ai.tools;

import com.google.gson.JsonObject;
import java.util.function.BooleanSupplier;
import ro.amiq.dvt.ai.AIUtils;
import ro.amiq.dvt.ai.tools.AITool;
import ro.amiq.dvt.ai.tools.AIToolUtils;
import ro.amiq.dvt.ai.tools.annotations.ToolConfirmationMessage;
import ro.amiq.dvt.ai.tools.annotations.ToolDescription;
import ro.amiq.dvt.ai.tools.annotations.ToolDisplayName;
import ro.amiq.dvt.ai.tools.annotations.ToolInputSchema;
import ro.amiq.dvt.ai.tools.annotations.ToolName;
import ro.amiq.dvt.ai.tools.annotations.ToolNeedsConfirmation;
import ro.amiq.dvt.ui.actions.history.HistoryItem;
import ro.amiq.vlogdt.model.reflection.views.VHHistoryItem;

@ToolName(value="dvt_get_verification_top")
@ToolDisplayName(value="Get Verification Top (DVT)")
@ToolDescription(value="Retrieves the top-level UVM verification element of the project.\n\nThe UVM verification top is the wrapper that ties the hardware design to the UVM environment and serves as the sole entry point for simulation.\n\n**When to use**\n\nUse this tool, along with the *dvt_get_verification_subcomponents* tool, to explore and understand the architecture of the UVM verification code of the working project.\n\n**Output format**\n\nThis tool returns the name of the UVM verification top element.\n")
@ToolConfirmationMessage(value="This tool will retrieve the top-level UVM verification element of the project.\nDo you want to continue?\n")
@ToolNeedsConfirmation(value=false)
@ToolInputSchema(value="{\n  \"type\": \"object\",\n  \"properties\": {},\n  \"additionalProperties\": false\n}\n")
public class GetVerificationTopAITool
extends AITool {
    static final String CONFIRMATION_MESSAGE = "This tool will retrieve the top-level UVM verification element of the project.\nDo you want to continue?\n";

    @Override
    protected String invoke(BooleanSupplier isCanceled, JsonObject input) {
        HistoryItem topHistoryItem = AIUtils.getInstance().getVHTop(AIToolUtils.INSTANCE.getToolCallProject(input));
        if (topHistoryItem == null) {
            return "Verification top element is not set!";
        }
        return topHistoryItem instanceof VHHistoryItem ? topHistoryItem.getElementName() : topHistoryItem.toString();
    }

    @Override
    public String getPreInvokeConfirmationMessage(BooleanSupplier isCanceled, JsonObject input) {
        return CONFIRMATION_MESSAGE;
    }

    @Override
    public String getPreInvokeDisplayName(BooleanSupplier isCanceled, JsonObject input) {
        return "Get Verification Top";
    }
}

