/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ai.tools;

import com.google.gson.JsonObject;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import ro.amiq.dvt.ai.tools.AITool;
import ro.amiq.dvt.ai.tools.TokensUsageManager;
import ro.amiq.dvt.ai.tools.pagination.PaginatedResult;
import ro.amiq.dvt.ai.tools.pagination.PaginatedResultStore;

public abstract class PaginatedAITool
extends AITool {
    private static final int CACHE_RECOMPUTE_TIMEOUT_SECONDS = 30;
    private final PaginatedResultStore<JsonObject, String> store = new PaginatedResultStore(this.getCacheRecomputeTimeout());

    protected PaginatedResult<String> computePaginatedResult(BooleanSupplier isCanceled, JsonObject input, BiFunction<BooleanSupplier, JsonObject, List<String>> computeFunc) {
        int page = 0;
        try {
            page = input.get("page").getAsInt();
        }
        catch (Exception exception) {}
        if (page <= 0) {
            page = 1;
        }
        input.remove("page");
        return this.store.getPage(isCanceled, input, page, this.getPageSize(), computeFunc);
    }

    public void invalidateCache() {
        this.store.invalidateCache();
    }

    protected int getPageSize() {
        return TokensUsageManager.INSTANCE.getMaxNumberOfResults(this.getEstimatedResultTokensOnSingleEntry());
    }

    protected int getCacheRecomputeTimeout() {
        return 30;
    }

    protected abstract int getEstimatedResultTokensOnSingleEntry();
}

