/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ai.tools;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.networknt.schema.Error;
import com.networknt.schema.InputFormat;
import com.networknt.schema.Schema;
import com.networknt.schema.SchemaRegistry;
import com.networknt.schema.dialect.Dialect;
import com.networknt.schema.dialect.Dialects;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import ro.amiq.dvt.ai.model.AIToolInputJsonSchema;

public enum SchemaUtils {
    INSTANCE;


    public List<Error> computeValidationErrors(String schema, JsonObject input) {
        Schema jsonSchema = this.getJsonSchema(schema);
        if (jsonSchema == null) {
            return Collections.emptyList();
        }
        return jsonSchema.validate(input.toString(), InputFormat.JSON);
    }

    public Schema getJsonSchema(String schema) {
        SchemaRegistry registry = SchemaRegistry.withDialect((Dialect)Dialects.getOpenApi30());
        if (registry == null) {
            return null;
        }
        return registry.getSchema(schema);
    }

    public AIToolInputJsonSchema convertSchema(String schema) {
        if (schema == null) {
            return null;
        }
        Schema jsonSchema = this.getJsonSchema(schema);
        if (jsonSchema == null) {
            return null;
        }
        return this.convert(jsonSchema.getSchemaNode());
    }

    public boolean getOptionalBooleanMember(JsonObject input, String memberName, boolean defaultValue) {
        try {
            JsonElement memberElement = input.get(memberName);
            if (memberElement == null) {
                return defaultValue;
            }
            return memberElement.getAsBoolean();
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    private AIToolInputJsonSchema convert(JsonNode node) {
        if (node == null || node.isMissingNode()) {
            return null;
        }
        AIToolInputJsonSchema result = new AIToolInputJsonSchema();
        if (node.has("type")) {
            result.setType(node.get("type").asText());
        }
        if (node.has("description")) {
            result.setDescription(node.get("description").asText());
        }
        if (node.has("enum")) {
            ArrayList<Object> enumValues = new ArrayList<Object>();
            for (JsonNode enumNode : node.get("enum")) {
                if (enumNode.isTextual()) {
                    enumValues.add(enumNode.asText());
                    continue;
                }
                if (enumNode.isNumber()) {
                    enumValues.add(enumNode.numberValue());
                    continue;
                }
                if (enumNode.isBoolean()) {
                    enumValues.add(enumNode.asBoolean());
                    continue;
                }
                enumValues.add(enumNode.toString());
            }
            result.setEnumValues(enumValues);
        }
        if (node.has("required")) {
            ArrayList<String> required = new ArrayList<String>();
            for (JsonNode reqNode : node.get("required")) {
                required.add(reqNode.asText());
            }
            result.setRequired(required);
        }
        if (node.has("properties") && node.get("properties").isObject()) {
            LinkedHashMap<String, AIToolInputJsonSchema> properties = new LinkedHashMap<String, AIToolInputJsonSchema>();
            node.get("properties").fields().forEachRemaining(entry -> properties.put((String)entry.getKey(), this.convert((JsonNode)entry.getValue())));
            result.setProperties(properties);
        }
        if (node.has("items")) {
            result.setItems(this.convert(node.get("items")));
        }
        return result;
    }
}

