/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ai.tools.disabled;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.file.FileSystems;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.ai.contributor.AILangContributorManager;
import ro.amiq.dvt.ai.contributor.IAILangContributor;
import ro.amiq.dvt.ai.model.MultiRootTree;
import ro.amiq.dvt.ai.model.TreeElement;
import ro.amiq.dvt.ai.tools.AIToolUtils;
import ro.amiq.dvt.ai.tools.PaginatedAITool;
import ro.amiq.dvt.ai.tools.annotations.ToolConfirmationMessage;
import ro.amiq.dvt.ai.tools.annotations.ToolDescription;
import ro.amiq.dvt.ai.tools.annotations.ToolDisplayName;
import ro.amiq.dvt.ai.tools.annotations.ToolInputSchema;
import ro.amiq.dvt.ai.tools.annotations.ToolName;
import ro.amiq.dvt.ai.tools.annotations.ToolNeedsConfirmation;
import ro.amiq.dvt.ai.tools.pagination.PaginatedResult;
import ro.amiq.dvt.ai.tools.pagination.utils.FlattenedTreeElement;
import ro.amiq.dvt.ai.tools.pagination.utils.MultiRootTreeFlattener;
import ro.amiq.dvt.utils.DVTFileUtils;

@ToolName(value="dvt_get_compiled_files_tree")
@ToolDisplayName(value="Get Compiled Files Tree (DVT)")
@ToolDescription(value="Returns the **absolute paths** of all files that DVT has compiled, arranged in a **hierarchical tree** that reflects the true include-dependency structure of the project.\n\nFor languages that support `include` statements (e.g., SystemVerilog), the tree is built from the top-level source files down through each `include`.\nFor languages without includes (e.g., VHDL) the result is a **single-level list** of all compiled files.\nIn mixed-language projects the output is separated by language headings (SystemVerilog, VHDL, \u2026).\n\n**When to use**\n\n- Quickly grasp the **overall layout** of a running project.\n- Identify **file dependencies** and the ripple-effect of a change (refactoring impact analysis).\n- Aid any tooling that needs to navigate or visualize the source-code graph.\n- When you need an accurate, ready-to-parse view of the compiled file hierarchy for analysis, documentation, or automated refactoring.\n\n**Important**\n\n- Results are divided into pages for efficient navigation of large datasets, with pages being numbered starting from 1.\n- Each page includes metadata such as total elements, total pages, current page, and page size.\n- It is recommended to use subsequent tool calls to progress through a task, rather than asking the user to manually request the next page.\n\n**Output format - examples**\n\n* SystemVerilog project (2 top files, `file1.sv` and `file2.sv`, `file1.sv` includes `file3.sv`)\n```\n- /absolute/path/of/file1.sv\n  -  /absolute/path/of/file3.sv\n- /absolute/path/of/file2.sv\n```\n\n* VHDL project (3 files, no includes)\n```\n- /absolute/path/of/file1.vhdl\n- /absolute/path/of/file2.vhdl\n- /absolute/path/of/file3.vhdl\n```\n\n* Mixed project (SystemVerilog + VHDL, `file2.sv` includes `file5.sv`)\n```\n- SystemVerilog\n  - /absolute/path/of/file1.sv\n  - /absolute/path/of/file2.sv\n    - /absolute/path/of/file5.sv\n- VHDL\n  - /absolute/path/of/file3.vhdl\n  - /absolute/path/of/file4.vhdl\n```\n")
@ToolConfirmationMessage(value="This tool will retrieve the tree of compiled files.\nDo you want to continue?\n")
@ToolNeedsConfirmation(value=false)
@ToolInputSchema(value="{\n  \"type\": \"object\",\n  \"properties\": {\n  \"filter\": {\n      \"type\": \"string\",\n      \"nullable\": true,\n      \"description\": \"Glob pattern to filter out matching file paths (e.g., '**/apb/**' for searching paths that contain the 'apb' path segment, '**/*.svh' for searching files with the '.svh' extension).\"\n    },\n    \"page\": {\n      \"type\": \"number\",\n      \"nullable\": true,\n      \"description\": \"The page number to request. Pages start at 1.\"\n    }\n  },\n  \"additionalProperties\": false\n}\n")
public class GetCompiledFilesTreeAITool
extends PaginatedAITool {
    private static final int ESTIMATED_RESULT_TOKNES_ON_SINGLE_ENTRY = 40;
    static final String CONFIRMATION_MESSAGE = "This tool will retrieve the tree of compiled files.\nDo you want to continue?\n";

    @Override
    protected String invoke(BooleanSupplier isCanceled, JsonObject input) {
        PaginatedResult<String> result = this.computePaginatedResult(isCanceled, input, this::computeCompiledFilesTreeFlatten);
        if (result.getTotalElements() == 0) {
            return "No DVT compiled files were found for the given input!";
        }
        return result.toString("Compiled Files");
    }

    private MultiRootTree computeCompiledFilesTree(BooleanSupplier isCanceled, JsonObject input) {
        EnumMap<LanguageKind, List<TreeElement>> languageToRoots = new EnumMap<LanguageKind, List<TreeElement>>(LanguageKind.class);
        for (IAILangContributor aiContributor : AILangContributorManager.INSTANCE.getContributors()) {
            List<TreeElement> languageRoots = aiContributor.getCompiledFilesTree(AIToolUtils.INSTANCE.getToolCallProject(input));
            if (languageRoots == null || languageRoots.isEmpty()) continue;
            languageToRoots.put(aiContributor.getLanguage(), languageRoots);
        }
        if (languageToRoots.isEmpty()) {
            return null;
        }
        if (languageToRoots.size() == 1) {
            return new MultiRootTree((List)new ArrayList(languageToRoots.values()).get(0));
        }
        ArrayList<TreeElement> roots = new ArrayList<TreeElement>();
        for (Map.Entry entry : languageToRoots.entrySet()) {
            roots.add(new TreeElement(((LanguageKind)entry.getKey()).getViewName(), (List)entry.getValue()));
        }
        return new MultiRootTree(roots);
    }

    public List<String> computeCompiledFilesTreeFlatten(BooleanSupplier isCanceled, JsonObject input) {
        MultiRootTree compiledFilesTree = this.computeCompiledFilesTree(isCanceled, input);
        List<FlattenedTreeElement> compiledFiles = MultiRootTreeFlattener.flatten(compiledFilesTree);
        String filter = this.getFilter(input);
        if (filter == null) {
            return compiledFiles.stream().map(cf -> cf.toString()).collect(Collectors.toList());
        }
        if (DVTFileUtils.getInstance().pathStartsWithADriveLetter(filter)) {
            filter = filter.replace("\\", "\\\\");
        }
        PathMatcher pathMatcher = FileSystems.getDefault().getPathMatcher("glob:" + filter);
        return compiledFiles.stream().filter(cf -> {
            if (cf.getLabel().contains(LanguageKind.VLOG.VIEW_NAME) || cf.getLabel().contains(LanguageKind.VHDL.VIEW_NAME) || cf.getLabel().contains(LanguageKind.E.VIEW_NAME)) {
                return true;
            }
            String path = cf.getLabel();
            return pathMatcher.matches(Paths.get(path, new String[0]));
        }).map(cf -> cf.toString()).collect(Collectors.toList());
    }

    private String getFilter(JsonObject input) {
        JsonElement filterElement;
        block3: {
            try {
                filterElement = input.get("filter");
                if (filterElement != null) break block3;
                return null;
            }
            catch (Exception exception) {
                return null;
            }
        }
        return filterElement.getAsString();
    }

    @Override
    public String getPreInvokeConfirmationMessage(BooleanSupplier isCanceled, JsonObject input) {
        return CONFIRMATION_MESSAGE;
    }

    @Override
    public String getPreInvokeDisplayName(BooleanSupplier isCanceled, JsonObject input) {
        return "Get Compiled Files Tree";
    }

    @Override
    protected int getEstimatedResultTokensOnSingleEntry() {
        return 40;
    }
}

