/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ai.tools.pagination;

import java.util.List;

public class PaginatedResult<R> {
    private final List<R> content;
    private final int totalElements;
    private final int totalPages;
    private final int page;
    private final int pageSize;

    public PaginatedResult(List<R> content, int totalElements, int totalPages, int page, int pageSize) {
        this.content = content;
        this.totalElements = totalElements;
        this.totalPages = totalPages;
        this.page = page;
        this.pageSize = pageSize;
    }

    public List<R> getContent() {
        return this.content;
    }

    public int getTotalElements() {
        return this.totalElements;
    }

    public int getTotalPages() {
        return this.totalPages;
    }

    public int getPage() {
        return this.page;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public String toString(String resultTitle) {
        StringBuilder resultBuilder = new StringBuilder();
        for (R elem : this.getContent()) {
            resultBuilder.append(elem.toString());
        }
        if (this.totalPages == 1) {
            return String.valueOf("### %s%n".formatted(resultTitle)) + System.lineSeparator() + resultBuilder.toString().trim();
        }
        String header = String.format("### " + resultTitle + " - Page %d of %d%n", this.getPage(), this.getTotalPages());
        String filesSummary = String.format("*Showing results [%d - %d] out of %d total*%n", this.pageSize * (this.page - 1) + 1, Math.min(this.pageSize * this.page, this.getTotalElements()), this.getTotalElements());
        String hint = this.getPage() == this.getTotalPages() ? "" : String.format("*Request page %d to view results [%d - %d]*%n", this.getPage() + 1, this.pageSize * this.page + 1, Math.min(this.pageSize * (this.page + 1), this.getTotalElements()));
        return String.valueOf(header) + filesSummary + hint + System.lineSeparator() + resultBuilder.toString().trim();
    }
}

