/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ai.tools.pagination;

import java.util.List;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import ro.amiq.dvt.ai.tools.pagination.CacheExpireException;
import ro.amiq.dvt.ai.tools.pagination.CacheMissException;
import ro.amiq.dvt.ai.tools.pagination.PaginatedResult;
import ro.amiq.dvt.ai.tools.pagination.PaginationCache;

public class PaginatedResultStore<I, R> {
    private final PaginationCache<I, List<R>> cache;

    public PaginatedResultStore(long inactivitySeconds) {
        this.cache = new PaginationCache(inactivitySeconds);
    }

    public PaginatedResult<R> getPage(BooleanSupplier isCanceled, I input, int page, int pageSize, BiFunction<BooleanSupplier, I, List<R>> computeFunc) {
        List<R> full;
        try {
            full = this.cache.get(input);
        }
        catch (CacheExpireException | CacheMissException cacheException) {
            full = computeFunc.apply(isCanceled, input);
            this.cache.put(input, full);
        }
        int totalElements = full.size();
        int totalPages = (int)Math.ceil((double)totalElements / (double)pageSize);
        int start = (page - 1) * pageSize;
        int end = Math.min(start + pageSize, totalElements);
        List pageContent = start >= totalElements ? List.of() : full.subList(start, end);
        return new PaginatedResult(pageContent, totalElements, totalPages, page, pageSize);
    }

    public void invalidateCache() {
        this.cache.invalidate();
    }
}

