/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ai.tools.pagination;

import java.time.Instant;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import ro.amiq.dvt.ai.tools.pagination.CacheException;
import ro.amiq.dvt.ai.tools.pagination.CacheExpireException;
import ro.amiq.dvt.ai.tools.pagination.CacheMissException;

class PaginationCache<K, V> {
    private final Map<K, CacheEntry<V>> cache = new ConcurrentHashMap<K, CacheEntry<V>>();
    private final long inactivityTimeoutMillis;

    public PaginationCache(long inactivityTimeoutSeconds) {
        this.inactivityTimeoutMillis = inactivityTimeoutSeconds * 1000L;
    }

    public void put(K key, V value) {
        this.cache.put(key, new CacheEntry<V>(value));
    }

    public V get(K key) throws CacheException {
        CacheEntry<V> entry = this.cache.get(key);
        if (entry == null) {
            throw new CacheMissException("No cache entry found for key: " + key);
        }
        long idleMillis = Instant.now().toEpochMilli() - entry.lastAccess.toEpochMilli();
        if (idleMillis >= this.inactivityTimeoutMillis) {
            this.cache.remove(key);
            throw new CacheExpireException("Cache entry expired for key: " + key);
        }
        entry.touch();
        return entry.value;
    }

    public void invalidate() {
        this.cache.clear();
    }

    private static class CacheEntry<V> {
        final V value;
        volatile Instant lastAccess;

        CacheEntry(V value) {
            this.value = value;
            this.lastAccess = Instant.now();
        }

        void touch() {
            this.lastAccess = Instant.now();
        }
    }
}

