/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ai.tools.pagination.utils;

import java.util.ArrayList;
import java.util.List;
import ro.amiq.dvt.ai.model.MultiRootTree;
import ro.amiq.dvt.ai.model.TreeElement;
import ro.amiq.dvt.ai.tools.pagination.utils.FlattenedTreeElement;

public final class MultiRootTreeFlattener {
    private MultiRootTreeFlattener() {
    }

    public static List<FlattenedTreeElement> flatten(MultiRootTree tree) {
        ArrayList<FlattenedTreeElement> result = new ArrayList<FlattenedTreeElement>();
        if (tree == null || tree.getRoots() == null) {
            return result;
        }
        for (TreeElement root : tree.getRoots()) {
            MultiRootTreeFlattener.dfs(root, 0, result);
        }
        return result;
    }

    private static void dfs(TreeElement treeElemenet, int level, List<FlattenedTreeElement> output) {
        if (treeElemenet == null) {
            return;
        }
        output.add(new FlattenedTreeElement(treeElemenet.getElement(), level));
        List<TreeElement> children = treeElemenet.getChildren();
        if (children != null) {
            for (TreeElement child : children) {
                MultiRootTreeFlattener.dfs(child, level + 1, output);
            }
        }
    }
}

