/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ai.ui;

import java.util.concurrent.CompletableFuture;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;
import ro.amiq.dvt.ai.AIConsole;
import ro.amiq.dvt.ai.AIManager;
import ro.amiq.dvt.ai.BooleanContextClauses;
import ro.amiq.dvt.ai.ContextChangeListener;
import ro.amiq.dvt.ai.ui.actions.SaveChatAsBlueprintAction;
import ro.amiq.dvt.ai.ui.actions.ShowChatHistoryAction;
import ro.amiq.dvt.ai.ui.actions.ShowLastChatAction;
import ro.amiq.dvt.ai.ui.actions.ShowMoreAction;
import ro.amiq.dvt.ai.ui.actions.StartNewChatAction;
import ro.amiq.dvt.ai.ui.browser.BrowserUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.Utils;

public class ChatView
extends ViewPart {
    public static final String ID = "ro.amiq.dvt.ai.eclipse.AIChat";
    private Browser browser;
    private Action startChatSessionAction;
    private Action saveChatAsBlueprintAction;
    private Action showChatHistoryAction;
    private Action showLastChatAction;
    private Action showMoreAction;
    private ContextChangeListener<Boolean> conversationDisplayedListener;
    private ContextChangeListener<Boolean> acknowledgmentListener;
    private FocusListener focusListener;

    public void createPartControl(Composite parent) {
        AIConsole.MAIN.logDebug("Starting AI Chat View creation...");
        parent.setLayout((Layout)new GridLayout(1, false));
        ((CompletableFuture)AIManager.getInstance().thenAccept(aiManager -> PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
            this.browser = aiManager.getBrowser();
            this.browser.setParent(parent);
            this.browser.setLayoutData((Object)new GridData(4, 4, true, true));
            parent.addDisposeListener(e -> BrowserUtils.INSTANCE.changeToHeadlessBrowser(this.browser));
            this.createActions();
            parent.layout(true, true);
            this.installFocusListener();
            AIConsole.MAIN.logDebug("AI Chat View created succesfully");
        }))).exceptionally(ex -> {
            DVTLogger.INSTANCE.logError(ex);
            return null;
        });
    }

    private void createActions() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        this.conversationDisplayedListener = (oldValue, newValue) -> {
            if (oldValue.equals(newValue)) {
                return;
            }
            if (newValue.booleanValue()) {
                this.addConversationActions(actionBars);
            } else {
                this.addChatHistoryActions(actionBars);
            }
        };
        this.acknowledgmentListener = (oldValue, newValue) -> {
            if (oldValue.equals(newValue)) {
                return;
            }
            if (newValue.booleanValue()) {
                if (BooleanContextClauses.IS_CONVERSATION_DISPLAYED.getValue().booleanValue()) {
                    this.addConversationActions(actionBars);
                } else {
                    this.addChatHistoryActions(actionBars);
                }
            } else {
                this.hideAction(actionBars);
            }
        };
        BooleanContextClauses.IS_CONVERSATION_DISPLAYED.addContextChangeListener(this.conversationDisplayedListener);
        BooleanContextClauses.IS_AI_ENABLED.addContextChangeListener(this.acknowledgmentListener);
        this.initializeActions();
        if (!BooleanContextClauses.IS_AI_ENABLED.getValue().booleanValue()) {
            return;
        }
        if (BooleanContextClauses.IS_CONVERSATION_DISPLAYED.getValue().booleanValue()) {
            this.addConversationActions(actionBars);
        } else {
            this.addChatHistoryActions(actionBars);
        }
    }

    private void initializeActions() {
        IWorkbenchWindow activeWorkbenchWindow = Utils.getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            return;
        }
        IHandlerService handlerService = (IHandlerService)activeWorkbenchWindow.getService(IHandlerService.class);
        this.startChatSessionAction = new StartNewChatAction(handlerService);
        this.saveChatAsBlueprintAction = new SaveChatAsBlueprintAction(handlerService);
        this.showChatHistoryAction = new ShowChatHistoryAction(handlerService);
        this.showLastChatAction = new ShowLastChatAction(handlerService);
        this.showMoreAction = new ShowMoreAction((Control)this.browser, handlerService);
    }

    public void hideAction(IActionBars actionBars) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
            IToolBarManager toolBarManager = actionBars.getToolBarManager();
            toolBarManager.removeAll();
            actionBars.updateActionBars();
        });
    }

    private void addConversationActions(IActionBars actionBars) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
            IToolBarManager toolBarManager = actionBars.getToolBarManager();
            toolBarManager.removeAll();
            actionBars.updateActionBars();
            toolBarManager.add((IAction)this.startChatSessionAction);
            toolBarManager.add((IAction)this.saveChatAsBlueprintAction);
            toolBarManager.add((IAction)this.showChatHistoryAction);
            toolBarManager.add((IAction)this.showMoreAction);
            actionBars.updateActionBars();
        });
    }

    private void addChatHistoryActions(IActionBars actionBars) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
            IToolBarManager toolBarManager = actionBars.getToolBarManager();
            toolBarManager.removeAll();
            actionBars.updateActionBars();
            toolBarManager.add((IAction)this.startChatSessionAction);
            toolBarManager.add((IAction)this.showLastChatAction);
            toolBarManager.add((IAction)this.showMoreAction);
            actionBars.updateActionBars();
        });
    }

    private void installFocusListener() {
        this.focusListener = new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                ((CompletableFuture)AIManager.getInstance().thenAccept(aiManager -> aiManager.getHost().getCore().focusInput())).exceptionally(ex -> {
                    DVTLogger.INSTANCE.logError(ex);
                    return null;
                });
            }
        };
        this.browser.addFocusListener(this.focusListener);
    }

    private void uninstallFocusListener() {
        this.browser.removeFocusListener(this.focusListener);
    }

    public void setFocus() {
        if (this.browser != null) {
            this.browser.setFocus();
        }
    }

    public void dispose() {
        super.dispose();
        this.uninstallFocusListener();
        BooleanContextClauses.IS_CONVERSATION_DISPLAYED.removeContextChangeListener(this.conversationDisplayedListener);
        this.conversationDisplayedListener = null;
        this.startChatSessionAction = null;
        this.saveChatAsBlueprintAction = null;
        this.showChatHistoryAction = null;
        this.showLastChatAction = null;
        this.showMoreAction = null;
    }
}

