/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ai.ui.actions;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.handlers.IHandlerService;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.DVTImages;

public class ShowMoreAction
extends Action {
    private static final String NAME = "Show More";
    public static final String ID = "dvt_ai_show_more";
    private final Control parent;
    IHandlerService handlerService;

    public ShowMoreAction(Control parent, IHandlerService handlerService) {
        super(NAME, DVTImages.AI_SHOW_MORE);
        this.setId(ID);
        this.handlerService = handlerService;
        this.parent = parent;
    }

    public void runWithEvent(Event event) {
        this.showMoreActionMenu(event);
    }

    private void showMoreActionMenu(Event event) {
        MenuManager menuManager = new MenuManager();
        this.createActions(menuManager);
        Menu menu = menuManager.createContextMenu(this.parent);
        if (!(event.widget instanceof ToolItem)) {
            DVTLogger.INSTANCE.logDebug("dvt_ai_show_more -> instance of ToolItem failed");
            return;
        }
        ToolItem item = (ToolItem)event.widget;
        Rectangle bounds = item.getBounds();
        Point location = item.getParent().toDisplay(bounds.x, bounds.y + bounds.height);
        menu.setLocation(location);
        menu.setVisible(true);
    }

    private void createActions(MenuManager menuManager) {
        menuManager.add((IAction)new Action("Create New Snippet", 1){

            public void run() {
                try {
                    ShowMoreAction.this.handlerService.executeCommand("ro.amiq.dvt.ai.createNewSnippet", null);
                }
                catch (ExecutionException | NotEnabledException | NotHandledException | NotDefinedException e) {
                    DVTLogger.INSTANCE.logError(e);
                }
            }
        });
        menuManager.add((IAction)new Action("Create New Blueprint", 1){

            public void run() {
                try {
                    ShowMoreAction.this.handlerService.executeCommand("ro.amiq.dvt.ai.createNewBlueprint", null);
                }
                catch (ExecutionException | NotEnabledException | NotHandledException | NotDefinedException e) {
                    DVTLogger.INSTANCE.logError(e);
                }
            }
        });
        menuManager.add((IAction)new Action("Create New Chat Profile", 1){

            public void run() {
                try {
                    ShowMoreAction.this.handlerService.executeCommand("ro.amiq.dvt.ai.createNewProfile", null);
                }
                catch (ExecutionException | NotEnabledException | NotHandledException | NotDefinedException e) {
                    DVTLogger.INSTANCE.logError(e);
                }
            }
        });
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)new Action("Show All Commands", 1){

            public void run() {
                try {
                    ShowMoreAction.this.handlerService.executeCommand("ro.amiq.dvt.ai.SelectCommand", null);
                }
                catch (ExecutionException | NotEnabledException | NotHandledException | NotDefinedException e) {
                    DVTLogger.INSTANCE.logError(e);
                }
            }
        });
    }
}

