/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ai.ui.browser;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.ai.AIConsole;
import ro.amiq.dvt.ai.AIManager;
import ro.amiq.dvt.ai.BooleanContextClauses;
import ro.amiq.dvt.startup.core.DVTLogger;

public enum BrowserUtils {
    INSTANCE;

    private static final String SHOW_DEV_TOOLS_METHOD_NAME = "showDevTools";
    private Shell hiddenShell;

    public Browser initializeBrowser() {
        AIConsole.MAIN.logDebug("Starting browser initialiazation...");
        Browser browser = new Browser((Composite)this.getHiddenShell(), 0);
        BooleanContextClauses.IS_CONVERSATION_DISPLAYED.updateValue(true);
        Menu menu = new Menu((Control)browser);
        MenuItem copyItem = new MenuItem(menu, 0);
        copyItem.setText("Copy");
        copyItem.addListener(13, event -> {
            boolean bl = browser.execute("document.execCommand('copy')");
        });
        MenuItem cutItem = new MenuItem(menu, 0);
        cutItem.setText("Cut");
        cutItem.addListener(13, event -> {
            boolean bl = browser.execute("document.execCommand('cut')");
        });
        MenuItem pasteItem = new MenuItem(menu, 0);
        pasteItem.setText("Paste");
        pasteItem.addListener(13, event -> {
            boolean bl = browser.execute("navigator.clipboard.readText().then(text => {    var e = document.activeElement;    if (e.isContentEditable) {        var s = window.getSelection();        if (s.rangeCount) {            var r = s.getRangeAt(0);            r.deleteContents();            var t = document.createTextNode(text);            r.insertNode(t);            r.setStartAfter(t);            r.setEndAfter(t);            s.removeAllRanges();            s.addRange(r);        }    } else if (e.tagName === 'TEXTAREA' || (e.tagName === 'INPUT' && e.type === 'text')) {        var start = e.selectionStart, end = e.selectionEnd, val = e.value;        e.value = val.substring(0, start) + text + val.substring(end);        e.selectionStart = e.selectionEnd = start + text.length;        e.focus();    }});");
        });
        browser.setMenu(menu);
        browser.addLocationListener(new LocationListener(){

            public void changing(LocationEvent event) {
                URI uri;
                try {
                    uri = new URI(event.location);
                    if (uri.toString().contains(AIManager.getInstance().get().getServerUrl())) {
                        return;
                    }
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    return;
                }
                event.doit = false;
                try {
                    PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(uri.toURL());
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }

            public void changed(LocationEvent event) {
            }
        });
        AIConsole.MAIN.logDebug("Browser succesfully initialized");
        return browser;
    }

    public void openDevTools(Browser browser) {
        if (browser == null) {
            try {
                browser = AIManager.getInstance().get().getBrowser();
            }
            catch (Exception exception) {
                return;
            }
        }
        if (browser == null) {
            return;
        }
        Object webBrowser = browser.getWebBrowser();
        Class<?> chromiumBrowserClass = webBrowser.getClass();
        Method showDevToolsMethod = null;
        try {
            showDevToolsMethod = chromiumBrowserClass.getMethod(SHOW_DEV_TOOLS_METHOD_NAME, new Class[0]);
        }
        catch (NoSuchMethodException | SecurityException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return;
        }
        if (showDevToolsMethod == null) {
            return;
        }
        try {
            showDevToolsMethod.setAccessible(true);
            showDevToolsMethod.invoke(webBrowser, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void changeToHeadlessBrowser(Browser browser) {
        PlatformUI.getWorkbench().getDisplay().syncExec(() -> {
            boolean bl = browser.setParent((Composite)this.getHiddenShell());
        });
    }

    private Shell getHiddenShell() {
        if (this.hiddenShell != null) {
            return this.hiddenShell;
        }
        this.hiddenShell = new Shell(PlatformUI.getWorkbench().getDisplay(), 0);
        this.hiddenShell.setSize(0, 0);
        this.hiddenShell.setVisible(false);
        return this.hiddenShell;
    }
}

