/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ai.ui.browser.websocket;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.lsp4j.jsonrpc.MessageConsumer;
import org.eclipse.lsp4j.jsonrpc.MessageIssueException;
import org.eclipse.lsp4j.jsonrpc.RemoteEndpoint;
import org.eclipse.lsp4j.jsonrpc.json.MessageJsonHandler;
import org.eclipse.lsp4j.jsonrpc.messages.Message;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ServerHandshake;
import ro.amiq.dvt.startup.core.DVTLogger;

public class AIWebSocketClient
extends WebSocketClient {
    private MessageJsonHandler jsonHandler;
    private RemoteEndpoint remoteEndpoint;
    private MessageConsumer messageConsumer;

    public AIWebSocketClient(String serverUrl) throws URISyntaxException {
        super(new URI(serverUrl));
    }

    public void configureMessageHandlers(MessageJsonHandler jsonHandler, RemoteEndpoint remoteEndpoint, MessageConsumer messageConsumer) {
        this.jsonHandler = jsonHandler;
        this.remoteEndpoint = remoteEndpoint;
        this.messageConsumer = messageConsumer;
    }

    public void onClose(int code, String reason, boolean remote) {
        DVTLogger.INSTANCE.logInfo("Connection closed by " + (remote ? "remote peer" : "us") + " Code: " + code + " Reason: " + reason);
    }

    public void onError(Exception ex) {
        DVTLogger.INSTANCE.logError((Throwable)ex);
    }

    public void send(String text) {
        super.send(text);
    }

    public void onMessage(String messageString) {
        try {
            Message message = this.jsonHandler.parseMessage((CharSequence)messageString);
            this.messageConsumer.consume(message);
        }
        catch (MessageIssueException exception) {
            this.remoteEndpoint.handle(exception.getRpcMessage(), exception.getIssues());
        }
    }

    public void onOpen(ServerHandshake handshakeData) {
        DVTLogger.INSTANCE.logInfo("Connection oppened with status: " + handshakeData.getHttpStatus() + " and message: " + handshakeData.getHttpStatusMessage());
    }
}

