/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ai.ui.browser.websocket;

import java.util.Collection;
import org.eclipse.lsp4j.jsonrpc.Endpoint;
import org.eclipse.lsp4j.jsonrpc.Launcher;
import org.eclipse.lsp4j.jsonrpc.MessageConsumer;
import org.eclipse.lsp4j.jsonrpc.RemoteEndpoint;
import org.eclipse.lsp4j.jsonrpc.json.MessageJsonHandler;
import org.eclipse.lsp4j.jsonrpc.json.MethodProvider;
import org.eclipse.lsp4j.jsonrpc.services.ServiceEndpoints;
import ro.amiq.dvt.ai.ui.browser.websocket.AIWebSocketClient;
import ro.amiq.dvt.ai.ui.browser.websocket.WSMessageConsumer;

public class WSLauncherBuilder<T>
extends Launcher.Builder<T> {
    protected AIWebSocketClient webSocket;

    public Collection<Object> getLocalServices() {
        return this.localServices;
    }

    public WSLauncherBuilder<T> setWebSocket(AIWebSocketClient serverWebSocket) {
        this.webSocket = serverWebSocket;
        return this;
    }

    public Launcher<T> create() {
        if (this.localServices == null) {
            throw new IllegalStateException("Local service must be configured.");
        }
        if (this.remoteInterfaces == null) {
            throw new IllegalStateException("Remote interface must be configured.");
        }
        MessageJsonHandler jsonHandler = this.createJsonHandler();
        RemoteEndpoint remoteEndpoint = this.createRemoteEndpoint(jsonHandler);
        this.addMessageHandlers(jsonHandler, remoteEndpoint);
        Object remoteProxy = this.createProxy(remoteEndpoint);
        return this.createLauncher(null, remoteProxy, remoteEndpoint, null);
    }

    protected RemoteEndpoint createRemoteEndpoint(MessageJsonHandler jsonHandler) {
        WSMessageConsumer outgoingMessageStream = new WSMessageConsumer(this.webSocket, jsonHandler);
        outgoingMessageStream = this.wrapMessageConsumer(outgoingMessageStream);
        Endpoint localEndpoint = ServiceEndpoints.toEndpoint((Collection)this.localServices);
        RemoteEndpoint remoteEndpoint = this.exceptionHandler == null ? new RemoteEndpoint((MessageConsumer)outgoingMessageStream, localEndpoint) : new RemoteEndpoint((MessageConsumer)outgoingMessageStream, localEndpoint, this.exceptionHandler);
        jsonHandler.setMethodProvider((MethodProvider)remoteEndpoint);
        return remoteEndpoint;
    }

    protected void addMessageHandlers(MessageJsonHandler jsonHandler, RemoteEndpoint remoteEndpoint) {
        MessageConsumer messageConsumer = this.wrapMessageConsumer((MessageConsumer)remoteEndpoint);
        this.webSocket.configureMessageHandlers(jsonHandler, remoteEndpoint, messageConsumer);
    }
}

