/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ai.ui.browser.websocket;

import org.eclipse.lsp4j.jsonrpc.MessageConsumer;
import org.eclipse.lsp4j.jsonrpc.json.MessageJsonHandler;
import org.eclipse.lsp4j.jsonrpc.messages.Message;
import ro.amiq.dvt.ai.AIUtils;
import ro.amiq.dvt.ai.model.LogSeverity;
import ro.amiq.dvt.ai.model.LogTarget;
import ro.amiq.dvt.ai.ui.browser.websocket.AIWebSocketClient;

public class WSMessageConsumer
implements MessageConsumer {
    private final MessageJsonHandler jsonHandler;
    private AIWebSocketClient webSocket;

    public WSMessageConsumer(AIWebSocketClient serverWebSocket, MessageJsonHandler jsonHandler) {
        this.webSocket = serverWebSocket;
        this.jsonHandler = jsonHandler;
    }

    public AIWebSocketClient getServerWebSocket() {
        return this.webSocket;
    }

    public void consume(Message message) {
        String content = this.jsonHandler.serialize(message);
        this.sendMessage(content);
    }

    protected void sendMessage(String message) {
        if (this.webSocket.isClosed()) {
            AIUtils.getInstance().writeToAiConsole(LogTarget.AI_CONSOLE, "Ignoring message due to closed web socket:" + message, LogSeverity.INFO, null);
            return;
        }
        this.webSocket.send(message);
    }
}

