/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ai.ui.preferences;

import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.ai.ChatSendKeyPref;
import ro.amiq.dvt.ui.preferences.PrefConst;

public class AIAssistantPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String INSERT_UNMODIFIED_REPLY_INFO = "Controls whether the model's reply is modified before being inserted into the editor." + System.lineSeparator() + "Modifications include commenting out parts of the reply which are not found within Markdown fenced code blocks.";
    private static final String ADD_GENERATED_CODE_WATERMARK_INFO = "Controls whether the AI-generated code is wrapped between" + System.lineSeparator() + "``@AI_GENERATED_CODE_BEGIN`` and ``@AI_GENERATED_CODE_END`` comments.";
    private static final String PRESENT_AI_CODE_COMPLETION_INFO = "Controls whether the AI-generated proposals can be accessed" + System.lineSeparator() + "from the 'default' content assist list.";
    private static final String INCLUDE_CLIPBOARD_CONTENT_TO_SNIPPET = "Controls whether the '@clipboard' snippet will expand to the clipboard contents.";
    private static final String SEND_KEY_PREFERENCE = "Controls the shortcut for sending a message in the chat prompt." + System.lineSeparator() + "Note: The alternate shortcut will be used to insert a new line.";
    private Button editorInsertUnmodifiedReplyEnableButton;
    private Button addGeneratedCodeWatermarkEnableButton;
    private Button accessProposalsInDefaultPageEnableButton;
    private Button enableClipboardSnippetButton;
    private Button automaticallyIncludeRelevantContextButton;
    private Combo sendKeyPreferenceControl;
    private Label sendKeyPreferenceLabel;

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(DVTPlugin.getDefault().getPreferenceStore());
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        GridDataFactory.fillDefaults().hint(parent.computeSize(-1, -1)).applyTo((Control)composite);
        this.insertUnmodifiedReplyEnablePref(composite);
        this.codeWatermarkEnablePref(composite);
        this.codeCompletionIncludeClipboardContextEnablePref(composite);
        this.sendKeyPref(composite);
        Group codeCompletionGroup = this.createCodeCompletionGroup(composite);
        this.codeCompletionEnablePref((Composite)codeCompletionGroup);
        return composite;
    }

    private void codeCompletionIncludeClipboardContextEnablePref(Composite composite) {
        this.enableClipboardSnippetButton = new Button(composite, 32);
        this.enableClipboardSnippetButton.setFont(composite.getFont());
        this.enableClipboardSnippetButton.setText("Enable expansion of '@clipboard' snippet");
        this.enableClipboardSnippetButton.setSelection(PrefConst.getAIAClipboardSnippet());
        GridDataFactory.fillDefaults().align(1, 0x1000000).span(3, 1).grab(false, false).applyTo((Control)this.enableClipboardSnippetButton);
        FieldDecoration enableClipboardSnippetInfoField = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_INFORMATION");
        ControlDecoration enableClipboardSnippetAutoDecoration = new ControlDecoration((Control)this.enableClipboardSnippetButton, 16512);
        enableClipboardSnippetAutoDecoration.setImage(enableClipboardSnippetInfoField.getImage());
        enableClipboardSnippetAutoDecoration.setDescriptionText(INCLUDE_CLIPBOARD_CONTENT_TO_SNIPPET);
    }

    private void sendPrefSetSelection(String selection) {
        if (selection.equals("Enter")) {
            this.sendKeyPreferenceControl.select(0);
        } else {
            this.sendKeyPreferenceControl.select(1);
        }
    }

    private void sendKeyPref(Composite composite) {
        this.sendKeyPreferenceLabel = new Label(composite, 0);
        this.sendKeyPreferenceControl = new Combo(composite, 12);
        this.sendKeyPreferenceControl.setFont(composite.getFont());
        this.sendKeyPreferenceLabel.setFont(composite.getFont());
        this.sendKeyPreferenceControl.add("Enter");
        this.sendKeyPreferenceControl.add("Shift + Enter");
        this.sendKeyPreferenceLabel.setText("Shortcut for sending a message in chat prompt:");
        this.sendPrefSetSelection(PrefConst.getAIASendKeyPreference().getValue());
        GridDataFactory.fillDefaults().align(1, 0x1000000).grab(false, false).applyTo((Control)this.sendKeyPreferenceLabel);
        GridDataFactory.fillDefaults().align(1, 0x1000000).grab(false, false).applyTo((Control)this.sendKeyPreferenceControl);
        FieldDecoration sendKeyPrefInfoField = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_INFORMATION");
        ControlDecoration sendKeyPrefAutoDecoration = new ControlDecoration((Control)this.sendKeyPreferenceLabel, 16512);
        sendKeyPrefAutoDecoration.setImage(sendKeyPrefInfoField.getImage());
        sendKeyPrefAutoDecoration.setDescriptionText(SEND_KEY_PREFERENCE);
    }

    private void insertUnmodifiedReplyEnablePref(Composite composite) {
        this.editorInsertUnmodifiedReplyEnableButton = new Button(composite, 32);
        this.editorInsertUnmodifiedReplyEnableButton.setFont(composite.getFont());
        this.editorInsertUnmodifiedReplyEnableButton.setText("Insert unmodified reply into the editor");
        this.editorInsertUnmodifiedReplyEnableButton.setSelection(PrefConst.getAIAEditorInsertUnmodifiedReply());
        GridDataFactory.fillDefaults().align(1, 0x1000000).span(3, 1).grab(false, false).applyTo((Control)this.editorInsertUnmodifiedReplyEnableButton);
        FieldDecoration insertUnmodifiedReplyInfoField = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_INFORMATION");
        ControlDecoration insertUnmodifiedReplyAutoDecoration = new ControlDecoration((Control)this.editorInsertUnmodifiedReplyEnableButton, 16512);
        insertUnmodifiedReplyAutoDecoration.setImage(insertUnmodifiedReplyInfoField.getImage());
        insertUnmodifiedReplyAutoDecoration.setDescriptionText(INSERT_UNMODIFIED_REPLY_INFO);
    }

    private void codeWatermarkEnablePref(Composite composite) {
        this.addGeneratedCodeWatermarkEnableButton = new Button(composite, 32);
        this.addGeneratedCodeWatermarkEnableButton.setFont(composite.getFont());
        this.addGeneratedCodeWatermarkEnableButton.setText("Add Generated Code Watermark");
        this.addGeneratedCodeWatermarkEnableButton.setSelection(PrefConst.getAIAAddGeneratedCodeWatermark());
        GridDataFactory.fillDefaults().align(1, 0x1000000).span(3, 1).grab(false, false).applyTo((Control)this.addGeneratedCodeWatermarkEnableButton);
        FieldDecoration addGeneratedCodeWatermarkInfoField = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_INFORMATION");
        ControlDecoration addGeneratedCodeWatermarkAutoDecoration = new ControlDecoration((Control)this.addGeneratedCodeWatermarkEnableButton, 16512);
        addGeneratedCodeWatermarkAutoDecoration.setImage(addGeneratedCodeWatermarkInfoField.getImage());
        addGeneratedCodeWatermarkAutoDecoration.setDescriptionText(ADD_GENERATED_CODE_WATERMARK_INFO);
    }

    private Group createCodeCompletionGroup(Composite composite) {
        Group codeCompletionGroup = new Group(composite, 16);
        codeCompletionGroup.setFont(composite.getFont());
        codeCompletionGroup.setLayout((Layout)new GridLayout(2, false));
        GridDataFactory.fillDefaults().span(2, -1).applyTo((Control)codeCompletionGroup);
        codeCompletionGroup.setText("Code Completion");
        return codeCompletionGroup;
    }

    private void codeCompletionEnablePref(Composite composite) {
        this.accessProposalsInDefaultPageEnableButton = new Button(composite, 32);
        this.accessProposalsInDefaultPageEnableButton.setFont(composite.getFont());
        this.accessProposalsInDefaultPageEnableButton.setText("Insert \"Show AI Assistant Code Completions ...\" in the 'default' content assist list");
        this.accessProposalsInDefaultPageEnableButton.setSelection(PrefConst.getAIAAccessProposalsInDefaultPage());
        GridDataFactory.fillDefaults().align(1, 0x1000000).span(3, 1).grab(false, false).applyTo((Control)this.accessProposalsInDefaultPageEnableButton);
        FieldDecoration presentAICodeCompletionInfoField = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_INFORMATION");
        ControlDecoration presentAICodeCompletionAutoDecoration = new ControlDecoration((Control)this.accessProposalsInDefaultPageEnableButton, 16512);
        presentAICodeCompletionAutoDecoration.setImage(presentAICodeCompletionInfoField.getImage());
        presentAICodeCompletionAutoDecoration.setDescriptionText(PRESENT_AI_CODE_COMPLETION_INFO);
    }

    protected void performDefaults() {
        super.performDefaults();
        this.editorInsertUnmodifiedReplyEnableButton.setSelection(DVTPlugin.getDefault().getPreferenceStore().getDefaultBoolean("ai.editorInsertUnmodifiedReplyEnable"));
        this.addGeneratedCodeWatermarkEnableButton.setSelection(DVTPlugin.getDefault().getPreferenceStore().getDefaultBoolean("ai.addGeneratedCodeWatermarkEnable"));
        this.accessProposalsInDefaultPageEnableButton.setSelection(DVTPlugin.getDefault().getPreferenceStore().getDefaultBoolean("ai.insertShowCodeCompletionsInDefaultListEnable"));
        this.enableClipboardSnippetButton.setSelection(DVTPlugin.getDefault().getPreferenceStore().getDefaultBoolean("ai.clipboardSnippetEnable"));
        this.sendPrefSetSelection(DVTPlugin.getDefault().getPreferenceStore().getDefaultString("ai.sendKeyPreference"));
    }

    public boolean performOk() {
        PrefConst.setAIAEditorInsertUnmodifiedReply((boolean)this.editorInsertUnmodifiedReplyEnableButton.getSelection());
        PrefConst.setAIAAddGeneratedCodeWatermark((boolean)this.addGeneratedCodeWatermarkEnableButton.getSelection());
        PrefConst.setAIAAccessProposalsInDefaultPage((boolean)this.accessProposalsInDefaultPageEnableButton.getSelection());
        PrefConst.setAIAClipboardSnippet((boolean)this.enableClipboardSnippetButton.getSelection());
        PrefConst.setAIASendKeyPreference((ChatSendKeyPref)ChatSendKeyPref.of((String)this.sendKeyPreferenceControl.getText()));
        DVTPlugin.getDefault().savePreferences();
        return true;
    }
}

