/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ai.ui.refactoring;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.ai.model.FileEdit;
import ro.amiq.dvt.ai.model.params.ApplyFileEditsParams;
import ro.amiq.dvt.ui.refactor.replace.DVTReplaceRefactoring;
import ro.amiq.dvt.ui.refactor.replace.IDVTReplaceRefactoringFactory;
import ro.amiq.dvt.ui.refactor.replace.params.ProjectChangesRaw;
import ro.amiq.dvt.ui.refactor.replace.params.ReplaceChangeRaw;
import ro.amiq.dvt.ui.refactor.replace.params.SingleFileChangesRaw;
import ro.amiq.dvt.utils.DVTFileUtils;

public class DVTReplaceRefactoringFactory
implements IDVTReplaceRefactoringFactory {
    private final List<FileEdit> edits;
    private String name;
    private String rootChangeName;
    private List<SingleFileChangesRaw> changesInFiles;

    public DVTReplaceRefactoringFactory(ApplyFileEditsParams params, String name, String rootChangeName) {
        this.edits = params.edits;
        this.name = name;
        this.rootChangeName = rootChangeName;
        this.createProjectChanges();
    }

    public DVTReplaceRefactoring createDVTReplaceRefactoring() {
        return new DVTReplaceRefactoring(this.createProjectChanges(), this.name, this.rootChangeName);
    }

    private ProjectChangesRaw createProjectChanges() {
        LinkedHashMap<String, SingleFileChangesRaw> filepathToFileChanges = new LinkedHashMap<String, SingleFileChangesRaw>();
        for (FileEdit edit : this.edits) {
            String filepath = edit.getFilePath();
            SingleFileChangesRaw fileChanges = (SingleFileChangesRaw)filepathToFileChanges.get(filepath);
            if (fileChanges == null) {
                ArrayList<ReplaceChangeRaw> fileChangesList = new ArrayList<ReplaceChangeRaw>();
                fileChangesList.add(new ReplaceChangeRaw(edit.getStartLine(), edit.getEndLine(), edit.getCode()));
                filepathToFileChanges.put(filepath, new SingleFileChangesRaw(filepath, fileChangesList));
                continue;
            }
            fileChanges.getFileChanges().add(new ReplaceChangeRaw(edit.getStartLine(), edit.getEndLine(), edit.getCode()));
        }
        this.changesInFiles = new ArrayList(filepathToFileChanges.values());
        IProject project = DVTFileUtils.getInstance().getSelectedProject();
        return new ProjectChangesRaw(project, this.changesInFiles);
    }

    public SingleFileChangesRaw getSingleFileChanges() {
        if (this.changesInFiles.size() != 1) {
            return null;
        }
        return this.changesInFiles.get(0);
    }

    public boolean refactoringPerformsSingleFileEdits() {
        return this.changesInFiles.size() == 1;
    }
}

