/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.kiml.service;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import de.cau.cs.kieler.core.alg.BasicProgressMonitor;
import de.cau.cs.kieler.core.alg.IKielerProgressMonitor;
import de.cau.cs.kieler.core.kgraph.KGraphElement;
import de.cau.cs.kieler.core.kgraph.KNode;
import de.cau.cs.kieler.core.properties.IProperty;
import de.cau.cs.kieler.core.properties.Property;
import de.cau.cs.kieler.core.util.Maybe;
import de.cau.cs.kieler.core.util.Pair;
import de.cau.cs.kieler.kiml.AbstractLayoutProvider;
import de.cau.cs.kieler.kiml.IGraphLayoutEngine;
import de.cau.cs.kieler.kiml.LayoutConfigService;
import de.cau.cs.kieler.kiml.RecursiveGraphLayoutEngine;
import de.cau.cs.kieler.kiml.config.CompoundLayoutConfig;
import de.cau.cs.kieler.kiml.config.ILayoutConfig;
import de.cau.cs.kieler.kiml.config.IMutableLayoutConfig;
import de.cau.cs.kieler.kiml.config.LayoutContext;
import de.cau.cs.kieler.kiml.config.VolatileLayoutConfig;
import de.cau.cs.kieler.kiml.klayoutdata.KShapeLayout;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.kiml.options.PortConstraints;
import de.cau.cs.kieler.kiml.options.SizeConstraint;
import de.cau.cs.kieler.kiml.service.IDiagramLayoutManager;
import de.cau.cs.kieler.kiml.service.KimlServicePlugin;
import de.cau.cs.kieler.kiml.service.LayoutManagersService;
import de.cau.cs.kieler.kiml.service.LayoutMapping;
import de.cau.cs.kieler.kiml.service.LayoutOptionManager;
import de.cau.cs.kieler.kiml.service.util.MonitoredOperation;
import de.cau.cs.kieler.kiml.util.KimlUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.statushandlers.StatusManager;

public class DiagramLayoutEngine {
    public static final DiagramLayoutEngine INSTANCE = new DiagramLayoutEngine();
    public static final IProperty<IDiagramLayoutManager<?>> DIAGRAM_LM = new Property("layoutEngine.diagramLayoutManager");
    public static final String PREF_DEBUG_OUTPUT = "kiml.debug.graph";
    public static final String PREF_EXEC_TIME_MEASUREMENT = "kiml.exectime.measure";
    private final IGraphLayoutEngine graphLayoutEngine = new RecursiveGraphLayoutEngine();
    private final LayoutOptionManager layoutOptionManager = new LayoutOptionManager();
    private final ExecutorService executorService = Executors.newCachedThreadPool();
    private final Multimap<Pair<IWorkbenchPart, Object>, MonitoredOperation> runningOperations = HashMultimap.create();
    public static final IProperty<IKielerProgressMonitor> PROGRESS_MONITOR = new Property("layout.progressMonitor");
    private static final float CONFIGURE_WORK = 1.0f;
    private static final float LAYOUT_WORK = 4.0f;
    private static final float TOTAL_WORK = 5.0f;
    private List<ILayoutTerminatedListener> layoutListeners = null;

    private static boolean isCanceled(ILayoutCancelationIndicator cancelIndicator) {
        return cancelIndicator != null && cancelIndicator.isCanceled();
    }

    public LayoutMapping<?> layout(IWorkbenchPart workbenchPart, Object diagramPart, boolean animate, boolean progressBar, boolean layoutAncestors, boolean zoomToFit) {
        return this.layout(workbenchPart, diagramPart, new ILayoutConfig[]{new VolatileLayoutConfig().setValue(LayoutOptions.ANIMATE, (Object)animate).setValue(LayoutOptions.PROGRESS_BAR, (Object)progressBar).setValue(LayoutOptions.LAYOUT_ANCESTORS, (Object)layoutAncestors).setValue(LayoutOptions.ZOOM_TO_FIT, (Object)zoomToFit)});
    }

    public LayoutMapping<?> layout(IWorkbenchPart workbenchPart, Object diagramPart, ILayoutConfig ... configurators) {
        return this.layout(workbenchPart, diagramPart, (ILayoutCancelationIndicator)null, configurators);
    }

    public LayoutMapping<?> layout(IWorkbenchPart workbenchPart, Object diagramPart, ILayoutCancelationIndicator cancelationIndicator, ILayoutConfig ... configurators) {
        IDiagramLayoutManager<?> layoutManager = LayoutManagersService.getInstance().getManager(workbenchPart, diagramPart);
        if (layoutManager != null) {
            LayoutMapping<?> mapping = this.layout(layoutManager, workbenchPart, diagramPart, cancelationIndicator, configurators);
            if (mapping != null) {
                mapping.setProperty(DIAGRAM_LM, layoutManager);
            }
            return mapping;
        }
        Status status = new Status(4, "de.cau.cs.kieler.kiml.service", workbenchPart == null ? "No layout manager is available for the selected part." : "No layout manager is available for " + workbenchPart.getTitle() + ".");
        StatusManager.getManager().handle((IStatus)status, 2);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> LayoutMapping<T> layout(final IDiagramLayoutManager<T> layoutManager, final IWorkbenchPart workbenchPart, final Object diagramPart, final ILayoutCancelationIndicator cancelationIndicator, final ILayoutConfig ... configurators) {
        final Maybe layoutMapping = Maybe.create();
        final Pair target = Pair.of((Object)workbenchPart, (Object)diagramPart);
        final ILayoutConfig globalConfig = configurators.length == 0 ? null : configurators[0];
        MonitoredOperation monitoredOperation = new MonitoredOperation(this.executorService){
            private final MonitoredOperation thisOperation;
            {
                super($anonymous0);
                this.thisOperation = this;
            }

            @Override
            protected IKielerProgressMonitor createMonitor() {
                return new CancelableProgressMonitorEx(cancelationIndicator);
            }

            @Override
            protected void preUIexec() {
                if (DiagramLayoutEngine.isCanceled(cancelationIndicator)) {
                    this.cancel();
                    return;
                }
                boolean layoutAncestors = (Boolean)DiagramLayoutEngine.this.layoutOptionManager.getGlobalValue(LayoutOptions.LAYOUT_ANCESTORS, globalConfig);
                layoutMapping.set(layoutManager.buildLayoutGraph(workbenchPart, layoutAncestors ? null : diagramPart));
            }

            @Override
            protected IStatus execute(IKielerProgressMonitor monitor) {
                Status status;
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                LayoutMapping mapping = (LayoutMapping)((Object)layoutMapping.get());
                if (mapping != null && mapping.getLayoutGraph() != null) {
                    Object transDiagPart = diagramPart;
                    IMutableLayoutConfig diagramConfig = layoutManager.getDiagramConfig();
                    if (diagramConfig != null) {
                        if (!mapping.getLayoutConfigs().contains(diagramConfig)) {
                            mapping.getLayoutConfigs().add((ILayoutConfig)diagramConfig);
                        }
                        if (diagramPart != null) {
                            LayoutContext context = new LayoutContext();
                            context.setProperty(LayoutContext.DIAGRAM_PART, diagramPart);
                            Object object = diagramConfig.getContextValue(LayoutContext.DIAGRAM_PART, context);
                            if (object != null) {
                                transDiagPart = object;
                            }
                        }
                    }
                    status = DiagramLayoutEngine.this.layout(mapping, transDiagPart, monitor, configurators);
                    if (!monitor.isCanceled()) {
                        DiagramLayoutEngine.this.stopEarlierOperations((Pair<IWorkbenchPart, Object>)target, this.getTimestamp());
                    }
                } else {
                    status = new Status(2, "de.cau.cs.kieler.kiml.service", "Unable to build the layout graph from the given workbench part.");
                }
                monitor.done();
                return status;
            }

            @Override
            protected void postUIexec() {
                if (DiagramLayoutEngine.isCanceled(cancelationIndicator)) {
                    this.cancel();
                    return;
                }
                if (layoutMapping.get() != null) {
                    boolean zoomToFit = (Boolean)DiagramLayoutEngine.this.layoutOptionManager.getGlobalValue(LayoutOptions.ZOOM_TO_FIT, globalConfig);
                    int animationTime = DiagramLayoutEngine.this.calcAnimationTime((LayoutMapping)((Object)layoutMapping.get()), configurators.length == 0 ? null : configurators[0], workbenchPart != null && !workbenchPart.getSite().getPage().isPartVisible(workbenchPart));
                    layoutManager.applyLayout((LayoutMapping)((Object)layoutMapping.get()), zoomToFit, animationTime);
                }
            }

            class CancelableProgressMonitorEx
            extends MonitoredOperation.CancelableProgressMonitor {
                private final /* synthetic */ ILayoutCancelationIndicator val$cancelationIndicator;

                CancelableProgressMonitorEx(ILayoutCancelationIndicator iLayoutCancelationIndicator) {
                    this.val$cancelationIndicator = iLayoutCancelationIndicator;
                    super(this);
                }

                @Override
                public boolean isCanceled() {
                    if (super.isCanceled()) {
                        return true;
                    }
                    if (DiagramLayoutEngine.isCanceled(this.val$cancelationIndicator)) {
                        thisOperation.cancel();
                        return true;
                    }
                    return false;
                }
            }
        };
        Multimap<Pair<IWorkbenchPart, Object>, MonitoredOperation> multimap = this.runningOperations;
        synchronized (multimap) {
            this.runningOperations.put((Object)target, (Object)monitoredOperation);
        }
        try {
            boolean progressBar = (Boolean)this.layoutOptionManager.getGlobalValue(LayoutOptions.PROGRESS_BAR, globalConfig);
            if (progressBar) {
                monitoredOperation.runMonitored();
            } else {
                monitoredOperation.runUnmonitored();
            }
        }
        catch (Throwable throwable) {
            Multimap<Pair<IWorkbenchPart, Object>, MonitoredOperation> multimap2 = this.runningOperations;
            synchronized (multimap2) {
                this.runningOperations.remove((Object)target, (Object)monitoredOperation);
            }
            throw throwable;
        }
        Multimap<Pair<IWorkbenchPart, Object>, MonitoredOperation> multimap3 = this.runningOperations;
        synchronized (multimap3) {
            this.runningOperations.remove((Object)target, (Object)monitoredOperation);
        }
        return (LayoutMapping)((Object)layoutMapping.get());
    }

    private int calcAnimationTime(LayoutMapping<?> mapping, ILayoutConfig config, boolean viewerNotVisible) {
        CompoundLayoutConfig clc = CompoundLayoutConfig.of((ILayoutConfig[])new ILayoutConfig[]{config});
        clc.addAll((Collection)LayoutConfigService.getInstance().getActiveConfigs());
        boolean animate = (Boolean)this.layoutOptionManager.getGlobalValue(LayoutOptions.ANIMATE, (ILayoutConfig)clc);
        if (animate) {
            int factor;
            int maxTime;
            int minTime = (Integer)this.layoutOptionManager.getGlobalValue(LayoutOptions.MIN_ANIMATION_TIME, (ILayoutConfig)clc);
            if (minTime < 0) {
                minTime = 0;
            }
            if ((maxTime = ((Integer)this.layoutOptionManager.getGlobalValue(LayoutOptions.MAX_ANIMATION_TIME, (ILayoutConfig)clc)).intValue()) < minTime) {
                maxTime = minTime;
            }
            if ((factor = ((Integer)this.layoutOptionManager.getGlobalValue(LayoutOptions.ANIMATION_TIME_FACTOR, (ILayoutConfig)clc)).intValue()) > 0) {
                int graphSize = DiagramLayoutEngine.countNodes(mapping.getLayoutGraph());
                int time = minTime + (int)((double)factor * Math.sqrt(graphSize));
                return time <= maxTime ? time : maxTime;
            }
            return minTime;
        }
        return 0;
    }

    private static int countNodes(KNode node) {
        int count = 0;
        for (KNode child : node.getChildren()) {
            count += DiagramLayoutEngine.countNodes(child) + 1;
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopEarlierOperations(Pair<IWorkbenchPart, Object> target, long time) {
        Multimap<Pair<IWorkbenchPart, Object>, MonitoredOperation> multimap = this.runningOperations;
        synchronized (multimap) {
            for (MonitoredOperation operation : this.runningOperations.get(target)) {
                if (operation.getTimestamp() >= time) continue;
                operation.cancel();
            }
        }
    }

    public IStatus layout(IWorkbenchPart workbenchPart, Object diagramPart, IKielerProgressMonitor progressMonitor) {
        IDiagramLayoutManager<?> layoutManager = LayoutManagersService.getInstance().getManager(workbenchPart, diagramPart);
        if (layoutManager != null) {
            return this.layout(layoutManager, workbenchPart, diagramPart, progressMonitor);
        }
        return new Status(4, "de.cau.cs.kieler.kiml.service", "No layout manager is available for the selected part.");
    }

    protected <T> IStatus layout(IDiagramLayoutManager<T> layoutManager, IWorkbenchPart workbenchPart, Object diagramPart, IKielerProgressMonitor progressMonitor) {
        Status status;
        Object monitor = progressMonitor == null ? new BasicProgressMonitor(0, KimlServicePlugin.getDefault().getPreferenceStore().getBoolean(PREF_EXEC_TIME_MEASUREMENT)) : progressMonitor;
        monitor.begin("Layout Diagram", 3.0f);
        IKielerProgressMonitor submon1 = monitor.subTask(1.0f);
        submon1.begin("Build layout graph", 1.0f);
        LayoutMapping<T> mapping = layoutManager.buildLayoutGraph(workbenchPart, diagramPart);
        if (mapping != null && mapping.getLayoutGraph() != null) {
            Object transDiagPart = diagramPart;
            IMutableLayoutConfig diagramConfig = layoutManager.getDiagramConfig();
            if (diagramConfig != null) {
                if (!mapping.getLayoutConfigs().contains(diagramConfig)) {
                    mapping.getLayoutConfigs().add((ILayoutConfig)diagramConfig);
                }
                if (diagramPart != null) {
                    LayoutContext context = new LayoutContext();
                    context.setProperty(LayoutContext.DIAGRAM_PART, diagramPart);
                    Object object = diagramConfig.getContextValue(LayoutContext.DIAGRAM_PART, context);
                    if (object != null) {
                        transDiagPart = object;
                    }
                }
            }
            submon1.done();
            status = this.layout(mapping, transDiagPart, monitor.subTask(1.0f), new ILayoutConfig[0]);
            IKielerProgressMonitor submon3 = monitor.subTask(1.0f);
            submon3.begin("Apply layout to the diagram", 1.0f);
            layoutManager.applyLayout(mapping, false, 0);
            submon3.done();
        } else {
            status = new Status(2, "de.cau.cs.kieler.kiml.service", "Unable to build the layout graph from the given workbench part.");
        }
        monitor.done();
        return status;
    }

    public LayoutOptionManager getOptionManager() {
        return this.layoutOptionManager;
    }

    protected IStatus layout(LayoutMapping<?> mapping, Object diagramPart, IKielerProgressMonitor progressMonitor, ILayoutConfig ... configurators) {
        KGraphElement graphElem;
        ILayoutConfig globalConfig = configurators.length == 0 ? null : configurators[0];
        boolean layoutAncestors = (Boolean)this.layoutOptionManager.getGlobalValue(LayoutOptions.LAYOUT_ANCESTORS, globalConfig);
        if (layoutAncestors && (graphElem = (KGraphElement)mapping.getGraphMap().inverse().get(diagramPart)) instanceof KNode && ((KNode)graphElem).getParent() != null) {
            KNode parent;
            KNode node = (KNode)graphElem;
            VolatileLayoutConfig vlc = new VolatileLayoutConfig();
            do {
                parent = node.getParent();
                for (KNode child : parent.getChildren()) {
                    if (child == node) continue;
                    vlc.setValue(LayoutOptions.NO_LAYOUT, (Object)child, LayoutContext.GRAPH_ELEM, (Object)true);
                    vlc.setValue(LayoutOptions.SIZE_CONSTRAINT, (Object)child, LayoutContext.GRAPH_ELEM, (Object)SizeConstraint.fixed());
                    vlc.setValue(LayoutOptions.PORT_CONSTRAINTS, (Object)child, LayoutContext.GRAPH_ELEM, (Object)PortConstraints.FIXED_POS);
                }
            } while ((node = parent).getParent() != null);
            mapping.getLayoutConfigs().add((ILayoutConfig)vlc);
        }
        mapping.setProperty(PROGRESS_MONITOR, progressMonitor);
        IStatus status = null;
        if (configurators.length == 0) {
            status = this.layout(mapping, progressMonitor);
        } else if (configurators.length == 1) {
            mapping.getLayoutConfigs().add(configurators[0]);
            status = this.layout(mapping, progressMonitor);
        } else {
            progressMonitor.begin("Diagram layout engine", 5.0f * (float)configurators.length);
            ILayoutConfig[] iLayoutConfigArray = configurators;
            int n = configurators.length;
            int n2 = 0;
            while (n2 < n) {
                ILayoutConfig config = iLayoutConfigArray[n2];
                mapping.getLayoutConfigs().add(config);
                status = this.layout(mapping, progressMonitor);
                if (!status.isOK()) break;
                mapping.getLayoutConfigs().remove(config);
                ++n2;
            }
            progressMonitor.done();
        }
        if (this.layoutListeners != null) {
            for (ILayoutTerminatedListener listener : this.layoutListeners) {
                listener.layoutDone(mapping.getLayoutGraph(), progressMonitor);
            }
        }
        return status;
    }

    public IStatus layout(LayoutMapping<?> mapping, IKielerProgressMonitor progressMonitor) {
        if (progressMonitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        boolean newTask = progressMonitor.begin("Diagram layout engine", 5.0f);
        if (mapping.getProperty(PROGRESS_MONITOR) == null) {
            mapping.setProperty(PROGRESS_MONITOR, progressMonitor);
        }
        try {
            try {
                this.layoutOptionManager.configure(mapping, progressMonitor.subTask(1.0f));
            }
            catch (Throwable t) {
                if (progressMonitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                throw t;
            }
            if (KimlServicePlugin.getDefault().getPreferenceStore().getBoolean(PREF_DEBUG_OUTPUT)) {
                this.exportLayoutGraph(mapping.getLayoutGraph());
            }
            this.graphLayoutEngine.layout(mapping.getLayoutGraph(), progressMonitor.subTask(4.0f));
            ILayoutConfig addConfig = (ILayoutConfig)((KShapeLayout)mapping.getLayoutGraph().getData(KShapeLayout.class)).getProperty(AbstractLayoutProvider.ADD_LAYOUT_CONFIG);
            if (addConfig != null) {
                mapping.getLayoutConfigs().add(addConfig);
            }
            if (newTask) {
                progressMonitor.done();
            }
            if (progressMonitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            return Status.OK_STATUS;
        }
        catch (Throwable exception) {
            return new Status(4, "de.cau.cs.kieler.kiml.service", "Failed to perform diagram layout.", exception);
        }
    }

    public void addListener(ILayoutTerminatedListener listener) {
        this.addLayoutTerminatedListener(listener);
    }

    public void addLayoutTerminatedListener(ILayoutTerminatedListener listener) {
        if (this.layoutListeners == null) {
            this.layoutListeners = new LinkedList<ILayoutTerminatedListener>();
        }
        this.layoutListeners.add(listener);
    }

    public void removeLayoutTerminatedListener(ILayoutTerminatedListener listener) {
        if (this.layoutListeners == null) {
            return;
        }
        this.layoutListeners.remove(listener);
    }

    private void exportLayoutGraph(KNode graph) {
        String path = System.getProperty("user.home");
        if (path != null) {
            path = path.endsWith(File.separator) ? String.valueOf(path) + "tmp" + File.separator + "layout" + File.separator + Integer.toHexString(graph.hashCode()) + ".kgraph" : String.valueOf(path) + File.separator + "tmp" + File.separator + "layout" + File.separator + Integer.toHexString(graph.hashCode()) + ".kgraph";
            KimlUtil.persistDataElements((KNode)graph);
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            Resource resource = resourceSet.createResource(URI.createFileURI((String)path));
            resource.getContents().add((Object)graph);
            try {
                resource.save(Collections.emptyMap());
            }
            catch (IOException iOException) {}
        }
    }

    public static interface ILayoutCancelationIndicator {
        public boolean isCanceled();
    }

    public static interface ILayoutTerminatedListener {
        public void layoutDone(KNode var1, IKielerProgressMonitor var2);
    }
}

