/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.kiml.service;

import de.cau.cs.kieler.core.properties.IProperty;
import de.cau.cs.kieler.core.properties.Property;
import de.cau.cs.kieler.kiml.LayoutConfigService;
import de.cau.cs.kieler.kiml.LayoutMetaDataService;
import de.cau.cs.kieler.kiml.LayoutOptionData;
import de.cau.cs.kieler.kiml.config.DefaultLayoutConfig;
import de.cau.cs.kieler.kiml.config.ILayoutConfig;
import de.cau.cs.kieler.kiml.config.LayoutContext;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.kiml.options.PortConstraints;
import de.cau.cs.kieler.kiml.options.SizeConstraint;
import de.cau.cs.kieler.kiml.service.ExtensionLayoutConfigService;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.ui.IWorkbenchPart;

public class EclipseLayoutConfig
implements ILayoutConfig {
    public static final Property<Boolean> ACTIVATION = new Property("de.cau.cs.kieler.kiml.eclipse", (Object)true);
    public static final int PRIORITY = 10;
    public static final IProperty<IWorkbenchPart> WORKBENCH_PART = new Property("context.workbenchPart");
    public static final IProperty<EditingDomain> EDITING_DOMAIN = new Property("context.editingDomain");
    public static final IProperty<Float> ASPECT_RATIO = new Property("context.aspectRatio");

    public static Object getValue(IProperty<?> property, Object diagramPart, Object modelElement) {
        String clazzName;
        Object value;
        LayoutConfigService configService = LayoutConfigService.getInstance();
        String id = property.getId();
        if (diagramPart != null && (value = configService.getOptionValue(clazzName = diagramPart.getClass().getName(), id)) != null) {
            return value;
        }
        if (modelElement instanceof EObject) {
            EClass eclazz = ((EObject)modelElement).eClass();
            value = configService.getOptionValue(eclazz, id);
            if (value != null) {
                return value;
            }
        } else if (modelElement != null) {
            clazzName = modelElement.getClass().getName();
            value = configService.getOptionValue(clazzName, id);
            if (value != null) {
                return value;
            }
        } else {
            Object value2 = configService.getOptionValue("de.cau.cs.kieler.layout.globalConfig", id);
            return value2;
        }
        return null;
    }

    public int getPriority() {
        return 10;
    }

    public Object getContextValue(IProperty<?> property, LayoutContext context) {
        if (property.equals((Object)DefaultLayoutConfig.CONTENT_DIAGT)) {
            Object diagPart = context.getProperty(LayoutContext.DIAGRAM_PART);
            Object domainElem = context.getProperty(LayoutContext.DOMAIN_MODEL);
            return EclipseLayoutConfig.getValue(LayoutOptions.DIAGRAM_TYPE, diagPart, domainElem);
        }
        if (property.equals((Object)DefaultLayoutConfig.CONTAINER_DIAGT)) {
            Object containerDiagPart = context.getProperty(LayoutContext.CONTAINER_DIAGRAM_PART);
            Object containerDomainElem = context.getProperty(LayoutContext.CONTAINER_DOMAIN_MODEL);
            return EclipseLayoutConfig.getValue(LayoutOptions.DIAGRAM_TYPE, containerDiagPart, containerDomainElem);
        }
        if (property.equals((Object)DefaultLayoutConfig.CONTENT_HINT)) {
            Object domainElem;
            Object diagPart = context.getProperty(LayoutContext.DIAGRAM_PART);
            String layoutHint = (String)EclipseLayoutConfig.getValue(LayoutOptions.ALGORITHM, diagPart, domainElem = context.getProperty(LayoutContext.DOMAIN_MODEL));
            if (layoutHint == null) {
                String diagramType = (String)context.getProperty(DefaultLayoutConfig.CONTENT_DIAGT);
                layoutHint = (String)ExtensionLayoutConfigService.getInstance().getOptionValue(diagramType, LayoutOptions.ALGORITHM.getId());
            }
            return layoutHint;
        }
        if (property.equals((Object)DefaultLayoutConfig.CONTAINER_HINT)) {
            Object containerDomainElem;
            Object containerDiagPart = context.getProperty(LayoutContext.CONTAINER_DIAGRAM_PART);
            String containerLayoutHint = (String)EclipseLayoutConfig.getValue(LayoutOptions.ALGORITHM, containerDiagPart, containerDomainElem = context.getProperty(LayoutContext.CONTAINER_DOMAIN_MODEL));
            if (containerLayoutHint == null) {
                String containerDiagramType = (String)context.getProperty(DefaultLayoutConfig.CONTAINER_DIAGT);
                containerLayoutHint = (String)LayoutConfigService.getInstance().getOptionValue(containerDiagramType, LayoutOptions.ALGORITHM.getId());
            }
            return containerLayoutHint;
        }
        return null;
    }

    public Object getOptionValue(LayoutOptionData optionData, LayoutContext context) {
        LayoutConfigService configService = LayoutConfigService.getInstance();
        Object result = null;
        result = EclipseLayoutConfig.getValue(optionData, context.getProperty(LayoutContext.DIAGRAM_PART), context.getProperty(LayoutContext.DOMAIN_MODEL));
        if (result != null) {
            return result;
        }
        if (optionData.getTargets().contains(LayoutOptionData.Target.PARENTS) ? (result = configService.getOptionValue((String)context.getProperty(DefaultLayoutConfig.CONTENT_DIAGT), optionData.getId())) != null : (result = configService.getOptionValue((String)context.getProperty(DefaultLayoutConfig.CONTAINER_DIAGT), optionData.getId())) != null) {
            return result;
        }
        if (LayoutOptions.SIZE_CONSTRAINT.equals(optionData)) {
            return this.getSizeConstraintValue(context);
        }
        if (LayoutOptions.PORT_CONSTRAINTS.equals(optionData)) {
            return this.getPortConstraintsValue(context);
        }
        if (LayoutOptions.ASPECT_RATIO.equals(optionData)) {
            return this.getAspectRatioValue(context);
        }
        return null;
    }

    private EnumSet<SizeConstraint> getSizeConstraintValue(LayoutContext context) {
        Set targets = (Set)context.getProperty(LayoutContext.OPT_TARGETS);
        if (targets != null && targets.contains(LayoutOptionData.Target.NODES)) {
            if (!targets.contains(LayoutOptionData.Target.PARENTS)) {
                return SizeConstraint.fixed();
            }
            Boolean hasPorts = (Boolean)context.getProperty(DefaultLayoutConfig.HAS_PORTS);
            if (hasPorts != null && hasPorts.booleanValue()) {
                return SizeConstraint.minimumSizeWithPorts();
            }
            return EnumSet.of(SizeConstraint.MINIMUM_SIZE);
        }
        return null;
    }

    private PortConstraints getPortConstraintsValue(LayoutContext context) {
        Set targets = (Set)context.getProperty(LayoutContext.OPT_TARGETS);
        Boolean hasPorts = (Boolean)context.getProperty(DefaultLayoutConfig.HAS_PORTS);
        if (targets != null && targets.contains(LayoutOptionData.Target.NODES) && hasPorts != null) {
            if (!targets.contains(LayoutOptionData.Target.PARENTS) && hasPorts.booleanValue()) {
                return PortConstraints.FIXED_POS;
            }
            return PortConstraints.FREE;
        }
        return null;
    }

    private Float getAspectRatioValue(LayoutContext context) {
        Float aspectRatio = (Float)context.getProperty(ASPECT_RATIO);
        if (aspectRatio != null && aspectRatio.floatValue() > 0.0f) {
            return aspectRatio;
        }
        return null;
    }

    public Collection<IProperty<?>> getAffectedOptions(LayoutContext context) {
        LayoutOptionData optionData;
        Float aspectRatio;
        LinkedList options = new LinkedList();
        Set targets = (Set)context.getProperty(LayoutContext.OPT_TARGETS);
        if (targets != null && targets.contains(LayoutOptionData.Target.NODES)) {
            options.add(LayoutOptions.SIZE_CONSTRAINT);
            Boolean hasPorts = (Boolean)context.getProperty(DefaultLayoutConfig.HAS_PORTS);
            if (hasPorts != null) {
                options.add(LayoutOptions.PORT_CONSTRAINTS);
            }
        }
        if ((aspectRatio = (Float)context.getProperty(ASPECT_RATIO)) != null && aspectRatio.floatValue() > 0.0f) {
            options.add(LayoutOptions.ASPECT_RATIO);
        }
        LayoutConfigService configService = LayoutConfigService.getInstance();
        LayoutMetaDataService dataService = LayoutMetaDataService.getInstance();
        Object diagPart = context.getProperty(LayoutContext.DIAGRAM_PART);
        Object modelElement = context.getProperty(LayoutContext.DOMAIN_MODEL);
        String diagramType = (String)context.getProperty(DefaultLayoutConfig.CONTENT_DIAGT);
        if (diagramType != null) {
            for (Map.Entry entry : configService.getOptionValues(diagramType).entrySet()) {
                LayoutOptionData optionData2;
                if (entry.getValue() == null || (optionData2 = dataService.getOptionData((String)entry.getKey())) == null) continue;
                options.add((IProperty<?>)optionData2);
            }
        }
        if (modelElement != null) {
            Map domainOptionsMap = modelElement instanceof EObject ? configService.getOptionValues(((EObject)modelElement).eClass()) : configService.getOptionValues(modelElement.getClass().getName());
            for (Map.Entry entry : domainOptionsMap.entrySet()) {
                if (entry.getValue() == null || (optionData = dataService.getOptionData((String)entry.getKey())) == null) continue;
                options.add((IProperty<?>)optionData);
            }
        }
        if (diagPart != null) {
            String clazzName = diagPart.getClass().getName();
            for (Map.Entry entry : configService.getOptionValues(clazzName).entrySet()) {
                if (entry.getValue() == null || (optionData = dataService.getOptionData((String)entry.getKey())) == null) continue;
                options.add((IProperty<?>)optionData);
            }
        }
        return options;
    }
}

