/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.kiml.service;

import de.cau.cs.kieler.core.properties.IProperty;
import de.cau.cs.kieler.core.properties.Property;
import de.cau.cs.kieler.core.util.Pair;
import de.cau.cs.kieler.kiml.LayoutConfigService;
import de.cau.cs.kieler.kiml.LayoutMetaDataService;
import de.cau.cs.kieler.kiml.LayoutOptionData;
import de.cau.cs.kieler.kiml.config.ILayoutConfig;
import de.cau.cs.kieler.kiml.config.LayoutContext;
import de.cau.cs.kieler.kiml.config.SemanticLayoutConfig;
import de.cau.cs.kieler.kiml.service.KimlServicePlugin;
import de.cau.cs.kieler.kiml.service.LayoutManagersService;
import de.cau.cs.kieler.kiml.util.LayoutOptionProxy;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.statushandlers.StatusManager;

public class ExtensionLayoutConfigService
extends LayoutConfigService {
    public static final String PREF_REG_ELEMENTS = "kiml.reg.elements";
    protected static final String EXTP_ID_LAYOUT_CONFIGS = "de.cau.cs.kieler.kiml.layoutConfigs";
    protected static final String ELEMENT_DIAGRAM_TYPE = "diagramType";
    protected static final String ELEMENT_STATIC_CONFIG = "staticConfig";
    protected static final String ELEMENT_SEMANTIC_CONFIG = "semanticConfig";
    protected static final String ELEMENT_CUSTOM_CONFIG = "customConfig";
    protected static final String ELEMENT_GLOBAL_STATIC_CONFIG = "globalStaticConfig";
    protected static final String ATTRIBUTE_ACTIVATION = "activation";
    protected static final String ATTRIBUTE_ACTIVATION_ACTION = "activationAction";
    protected static final String ATTRIBUTE_ACTIVATION_TEXT = "activationText";
    protected static final String ATTRIBUTE_CLASS = "class";
    protected static final String ATTRIBUTE_CONFIG = "config";
    protected static final String ATTRIBUTE_DEFAULT = "default";
    protected static final String ATTRIBUTE_ID = "id";
    protected static final String ATTRIBUTE_NAME = "name";
    protected static final String ATTRIBUTE_OPTION = "option";
    protected static final String ATTRIBUTE_VALUE = "value";
    protected static final String GLOBAL_OPTION_VALUE_ID = "de.cau.cs.kieler.layout.globalConfig";
    private final Set<String> registeredElements = new HashSet<String>();

    public ExtensionLayoutConfigService() {
        this.loadLayoutConfigsExtensions();
        this.loadPreferences();
    }

    protected void reportError(String extensionPoint, IConfigurationElement element, String attribute, Throwable exception) {
        String message = element != null && attribute != null ? "Extension point " + extensionPoint + ": Invalid entry in attribute '" + attribute + "' of element " + element.getName() + ", contributed by " + element.getContributor().getName() : "Extension point " + extensionPoint + ": An error occured while loading extensions.";
        Status status = new Status(2, "de.cau.cs.kieler.kiml.service", 0, message, exception);
        StatusManager.getManager().handle((IStatus)status);
    }

    protected void reportError(CoreException exception) {
        StatusManager.getManager().handle(exception, "de.cau.cs.kieler.kiml.service");
    }

    private void loadLayoutConfigsExtensions() {
        IConfigurationElement[] extensions = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTP_ID_LAYOUT_CONFIGS);
        LayoutMetaDataService layoutDataService = LayoutMetaDataService.getInstance();
        assert (layoutDataService != null);
        IConfigurationElement[] iConfigurationElementArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            block40: {
                IConfigurationElement element = iConfigurationElementArray[n2];
                if (ELEMENT_DIAGRAM_TYPE.equals(element.getName())) {
                    String id = element.getAttribute(ATTRIBUTE_ID);
                    String name = element.getAttribute(ATTRIBUTE_NAME);
                    if (id == null || id.length() == 0) {
                        this.reportError(EXTP_ID_LAYOUT_CONFIGS, element, ATTRIBUTE_ID, null);
                    } else if (name == null) {
                        this.reportError(EXTP_ID_LAYOUT_CONFIGS, element, ATTRIBUTE_NAME, null);
                    } else {
                        this.addDiagramType(id, name);
                    }
                } else if (ELEMENT_STATIC_CONFIG.equals(element.getName())) {
                    String classId = element.getAttribute(ATTRIBUTE_CLASS);
                    String optionId = element.getAttribute(ATTRIBUTE_OPTION);
                    String valueString = element.getAttribute(ATTRIBUTE_VALUE);
                    if (classId == null || classId.length() == 0) {
                        this.reportError(EXTP_ID_LAYOUT_CONFIGS, element, ATTRIBUTE_CLASS, null);
                    } else if (optionId == null || optionId.length() == 0) {
                        this.reportError(EXTP_ID_LAYOUT_CONFIGS, element, ATTRIBUTE_OPTION, null);
                    } else {
                        LayoutOptionData optionData = layoutDataService.getOptionData(optionId);
                        if (optionData != null) {
                            try {
                                Object value = optionData.parseValue(valueString);
                                if (value != null) {
                                    this.addOptionValue(classId, optionId, value);
                                }
                            }
                            catch (IllegalStateException exception) {
                                this.reportError(EXTP_ID_LAYOUT_CONFIGS, element, ATTRIBUTE_VALUE, exception);
                            }
                        } else if (valueString != null) {
                            this.addOptionValue(classId, optionId, new LayoutOptionProxy(valueString));
                        }
                    }
                } else if (ELEMENT_SEMANTIC_CONFIG.equals(element.getName())) {
                    try {
                        SemanticLayoutConfig config = (SemanticLayoutConfig)element.createExecutableExtension(ATTRIBUTE_CONFIG);
                        String clazz = element.getAttribute(ATTRIBUTE_CLASS);
                        if (clazz == null || clazz.length() == 0) {
                            this.reportError(EXTP_ID_LAYOUT_CONFIGS, element, ATTRIBUTE_CLASS, null);
                            break block40;
                        }
                        this.addSemanticConfig(clazz, config);
                    }
                    catch (CoreException exception) {
                        this.reportError(exception);
                    }
                } else if (ELEMENT_CUSTOM_CONFIG.equals(element.getName())) {
                    try {
                        LayoutConfigService.ConfigData data = new LayoutConfigService.ConfigData();
                        data.setConfig((ILayoutConfig)element.createExecutableExtension(ATTRIBUTE_CLASS));
                        String activationId = element.getAttribute(ATTRIBUTE_ACTIVATION);
                        if (activationId != null) {
                            String def = element.getAttribute(ATTRIBUTE_DEFAULT);
                            Boolean defaultActivation = def == null ? Boolean.FALSE : Boolean.valueOf(def);
                            data.setActivationProperty((IProperty)new Property(activationId, (Object)defaultActivation));
                        }
                        String text = element.getAttribute(ATTRIBUTE_ACTIVATION_TEXT);
                        data.setActivationText(text);
                        if (element.getAttribute(ATTRIBUTE_ACTIVATION_ACTION) != null) {
                            Runnable action = (Runnable)element.createExecutableExtension(ATTRIBUTE_ACTIVATION_ACTION);
                            data.setActivationAction(action);
                        }
                        this.addCustomConfig(data);
                    }
                    catch (CoreException exception) {
                        this.reportError(exception);
                    }
                } else if (ELEMENT_GLOBAL_STATIC_CONFIG.equals(element.getName())) {
                    String optionId = element.getAttribute(ATTRIBUTE_OPTION);
                    String valueString = element.getAttribute(ATTRIBUTE_VALUE);
                    if (optionId == null || optionId.length() == 0) {
                        this.reportError(EXTP_ID_LAYOUT_CONFIGS, element, ATTRIBUTE_OPTION, null);
                    } else {
                        LayoutOptionData optionData = layoutDataService.getOptionData(optionId);
                        if (optionData != null) {
                            try {
                                Object value = optionData.parseValue(valueString);
                                if (value != null) {
                                    this.addOptionValue(GLOBAL_OPTION_VALUE_ID, optionId, value);
                                }
                            }
                            catch (IllegalStateException exception) {
                                this.reportError(EXTP_ID_LAYOUT_CONFIGS, element, ATTRIBUTE_VALUE, exception);
                            }
                        } else if (valueString != null) {
                            this.addOptionValue(GLOBAL_OPTION_VALUE_ID, optionId, new LayoutOptionProxy(valueString));
                        }
                    }
                }
            }
            ++n2;
        }
    }

    public static String getPreferenceName(String id1, String id2) {
        return String.valueOf(id1) + "-" + id2;
    }

    public void storeOption(String diagramType, LayoutOptionData optionData, String valueString) {
        Object value = optionData.parseValue(valueString);
        if (value != null) {
            this.addOptionValue(diagramType, optionData.getId(), value);
            IPreferenceStore preferenceStore = KimlServicePlugin.getDefault().getPreferenceStore();
            preferenceStore.setValue(ExtensionLayoutConfigService.getPreferenceName(diagramType, optionData.getId()), valueString);
        }
    }

    public void storeOption(Object diagramPart, LayoutOptionData optionData, String valueString, boolean storeDomainModel) {
        Object value = optionData.parseValue(valueString);
        if (value != null) {
            Object object;
            if (storeDomainModel) {
                object = LayoutManagersService.getInstance().getContextValue(LayoutContext.DOMAIN_MODEL, null, diagramPart);
            } else {
                object = LayoutManagersService.getInstance().getContextValue(LayoutContext.DIAGRAM_PART, null, diagramPart);
                if (object == null) {
                    object = diagramPart;
                }
            }
            if (object != null) {
                String clazzName = object instanceof EObject ? ((EObject)object).eClass().getInstanceTypeName() : object.getClass().getName();
                this.addOptionValue(clazzName, optionData.getId(), value);
                this.registeredElements.add(clazzName);
                IPreferenceStore preferenceStore = KimlServicePlugin.getDefault().getPreferenceStore();
                preferenceStore.setValue(ExtensionLayoutConfigService.getPreferenceName(clazzName, optionData.getId()), valueString);
            }
        }
    }

    private void loadPreferences() {
        IPreferenceStore preferenceStore = KimlServicePlugin.getDefault().getPreferenceStore();
        LayoutMetaDataService layoutDataService = LayoutMetaDataService.getInstance();
        List diagramTypes = this.getDiagramTypes();
        Collection layoutOptionData = layoutDataService.getOptionData();
        for (Pair diagramType : diagramTypes) {
            for (LayoutOptionData data : layoutOptionData) {
                Object value;
                String preference = ExtensionLayoutConfigService.getPreferenceName((String)diagramType.getFirst(), data.getId());
                if (!preferenceStore.contains(preference) || (value = data.parseValue(preferenceStore.getString(preference))) == null) continue;
                this.addOptionValue((String)diagramType.getFirst(), data.getId(), value);
            }
        }
        StringTokenizer editPartsTokenizer = new StringTokenizer(preferenceStore.getString(PREF_REG_ELEMENTS), ";");
        while (editPartsTokenizer.hasMoreTokens()) {
            this.registeredElements.add(editPartsTokenizer.nextToken());
        }
        for (String elementName : this.registeredElements) {
            for (LayoutOptionData data : layoutOptionData) {
                Object value;
                String preference = ExtensionLayoutConfigService.getPreferenceName(elementName, data.getId());
                if (!preferenceStore.contains(preference) || (value = data.parseValue(preferenceStore.getString(preference))) == null) continue;
                this.addOptionValue(elementName, data.getId(), value);
            }
        }
    }

    protected void storePreferences() {
        IPreferenceStore preferenceStore = KimlServicePlugin.getDefault().getPreferenceStore();
        StringBuilder elementsString = new StringBuilder();
        for (String elementName : this.registeredElements) {
            elementsString.append(String.valueOf(elementName) + ";");
        }
        preferenceStore.setValue(PREF_REG_ELEMENTS, elementsString.toString());
    }

    public Set<String> getRegisteredElements() {
        return this.registeredElements;
    }

    public static void fillConfigMenu(IMenuManager menuManager) {
        final LayoutConfigService service = ExtensionLayoutConfigService.getInstance();
        for (LayoutConfigService.ConfigData data : service.getConfigData()) {
            if (data.getActivationText() == null || data.getActivationText().length() <= 0 || data.getActivationProperty() == null) continue;
            final String text = data.getActivationText();
            final IProperty activation = data.getActivationProperty();
            final Runnable activationAction = data.getActivationAction();
            menuManager.add((IContributionItem)new ContributionItem(){

                public void fill(Menu parent, int index) {
                    final MenuItem menuItem = new MenuItem(parent, 32, index);
                    menuItem.setText(text);
                    menuItem.setSelection(((Boolean)service.getConfigProperties().getProperty(activation)).booleanValue());
                    menuItem.addSelectionListener(new SelectionListener(){

                        public void widgetSelected(SelectionEvent e) {
                            service.getConfigProperties().setProperty(activation, (Object)menuItem.getSelection());
                            if (activationAction != null) {
                                activationAction.run();
                            }
                        }

                        public void widgetDefaultSelected(SelectionEvent e) {
                        }
                    });
                    if (activationAction != null) {
                        activationAction.run();
                    }
                }
            });
        }
    }
}

