/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.kiml.service;

import de.cau.cs.kieler.core.alg.DefaultFactory;
import de.cau.cs.kieler.core.alg.IFactory;
import de.cau.cs.kieler.core.properties.IProperty;
import de.cau.cs.kieler.core.util.Pair;
import de.cau.cs.kieler.kiml.config.IMutableLayoutConfig;
import de.cau.cs.kieler.kiml.config.LayoutContext;
import de.cau.cs.kieler.kiml.service.EclipseLayoutConfig;
import de.cau.cs.kieler.kiml.service.IDiagramLayoutManager;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.statushandlers.StatusManager;

public class LayoutManagersService {
    public static final String PREF_OBLIQUE_ROUTE = "kiml.oblique.route";
    protected static final String EXTP_ID_LAYOUT_MANAGERS = "de.cau.cs.kieler.kiml.service.layoutManagers";
    protected static final String ELEMENT_MANAGER = "manager";
    protected static final String ATTRIBUTE_CLASS = "class";
    protected static final String ATTRIBUTE_PRIORITY = "priority";
    private static LayoutManagersService instance;
    private static IFactory<? extends LayoutManagersService> instanceFactory;
    private final List<Pair<Integer, IDiagramLayoutManager<?>>> managers = new LinkedList();

    static {
        instanceFactory = new DefaultFactory(LayoutManagersService.class);
    }

    public static synchronized LayoutManagersService getInstance() {
        if (instance == null) {
            instance = (LayoutManagersService)instanceFactory.create();
        }
        return instance;
    }

    public static void setInstanceFactory(IFactory<? extends LayoutManagersService> factory) {
        if (factory == null) {
            throw new NullPointerException("The given instance factory is null");
        }
        instanceFactory = factory;
        instance = null;
    }

    public LayoutManagersService() {
        this.loadLayoutManagerExtensions();
    }

    protected void reportError(String extensionPoint, IConfigurationElement element, String attribute, Throwable exception) {
        String message = element != null && attribute != null ? "Extension point " + extensionPoint + ": Invalid entry in attribute '" + attribute + "' of element " + element.getName() + ", contributed by " + element.getContributor().getName() : "Extension point " + extensionPoint + ": An error occured while loading extensions.";
        Status status = new Status(2, "de.cau.cs.kieler.kiml.service", 0, message, exception);
        StatusManager.getManager().handle((IStatus)status);
    }

    protected void reportError(CoreException exception) {
        StatusManager.getManager().handle(exception, "de.cau.cs.kieler.kiml.service");
    }

    public final IDiagramLayoutManager<?> getManager(IWorkbenchPart workbenchPart, Object diagramPart) {
        for (Pair<Integer, IDiagramLayoutManager<?>> entry : this.managers) {
            IDiagramLayoutManager manager = (IDiagramLayoutManager)entry.getSecond();
            if (!(workbenchPart == null ? manager.supports(diagramPart) : manager.supports(workbenchPart) && (diagramPart == null || manager.supports(diagramPart)))) continue;
            return manager;
        }
        return null;
    }

    public final Object getContextValue(IProperty<?> contextProperty, IWorkbenchPart workbenchPart, Object diagramPart) {
        IMutableLayoutConfig config;
        IDiagramLayoutManager<?> manager = this.getManager(workbenchPart, diagramPart);
        if (manager != null && (config = manager.getDiagramConfig()) != null) {
            LayoutContext context = new LayoutContext();
            context.setProperty(EclipseLayoutConfig.WORKBENCH_PART, (Object)workbenchPart);
            context.setProperty(LayoutContext.DIAGRAM_PART, diagramPart);
            return config.getContextValue(contextProperty, context);
        }
        return null;
    }

    private void loadLayoutManagerExtensions() {
        IConfigurationElement[] extensions;
        IConfigurationElement[] iConfigurationElementArray = extensions = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTP_ID_LAYOUT_MANAGERS);
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            block6: {
                IConfigurationElement element = iConfigurationElementArray[n2];
                try {
                    IDiagramLayoutManager manager;
                    if (!ELEMENT_MANAGER.equals(element.getName()) || (manager = (IDiagramLayoutManager)element.createExecutableExtension(ATTRIBUTE_CLASS)) == null) break block6;
                    int priority = 0;
                    String prioEntry = element.getAttribute(ATTRIBUTE_PRIORITY);
                    if (prioEntry != null) {
                        try {
                            priority = Integer.parseInt(prioEntry);
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                    LayoutManagersService.insertSorted(manager, priority, this.managers);
                }
                catch (CoreException exception) {
                    StatusManager.getManager().handle(exception, "de.cau.cs.kieler.kiml.service");
                }
            }
            ++n2;
        }
    }

    private static <T> void insertSorted(T object, int priority, List<Pair<Integer, T>> list) {
        ListIterator<Pair<Integer, T>> iter = list.listIterator();
        while (iter.hasNext()) {
            Pair<Integer, T> next = iter.next();
            if ((Integer)next.getFirst() > priority) continue;
            iter.previous();
            break;
        }
        iter.add(new Pair((Object)priority, object));
    }
}

