/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.kiml.service;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import de.cau.cs.kieler.core.alg.IKielerProgressMonitor;
import de.cau.cs.kieler.core.kgraph.KEdge;
import de.cau.cs.kieler.core.kgraph.KGraphElement;
import de.cau.cs.kieler.core.kgraph.KLabel;
import de.cau.cs.kieler.core.kgraph.KNode;
import de.cau.cs.kieler.core.kgraph.KPort;
import de.cau.cs.kieler.core.properties.IProperty;
import de.cau.cs.kieler.kiml.LayoutConfigService;
import de.cau.cs.kieler.kiml.LayoutMetaDataService;
import de.cau.cs.kieler.kiml.LayoutOptionData;
import de.cau.cs.kieler.kiml.config.CompoundLayoutConfig;
import de.cau.cs.kieler.kiml.config.DefaultLayoutConfig;
import de.cau.cs.kieler.kiml.config.ILayoutConfig;
import de.cau.cs.kieler.kiml.config.IMutableLayoutConfig;
import de.cau.cs.kieler.kiml.config.LayoutContext;
import de.cau.cs.kieler.kiml.klayoutdata.KLayoutData;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.kiml.service.EclipseLayoutConfig;
import de.cau.cs.kieler.kiml.service.ExtensionLayoutConfigService;
import de.cau.cs.kieler.kiml.service.LayoutMapping;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ui.IWorkbenchPart;

public class LayoutOptionManager {
    private final Map<Class<?>, List<ILayoutConfig>> semanticConfigMap = Maps.newHashMap();
    private final DefaultLayoutConfig defaultLayoutConfig = new DefaultLayoutConfig();
    private LayoutOptionData resetConfigOption;

    public void configure(LayoutMapping<?> layoutMapping, IKielerProgressMonitor progressMonitor) {
        progressMonitor.begin("Layout configuration", 1.0f);
        CompoundLayoutConfig clc = new CompoundLayoutConfig();
        clc.add((ILayoutConfig)this.defaultLayoutConfig);
        clc.addAll((Collection)ExtensionLayoutConfigService.getInstance().getActiveConfigs());
        clc.addAll(layoutMapping.getLayoutConfigs());
        KNode layoutGraph = layoutMapping.getLayoutGraph();
        this.recursiveConf(layoutGraph, layoutMapping, clc);
        progressMonitor.done();
    }

    public IMutableLayoutConfig createConfig(Object domainElement, ILayoutConfig ... extraConfigs) {
        CompoundLayoutConfig clc = new CompoundLayoutConfig();
        clc.add((ILayoutConfig)this.defaultLayoutConfig);
        clc.addAll((Collection)ExtensionLayoutConfigService.getInstance().getActiveConfigs());
        clc.addAll(this.getSemanticConfigs(domainElement));
        ILayoutConfig[] iLayoutConfigArray = extraConfigs;
        int n = extraConfigs.length;
        int n2 = 0;
        while (n2 < n) {
            ILayoutConfig conf = iLayoutConfigArray[n2];
            clc.add(conf);
            ++n2;
        }
        return clc;
    }

    public <T> T getGlobalValue(IProperty<T> option, ILayoutConfig config) {
        Object value;
        LayoutOptionData optionData;
        if (config != null && (optionData = LayoutMetaDataService.getInstance().getOptionData(option.getId())) != null && (value = config.getOptionValue(optionData, LayoutContext.global())) != null) {
            return (T)value;
        }
        return (T)option.getDefault();
    }

    private void recursiveConf(KNode node, LayoutMapping<?> layoutMapping, CompoundLayoutConfig config) {
        this.configure((KGraphElement)node, layoutMapping, config);
        for (KLabel label : node.getLabels()) {
            this.configure((KGraphElement)label, layoutMapping, config);
        }
        for (KPort port : node.getPorts()) {
            this.configure((KGraphElement)port, layoutMapping, config);
            for (KLabel label : port.getLabels()) {
                this.configure((KGraphElement)label, layoutMapping, config);
            }
        }
        for (KEdge edge : node.getOutgoingEdges()) {
            this.configure((KGraphElement)edge, layoutMapping, config);
            for (KLabel label : edge.getLabels()) {
                this.configure((KGraphElement)label, layoutMapping, config);
            }
        }
        for (KNode child : node.getChildren()) {
            this.recursiveConf(child, layoutMapping, config);
        }
    }

    private void configure(KGraphElement graphElement, LayoutMapping<?> layoutMapping, CompoundLayoutConfig config) {
        LayoutContext context = new LayoutContext();
        context.setProperty(LayoutContext.GRAPH_ELEM, (Object)graphElement);
        Object diagramPart = layoutMapping.getGraphMap().get((Object)graphElement);
        context.setProperty(LayoutContext.DIAGRAM_PART, diagramPart);
        IWorkbenchPart workbenchPart = (IWorkbenchPart)Iterables.find(layoutMapping.getAllProperties().values(), (Predicate)Predicates.instanceOf(IWorkbenchPart.class), null);
        context.setProperty(EclipseLayoutConfig.WORKBENCH_PART, (Object)workbenchPart);
        Object modelElement = config.getContextValue(LayoutContext.DOMAIN_MODEL, context);
        context.setProperty(LayoutContext.DOMAIN_MODEL, modelElement);
        List<ILayoutConfig> semanticConfigs = this.getSemanticConfigs(modelElement);
        config.addAll(semanticConfigs);
        this.enrich(context, (ILayoutConfig)config, false);
        KLayoutData layoutData = (KLayoutData)graphElement.getData(KLayoutData.class);
        if (this.resetConfigOption == null) {
            this.resetConfigOption = LayoutMetaDataService.getInstance().getOptionData(LayoutOptions.RESET_CONFIG.getId());
        }
        if (this.resetConfigOption == null || ((Boolean)config.getOptionValue(this.resetConfigOption, context)).booleanValue()) {
            layoutData.getProperties().clear();
        }
        this.transferValues(layoutData, (ILayoutConfig)config, context);
        config.removeAll(semanticConfigs);
    }

    private List<ILayoutConfig> getSemanticConfigs(Object modelElement) {
        if (modelElement == null) {
            return Collections.emptyList();
        }
        Class<?> clazz = modelElement.getClass();
        List configs = this.semanticConfigMap.get(clazz);
        if (configs == null) {
            configs = modelElement instanceof EObject ? LayoutConfigService.getInstance().getSemanticConfigs(((EObject)modelElement).eClass()) : LayoutConfigService.getInstance().getSemanticConfigs(clazz);
            this.semanticConfigMap.put(clazz, configs);
        }
        return configs;
    }

    public void enrich(LayoutContext context, ILayoutConfig config, boolean makeOptionsList) {
        Object diagramPart = config.getContextValue(LayoutContext.DIAGRAM_PART, context);
        if (diagramPart != null) {
            context.setProperty(LayoutContext.DIAGRAM_PART, diagramPart);
        }
        this.enrich(LayoutContext.DOMAIN_MODEL, context, config);
        this.enrich(LayoutContext.OPT_TARGETS, context, config);
        Set targets = (Set)context.getProperty(LayoutContext.OPT_TARGETS);
        if (targets.contains(LayoutOptionData.Target.NODES)) {
            this.enrich(DefaultLayoutConfig.HAS_PORTS, context, config);
        }
        if (targets.contains(LayoutOptionData.Target.PARENTS)) {
            this.enrich(EclipseLayoutConfig.ASPECT_RATIO, context, config);
            this.enrich(DefaultLayoutConfig.CONTENT_DIAGT, context, config);
        }
        if (makeOptionsList) {
            this.enrich(LayoutContext.CONTAINER_DIAGRAM_PART, context, config);
            this.enrich(LayoutContext.CONTAINER_DOMAIN_MODEL, context, config);
            this.enrich(DefaultLayoutConfig.CONTENT_HINT, context, config);
            this.enrich(DefaultLayoutConfig.CONTAINER_HINT, context, config);
            this.enrich(DefaultLayoutConfig.CONTAINER_DIAGT, context, config);
            this.enrich(EclipseLayoutConfig.EDITING_DOMAIN, context, config);
            this.enrich(DefaultLayoutConfig.CONTENT_ALGO, context, (ILayoutConfig)this.defaultLayoutConfig);
            this.enrich(DefaultLayoutConfig.CONTAINER_ALGO, context, (ILayoutConfig)this.defaultLayoutConfig);
            this.enrich(DefaultLayoutConfig.OPTIONS, context, (ILayoutConfig)this.defaultLayoutConfig);
        }
    }

    private <T> void enrich(IProperty<T> property, LayoutContext context, ILayoutConfig config) {
        if (context.getProperty(property) == null) {
            context.setProperty(property, config.getContextValue(property, context));
        }
    }

    public void transferValues(KLayoutData layoutData, ILayoutConfig config, LayoutContext context) {
        LayoutMetaDataService dataService = LayoutMetaDataService.getInstance();
        Collection options = config.getAffectedOptions(context);
        for (IProperty option : options) {
            Object value = null;
            if (option instanceof LayoutOptionData) {
                value = config.getOptionValue((LayoutOptionData)option, context);
            } else {
                LayoutOptionData optionData = dataService.getOptionData(option.getId());
                if (optionData != null) {
                    value = config.getOptionValue(optionData, context);
                }
            }
            if (value == null) continue;
            layoutData.setProperty(option, value);
        }
    }
}

