/*
 * Decompiled with CFR 0.152.
 */
package com.equo.chromium.internal;

import com.equo.chromium.ChromiumBrowser;
import com.equo.chromium.CompatibleWithHost;
import com.equo.chromium.internal.Engine;
import com.equo.chromium.internal.ResourceExpander;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.security.CodeSource;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.cef.OS;

public class CompatibleWithHostImpl
implements CompatibleWithHost {
    private File logFile = new File(Paths.get(System.getProperty("user.home"), ".equo", "compatibility_" + LocalDateTime.now().format(DateTimeFormatter.ofPattern("uuuu-MM-dd_HH-mm-ss-SSS")) + ".log").toString());
    private String toolkitClass = "com.equo.chromium.internal.WindowlessCompatibility";

    @Override
    public CompatibleWithHost windowless() {
        return this;
    }

    private static String getJavaExecutablePath() {
        try {
            Optional optional;
            Class<?> processHandleClass = Class.forName("java.lang.ProcessHandle");
            Method currentMethod = processHandleClass.getMethod("current", new Class[0]);
            Object currentProcessHandle = currentMethod.invoke(null, new Object[0]);
            Method infoMethod = currentProcessHandle.getClass().getMethod("info", new Class[0]);
            infoMethod.setAccessible(true);
            Object processHandleInfo = infoMethod.invoke(currentProcessHandle, new Object[0]);
            Class<?> processHandleInfoClass = Class.forName("java.lang.ProcessHandle$Info");
            Method commandMethod = processHandleInfoClass.getMethod("command", new Class[0]);
            Object optionalCommand = commandMethod.invoke(processHandleInfo, new Object[0]);
            if (optionalCommand instanceof Optional && (optional = (Optional)optionalCommand).isPresent()) {
                String command = (String)optional.get();
                return command;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return CompatibleWithHostImpl.getJavaExecutableFromJavaHome();
    }

    private static String getJavaExecutableFromJavaHome() {
        String javaHome = System.getProperty("java.home");
        String javaExec = String.valueOf(javaHome) + File.separator + "bin" + File.separator + "java";
        if (OS.isWindows()) {
            javaExec = String.valueOf(javaExec) + ".exe";
        }
        return javaExec;
    }

    private String getCp() {
        CodeSource codeSource = ChromiumBrowser.class.getProtectionDomain().getCodeSource();
        if (codeSource != null) {
            URL jarLocation = codeSource.getLocation();
            String locationPath = jarLocation.getPath().replaceAll("/$", "");
            return locationPath.endsWith("/bin") || locationPath.endsWith(".jar") ? jarLocation.getPath() : String.valueOf(jarLocation.getPath()) + "bin";
        }
        CompatibleWithHostImpl.addToFile(this.logFile, "- The chromium jar location could not be determined. Error.", true);
        return null;
    }

    private boolean checkExecutionPermissions(Path path) {
        final AtomicBoolean result = new AtomicBoolean(true);
        try {
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (!CompatibleWithHostImpl.canExecute(CompatibleWithHostImpl.this.logFile, file.toFile())) {
                        result.set(false);
                    }
                    return super.visitFile(file, attrs);
                }
            });
        }
        catch (IOException e) {
            CompatibleWithHostImpl.addToFile(this.logFile, "- Permission check failed with error: " + e.getMessage(), true);
            return false;
        }
        return result.get();
    }

    private static boolean canExecute(File logFile, File newFile) {
        String[] executables = new String[]{"", "exe"};
        if (Arrays.asList(executables).contains(ResourceExpander.getExtension(newFile.getName()))) {
            if (!newFile.canExecute()) {
                CompatibleWithHostImpl.addToFile(logFile, "- The file '" + newFile.getName() + "' does not have execution permissions.", true);
                return false;
            }
            CompatibleWithHostImpl.addToFile(logFile, "- The file '" + newFile.getName() + "' has execution permissions.", true);
        }
        return true;
    }

    private static CompletableFuture<String> completeWithTimeout(long timeout, TimeUnit unit) {
        CompletableFuture<String> future = new CompletableFuture<String>();
        ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
        scheduler.schedule(() -> {
            if (!future.isDone()) {
                future.completeExceptionally(new Throwable("The check is terminated by timeout."));
            }
        }, timeout, unit);
        return future;
    }

    @Override
    public CompletableFuture<String> check() {
        CompletableFuture<String> result = CompatibleWithHostImpl.completeWithTimeout(10L, TimeUnit.SECONDS);
        File parentDirectory = this.logFile.getParentFile();
        if (!parentDirectory.exists()) {
            if (parentDirectory.mkdirs()) {
                CompatibleWithHostImpl.addToFile(this.logFile, "- Created .equo directory.", true);
            } else {
                CompatibleWithHostImpl.addToFile(this.logFile, "- Failed to create .equo directory.", true);
            }
        }
        Path libsPath = this.verifyRequiredLibraries(result);
        if (result.isDone()) {
            return result;
        }
        CompatibleWithHostImpl.addToFile(this.logFile, System.lineSeparator(), true);
        CompatibleWithHostImpl.addToFile(this.logFile, "--------- Check execution permissions ---------", true);
        this.checkExecutionPermissions(Paths.get(libsPath.toString(), "chromium-5845"));
        CompatibleWithHostImpl.addToFile(this.logFile, "--------- Check execution permissions ---------" + System.lineSeparator(), true);
        List<String> commandLine = this.generateCommandLine(libsPath);
        CompatibleWithHostImpl.addToFile(this.logFile, "- CommandLine to execute: " + commandLine + System.lineSeparator(), true);
        ProcessBuilder processBuilder = new ProcessBuilder(commandLine);
        try {
            processBuilder.redirectOutput(ProcessBuilder.Redirect.appendTo(this.logFile));
            processBuilder.redirectError(ProcessBuilder.Redirect.appendTo(this.logFile));
            Process process = processBuilder.start();
            new Thread(() -> {
                try {
                    int exitCode = process.waitFor();
                    CompatibleWithHostImpl.addToFile(this.logFile, "- Process exit with code: " + exitCode, true);
                    result.complete("");
                }
                catch (InterruptedException e) {
                    CompatibleWithHostImpl.addToFile(this.logFile, "- Failure during the process. " + e.getMessage(), true);
                    result.completeExceptionally(e);
                }
            }).start();
        }
        catch (IOException e) {
            CompatibleWithHostImpl.addToFile(this.logFile, "- Failure to execute the process with error: " + e.getMessage(), true);
            result.completeExceptionally(e);
        }
        return result;
    }

    private Path verifyRequiredLibraries(CompletableFuture<String> result) {
        Path libsPath = null;
        try {
            CompatibleWithHostImpl.addToFile(this.logFile, "--------- Verify required libraries  ---------", true);
            libsPath = Engine.findLibsPath();
            CompatibleWithHostImpl.addToFile(this.logFile, "--------- End verify required libraries ---------", true);
        }
        catch (UnsatisfiedLinkError e) {
            CompatibleWithHostImpl.addToFile(this.logFile, "- Error when verify required libraries : " + e.getMessage(), true);
            result.completeExceptionally(e);
        }
        return libsPath;
    }

    private List<String> generateCommandLine(Path libsPath) {
        String classpath = this.getCp();
        CompatibleWithHostImpl.addToFile(this.logFile, "- Classpath: " + classpath, true);
        String javaBin = CompatibleWithHostImpl.getJavaExecutablePath();
        ArrayList<String> jvmArgs = new ArrayList<String>();
        jvmArgs.add("-Dchromium.debug=true");
        jvmArgs.add("-Dchromium.path=" + libsPath);
        if (OS.isMacintosh()) {
            jvmArgs.add("-XstartOnFirstThread");
        }
        String[] stringArray = Engine.getPropertyNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String propName = stringArray[n2];
            String propValue = System.getProperty(propName, "");
            if (!(propValue.isEmpty() || propName.startsWith("chromium.path") || propName.startsWith("chromium.debug") || propName.startsWith("chromium.force_windowless_swt"))) {
                jvmArgs.add("-D" + propName + "=" + propValue);
            }
            ++n2;
        }
        jvmArgs.add("-Dchromium.cef version=" + Engine.getPropertiesFromResource("chromium-5845/chromium.properties").get("version"));
        ArrayList<String> command = new ArrayList<String>();
        command.add(javaBin);
        command.addAll(jvmArgs);
        command.add("-cp");
        command.add(classpath);
        command.add(this.toolkitClass);
        return command;
    }

    private static void addToFile(File logFile, String message, boolean apend) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (FileWriter fw = new FileWriter(logFile.getAbsolutePath(), apend);){
                fw.write(String.valueOf(message) + System.lineSeparator());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            System.out.println("An error occurred while saving the content in the " + logFile.getAbsolutePath() + " file: " + e.getMessage());
        }
    }
}

