/*
 * Decompiled with CFR 0.152.
 */
package com.equo.chromium.internal;

import com.equo.chromium.internal.Engine;
import com.equo.chromium.internal.IndependentBrowser;
import com.equo.chromium.swt.internal.MimeTypeLinux;
import com.equo.chromium.utils.EventType;
import java.awt.Component;
import java.awt.Container;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.HashMap;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.cef.OS;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefFrame;
import org.cef.browser.CefMessageRouter;
import org.cef.callback.CefBeforeDownloadCallback;
import org.cef.callback.CefDownloadItem;
import org.cef.callback.CefFileDialogCallback;
import org.cef.callback.CefJSDialogCallback;
import org.cef.callback.CefQueryCallback;
import org.cef.handler.CefDialogHandler;
import org.cef.handler.CefDownloadHandlerAdapter;
import org.cef.handler.CefFocusHandler;
import org.cef.handler.CefFocusHandlerAdapter;
import org.cef.handler.CefJSDialogHandler;
import org.cef.handler.CefJSDialogHandlerAdapter;
import org.cef.handler.CefMessageRouterHandlerAdapter;
import org.cef.misc.BoolRef;

public class SwingBrowser
extends IndependentBrowser {
    private boolean ignoreFirstFocus = true;

    private void init(String url) {
        Engine.initCEF(Engine.BrowserType.SWING);
        this.createClient();
        this.getClientHandler().addFocusHandler(new CefFocusHandlerAdapter(){

            @Override
            public boolean onSetFocus(CefBrowser browser, CefFocusHandler.FocusSource source) {
                if (SwingBrowser.this.ignoreFirstFocus && source == CefFocusHandler.FocusSource.FOCUS_SOURCE_NAVIGATION) {
                    SwingBrowser.this.ignoreFirstFocus = false;
                    return true;
                }
                return false;
            }

            @Override
            public void onGotFocus(CefBrowser browser) {
                if (OS.isWindows()) {
                    KeyboardFocusManager.getCurrentKeyboardFocusManager().clearGlobalFocusOwner();
                    browser.setFocus(true);
                }
            }
        });
        this.getClientHandler().addDialogHandler(new CefDialogHandler(){

            @Override
            public boolean onFileDialog(CefBrowser browser, CefDialogHandler.FileDialogMode mode, String title, String defaultFilePath, Vector<String> acceptFilters, CefFileDialogCallback callback) {
                return SwingBrowser.onFileDialog(browser, mode, title, defaultFilePath, acceptFilters, 0, callback);
            }
        });
        this.getClientHandler().addDownloadHandler(new CefDownloadHandlerAdapter(){

            @Override
            public void onBeforeDownload(CefBrowser browser, CefDownloadItem downloadItem, String suggestedName, CefBeforeDownloadCallback callback) {
                ((SwingBrowser)SwingBrowser.this.getBrowser().getReference()).onBeforeDownload(browser, downloadItem, suggestedName, callback);
            }
        });
        this.getClientHandler().addJSDialogHandler(new CefJSDialogHandlerAdapter(){

            @Override
            public boolean onJSDialog(CefBrowser browser, String origin_url, CefJSDialogHandler.JSDialogType dialog_type, String message_text, String default_prompt_text, CefJSDialogCallback callback, BoolRef suppress_message) {
                return SwingBrowser.openJsDialog(dialog_type, origin_url, message_text, default_prompt_text, default_prompt_text, callback);
            }
        });
        this.setBrowser(this.getClientHandler().createBrowser(url, false, false));
        this.getBrowser().setReference(this);
        this.createClipboardRouters();
    }

    @Override
    public boolean setUrl(String url) {
        this.ignoreFirstFocus = true;
        return super.setUrl(url);
    }

    public SwingBrowser(Object parent, String layout, String url) {
        this.init(url);
        Container parentContainer = (Container)parent;
        parentContainer.add((Component)((JPanel)this.getBrowser().getUIComponent()), layout);
        final Window parentWindow = SwingUtilities.windowForComponent(parentContainer);
        if (parentWindow != null) {
            parentWindow.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent windowEvent) {
                    SwingBrowser.this.close();
                    parentWindow.removeWindowListener(this);
                }
            });
        }
    }

    public SwingBrowser(String url) {
        this.init(url);
        this.getBrowser().createImmediately();
    }

    @Override
    public Object getUIComponent() {
        return this.getBrowser().getUIComponent();
    }

    private void createClipboardRouters() {
        CefMessageRouter writeText = CefMessageRouter.create(new CefMessageRouter.CefMessageRouterConfig("__writeText", "__writeTextCancel"));
        CefMessageRouter readText = CefMessageRouter.create(new CefMessageRouter.CefMessageRouterConfig("__readText", "__readTextCancel"));
        CefMessageRouterHandlerAdapter writeTextHandler = new CefMessageRouterHandlerAdapter(){

            @Override
            public boolean onQuery(CefBrowser browser, CefFrame frame, long queryId, String request, boolean persistent, CefQueryCallback callback) {
                SwingUtilities.invokeLater(() -> {
                    Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
                    try {
                        if (request == null || request.isEmpty()) {
                            cb.setContents(new StringSelection(""), null);
                        } else {
                            StringSelection transfer = new StringSelection(request);
                            cb.setContents(transfer, null);
                        }
                        HashMap<String, Object> mapData = new HashMap<String, Object>();
                        mapData.put("text", request);
                        SwingBrowser.this.getSubscriber().notifySubscribers(EventType.onClipboardWriteText, mapData);
                        callback.success(request);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        callback.failure(0, e.getMessage());
                    }
                });
                return true;
            }
        };
        CefMessageRouterHandlerAdapter readTextHandler = new CefMessageRouterHandlerAdapter(){

            @Override
            public boolean onQuery(CefBrowser browser, CefFrame frame, long queryId, String request, boolean persistent, CefQueryCallback callback) {
                SwingUtilities.invokeLater(() -> {
                    Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
                    try {
                        Transferable transferable = cb.getContents(null);
                        String text = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                        HashMap<String, Object> mapData = new HashMap<String, Object>();
                        mapData.put("text", text);
                        SwingBrowser.this.getSubscriber().notifySubscribers(EventType.onClipboardReadText, mapData);
                        callback.success(text);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        callback.failure(0, e.getMessage());
                    }
                });
                return true;
            }
        };
        writeText.addHandler(writeTextHandler, true);
        readText.addHandler(readTextHandler, true);
        this.getBrowser().getClient().addMessageRouter(writeText);
        this.getBrowser().getClient().addMessageRouter(readText);
    }

    private static File[] openDialog(CefDialogHandler.FileDialogMode mode, String title, String defaultFilePath, String[] acceptFilters, AtomicInteger selectedAcceptFilter) {
        int returnVal;
        String defaultDlgTitle;
        int swingMode;
        switch (mode) {
            case FILE_DIALOG_OPEN_MULTIPLE: {
                swingMode = 2;
                defaultDlgTitle = "Open Files";
                break;
            }
            case FILE_DIALOG_SAVE: {
                swingMode = 1;
                defaultDlgTitle = "Save File";
                break;
            }
            default: {
                swingMode = 0;
                defaultDlgTitle = "Open File";
            }
        }
        String dlgTitle = title == null || title.isEmpty() ? defaultDlgTitle : title;
        JFileChooser fc = new JFileChooser();
        fc.setDialogTitle(dlgTitle);
        fc.setDialogType(swingMode);
        HashMap<String, Integer> indexFilters = new HashMap<String, Integer>();
        int index = 1;
        if (acceptFilters != null && acceptFilters.length > 0) {
            String[] stringArray = acceptFilters;
            int n = acceptFilters.length;
            int n2 = 0;
            while (n2 < n) {
                final String acceptFilter = stringArray[n2];
                indexFilters.put(acceptFilter, index++);
                fc.addChoosableFileFilter(new FileFilter(){

                    @Override
                    public String getDescription() {
                        return acceptFilter;
                    }

                    @Override
                    public boolean accept(File f) {
                        if (f.isDirectory()) {
                            return true;
                        }
                        return f.getName().toLowerCase().endsWith(acceptFilter.replace("*", ""));
                    }
                });
                ++n2;
            }
        }
        if ((returnVal = fc.showDialog(null, null)) == 0) {
            File[] files = fc.getSelectedFiles();
            File[] allFiles = new File[files.length + 1];
            int i = 0;
            while (i < files.length) {
                allFiles[i] = files[i];
                ++i;
            }
            allFiles[files.length] = fc.getSelectedFile();
            Object selectedFilter = indexFilters.get(fc.getFileFilter().getDescription());
            if (selectedFilter != null) {
                selectedAcceptFilter.set((Integer)selectedFilter);
            }
            return allFiles;
        }
        return null;
    }

    private static boolean onFileDialog(CefBrowser browser, CefDialogHandler.FileDialogMode mode, String title, String defaultFilePath, Vector<String> acceptFilters, int selectedAcceptFilter, CefFileDialogCallback callback) {
        if (OS.isLinux()) {
            AtomicInteger filterIndex;
            String[] acceptFiltersArray = MimeTypeLinux.getExtensions(acceptFilters);
            File[] files = SwingBrowser.openDialog(mode, title, defaultFilePath, acceptFiltersArray, filterIndex = new AtomicInteger(-1));
            if (files != null) {
                Vector<String> filePaths = new Vector<String>();
                File[] fileArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    filePaths.add(file.getAbsolutePath().toString());
                    ++n2;
                }
                filterIndex.set(filterIndex.get() < 0 || filterIndex.get() >= acceptFiltersArray.length ? selectedAcceptFilter : filterIndex.get());
                ((IndependentBrowser)browser.getReference()).getSubscriber().notifySubscribers(EventType.onOpenFile);
                callback.Continue(filePaths);
            } else {
                ((IndependentBrowser)browser.getReference()).getSubscriber().notifySubscribers(EventType.onCancelOpenFile);
                callback.Cancel();
            }
            return true;
        }
        return false;
    }

    private static boolean openJsDialog(CefJSDialogHandler.JSDialogType dialog_type, String title, String msg, String prompt, String default_prompt_text, CefJSDialogCallback callback) {
        if (OS.isLinux()) {
            int selected = 0;
            String userInput = default_prompt_text;
            switch (dialog_type) {
                case JSDIALOGTYPE_ALERT: {
                    selected = JOptionPane.showConfirmDialog(null, prompt != null ? String.valueOf(msg) + "\n\n" + prompt : msg, title, -1, 1);
                    break;
                }
                case JSDIALOGTYPE_CONFIRM: {
                    selected = JOptionPane.showConfirmDialog(null, prompt != null ? String.valueOf(msg) + "\n\n" + prompt : msg, title, 2, 2);
                    break;
                }
                case JSDIALOGTYPE_PROMPT: {
                    userInput = JOptionPane.showInputDialog(prompt != null ? String.valueOf(msg) + "\n\n" + prompt : msg);
                }
            }
            callback.Continue(selected == 0 && userInput != null, userInput);
            return true;
        }
        return false;
    }

    private void onBeforeDownload(CefBrowser browser, CefDownloadItem download_item, String suggestedName, CefBeforeDownloadCallback callback) {
        if (OS.isLinux()) {
            File[] files = SwingBrowser.openDialog(CefDialogHandler.FileDialogMode.FILE_DIALOG_SAVE, null, null, null, null);
            if (files != null) {
                callback.Continue(files[0].getAbsolutePath(), false);
            }
        } else {
            callback.Continue("", true);
        }
    }
}

