/*
 * Decompiled with CFR 0.152.
 */
package com.equo.chromium.internal;

import com.equo.chromium.ChromiumBrowser;
import com.equo.chromium.internal.Engine;
import com.equo.chromium.internal.IndependentBrowser;
import java.lang.reflect.Method;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefBrowserWl;
import org.cef.misc.Rectangle;

public final class Windowless
extends IndependentBrowser {
    public Windowless(String url) {
        this(url, null);
    }

    public Windowless(String url, Rectangle window) {
        Engine.initCEF(Windowless.getBrowserType());
        this.createClient();
        this.setBrowser(this.getClientHandler().createBrowser(url, true, false, this.createRequestContext()));
        CefBrowser browser = this.getBrowser();
        browser.setReference(this);
        browser.createImmediately();
        if (window != null && browser instanceof CefBrowserWl) {
            ((CefBrowserWl)browser).setWindow(window);
        }
    }

    private static Engine.BrowserType getBrowserType() {
        if (Boolean.getBoolean("chromium.force_windowless_swt")) {
            return Engine.BrowserType.SWT;
        }
        if (Boolean.getBoolean("chromium.force_windowless_headless")) {
            return Engine.BrowserType.HEADLESS;
        }
        try {
            Class<?> clazz = Class.forName("org.eclipse.swt.widgets.Display", false, ChromiumBrowser.class.getClassLoader());
            if (clazz != null) {
                Method findDisplay = clazz.getDeclaredMethod("findDisplay", Thread.class);
                for (Thread thread : Thread.getAllStackTraces().keySet()) {
                    if (findDisplay.invoke(null, thread) == null) continue;
                    return Engine.BrowserType.SWT;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return Engine.BrowserType.HEADLESS;
    }
}

