/*
 * Decompiled with CFR 0.152.
 */
package com.equo.chromium.internal;

import com.equo.chromium.ChromiumBrowser;
import com.equo.chromium.internal.IndependentBrowser;
import com.equo.chromium.utils.EventAction;
import com.equo.chromium.utils.EventType;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutionException;

class WindowlessCompatibility {
    private static ChromiumBrowser browser = null;
    private static String logMessages = "";

    WindowlessCompatibility() {
    }

    public static void main(String[] args) {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> System.out.println(String.valueOf(System.lineSeparator()) + "--------- Aplication status ---------" + System.lineSeparator() + logMessages + "--------- End Aplication status ---------" + System.lineSeparator())));
        WindowlessCompatibility.printMessage(new String[]{"Init Aplication"}, "Done");
        WindowlessCompatibility.printMessage(new String[]{"Before OnAfterCreated"}, "Done");
        IndependentBrowser.subscribeOnAfterCreated(new EventAction(){

            @Override
            public void run() {
                WindowlessCompatibility.printMessage(new String[]{"OnAfterCreated"}, "Done");
                if (((IndependentBrowser)browser).subscribe(EventType.onLoadEnd, new EventAction(){

                    @Override
                    public void run() {
                        WindowlessCompatibility.printMessage(new String[]{"OnLoadEnd", "Get browser text"}, "Done");
                        try {
                            String text = browser.text().get();
                            WindowlessCompatibility.printMessage(new String[]{"Browser text is not empty"}, text.contains("User Agent") ? "Done" : "Error");
                            WindowlessCompatibility.printMessage(new String[]{"After getting browser text"}, "Done");
                        }
                        catch (InterruptedException | ExecutionException e) {
                            WindowlessCompatibility.printMessage(new String[]{"Error getting text from browser. " + e.getMessage()}, "Error");
                            System.exit(1);
                        }
                        browser.close();
                        WindowlessCompatibility.printMessage(new String[]{"OnBeforeExit with exitProcess=100"}, "Done");
                        System.exit(100);
                    }
                }) >= 0L) {
                    WindowlessCompatibility.printMessage(new String[]{"Before OnLoadEnd"}, "Done");
                } else {
                    WindowlessCompatibility.printMessage(new String[]{"Before OnLoadEnd"}, "Error");
                }
            }
        });
        WindowlessCompatibility.printMessage(new String[]{"Start browser"}, "Done");
        browser = ChromiumBrowser.windowless("about:/version");
        new Timer().schedule(new TimerTask(){

            @Override
            public void run() {
                WindowlessCompatibility.printMessage(new String[]{"Process terminated by timeout"}, "Error");
                System.exit(1);
            }
        }, 8000L);
        ChromiumBrowser.startBrowsers();
    }

    private static void printMessage(String[] messages, String type) {
        String[] stringArray = messages;
        int n = messages.length;
        int n2 = 0;
        while (n2 < n) {
            String message = stringArray[n2];
            System.out.println("Step: " + message);
            logMessages = String.valueOf(logMessages) + "Step: " + message + ". " + type + System.lineSeparator();
            ++n2;
        }
    }
}

