/*
 * Decompiled with CFR 0.152.
 */
package com.equo.chromium.swt.internal;

import com.equo.chromium.swt.internal.Chromium;
import com.github.cliftonlabs.json_simple.JsonArray;
import com.github.cliftonlabs.json_simple.JsonObject;
import com.github.cliftonlabs.json_simple.Jsoner;
import java.util.ArrayList;
import org.cef.CefClientSwt;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefFrame;
import org.cef.browser.CefMessageRouter;
import org.cef.callback.CefQueryCallback;
import org.cef.handler.CefMessageRouterHandlerAdapter;
import org.eclipse.swt.dnd.HTMLTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;

public class Clipboard {
    public static void createClipboardRouters(CefClientSwt clientHandler) {
        CefMessageRouter writeText = CefMessageRouter.create(new CefMessageRouter.CefMessageRouterConfig("__writeText", "__writeTextCancel"));
        CefMessageRouter readText = CefMessageRouter.create(new CefMessageRouter.CefMessageRouterConfig("__readText", "__readTextCancel"));
        CefMessageRouter write = CefMessageRouter.create(new CefMessageRouter.CefMessageRouterConfig("__write", "__writeCancel"));
        CefMessageRouter read = CefMessageRouter.create(new CefMessageRouter.CefMessageRouterConfig("__read", "__readCancel"));
        CefMessageRouterHandlerAdapter writeTextHandler = new CefMessageRouterHandlerAdapter(){

            @Override
            public boolean onQuery(CefBrowser browser, CefFrame frame, long queryId, String request, boolean persistent, CefQueryCallback callback) {
                Display display = Display.getDefault();
                Chromium.asyncExec(() -> {
                    org.eclipse.swt.dnd.Clipboard cb = new org.eclipse.swt.dnd.Clipboard(display);
                    try {
                        if (request == null || request.isEmpty()) {
                            cb.clearContents();
                        } else {
                            TextTransfer transfer = TextTransfer.getInstance();
                            cb.setContents(new Object[]{request}, new Transfer[]{transfer});
                        }
                        callback.success(request);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        callback.failure(0, e.getMessage());
                    }
                    cb.dispose();
                });
                return true;
            }
        };
        CefMessageRouterHandlerAdapter readTextHandler = new CefMessageRouterHandlerAdapter(){

            @Override
            public boolean onQuery(CefBrowser browser, CefFrame frame, long queryId, String request, boolean persistent, CefQueryCallback callback) {
                Display display = Display.getDefault();
                Chromium.asyncExec(() -> {
                    Transfer[] transfers = new Transfer[]{TextTransfer.getInstance(), HTMLTransfer.getInstance()};
                    org.eclipse.swt.dnd.Clipboard cb = new org.eclipse.swt.dnd.Clipboard(display);
                    int i = 0;
                    while (i < transfers.length) {
                        try {
                            String text = (String)cb.getContents(transfers[i]);
                            if (text != null) {
                                callback.success(text);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            callback.failure(0, e.getMessage());
                        }
                        ++i;
                    }
                    cb.dispose();
                });
                return true;
            }
        };
        CefMessageRouterHandlerAdapter writeHandler = new CefMessageRouterHandlerAdapter(){

            @Override
            public boolean onQuery(CefBrowser browser, CefFrame frame, long queryId, String request, boolean persistent, CefQueryCallback callback) {
                Display display = Display.getDefault();
                Chromium.asyncExec(() -> {
                    org.eclipse.swt.dnd.Clipboard cb = new org.eclipse.swt.dnd.Clipboard(display);
                    try {
                        block15: {
                            block14: {
                                if (request != null && !request.isEmpty()) break block14;
                                cb.clearContents();
                                break block15;
                            }
                            JsonArray jsonArr = (JsonArray)Jsoner.deserialize(request);
                            ArrayList<HTMLTransfer> transferSet = new ArrayList<HTMLTransfer>();
                            ArrayList dataSet = new ArrayList();
                            for (Object blobObject : jsonArr) {
                                JsonObject jsonObj = (JsonObject)blobObject;
                                String mimeType = (String)jsonObj.keySet().iterator().next();
                                Object data = jsonObj.get(mimeType);
                                HTMLTransfer transfer = null;
                                switch (mimeType) {
                                    case "text/plain": {
                                        transfer = TextTransfer.getInstance();
                                        break;
                                    }
                                    case "text/html": {
                                        transfer = HTMLTransfer.getInstance();
                                        break;
                                    }
                                    default: {
                                        System.out.println("Copy type " + mimeType + " is not supported");
                                    }
                                }
                                if (data == null) continue;
                                dataSet.add(data);
                                transferSet.add(transfer);
                            }
                            if (!dataSet.isEmpty()) {
                                cb.setContents((Object[])dataSet.toArray(new String[dataSet.size()]), transferSet.toArray(new Transfer[transferSet.size()]));
                            }
                        }
                        callback.success(request);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        callback.failure(0, e.getMessage());
                    }
                    cb.dispose();
                });
                return true;
            }
        };
        CefMessageRouterHandlerAdapter readHandler = new CefMessageRouterHandlerAdapter(){

            @Override
            public boolean onQuery(CefBrowser browser, CefFrame frame, long queryId, String request, boolean persistent, CefQueryCallback callback) {
                Display display = Display.getDefault();
                Chromium.asyncExec(() -> {
                    org.eclipse.swt.dnd.Clipboard cb = new org.eclipse.swt.dnd.Clipboard(display);
                    Transfer[] transfers = new Transfer[]{TextTransfer.getInstance(), HTMLTransfer.getInstance()};
                    JsonArray jsonArray = new JsonArray();
                    int i = 0;
                    while (i < transfers.length) {
                        try {
                            Object data = cb.getContents(transfers[i]);
                            if (data != null) {
                                String type = "";
                                if (transfers[i] instanceof TextTransfer) {
                                    type = "text/plain";
                                } else if (transfers[i] instanceof HTMLTransfer) {
                                    type = "text/html";
                                }
                                JsonObject jsonObject = new JsonObject();
                                jsonObject.put("type", type);
                                jsonObject.put("data", data);
                                jsonArray.add(jsonObject);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            callback.failure(0, e.getMessage());
                        }
                        ++i;
                    }
                    callback.success(Jsoner.serialize(jsonArray));
                    cb.dispose();
                });
                return true;
            }
        };
        writeText.addHandler(writeTextHandler, true);
        readText.addHandler(readTextHandler, true);
        write.addHandler(writeHandler, true);
        read.addHandler(readHandler, true);
        clientHandler.addMessageRouter(writeText);
        clientHandler.addMessageRouter(readText);
        clientHandler.addMessageRouter(write);
        clientHandler.addMessageRouter(read);
    }
}

