/*
 * Decompiled with CFR 0.152.
 */
package com.equo.chromium.swt.internal;

import java.io.ByteArrayInputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.util.Base64;
import java.util.Map;

public class SetTextResourceHandler {
    private Object middlewareService;
    private static SetTextResourceHandler textResourceHandler = null;

    public static void configureScheme(String textUrl) {
        if (textResourceHandler != null) {
            textResourceHandler.configureSchemes(true, textUrl);
        }
    }

    public static void unregisterScheme(String textUrl) {
        if (textResourceHandler != null) {
            textResourceHandler.configureSchemes(false, textUrl);
        }
    }

    public void configureSchemes(boolean addResourceHandler, String textUrl) {
        try {
            URI uri = URI.create(textUrl);
            Class<?> iResponseHandlerClass = Class.forName("com.equo.middleware.api.handler.IResponseHandler");
            if (addResourceHandler) {
                Method addResourceHandlerMethod = Class.forName("com.equo.middleware.api.IMiddlewareService").getDeclaredMethod("addResourceHandler", String.class, String.class, iResponseHandlerClass);
                addResourceHandlerMethod.invoke(this.middlewareService, uri.getScheme(), uri.getAuthority(), SetTextResourceHandler.createResponseHandler(iResponseHandlerClass));
            } else {
                Method removeResourceHandlerMethod = Class.forName("com.equo.middleware.api.IMiddlewareService").getDeclaredMethod("removeResourceHandler", String.class, String.class);
                removeResourceHandlerMethod.invoke(this.middlewareService, uri.getScheme(), uri.getAuthority());
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            // empty catch block
        }
    }

    private static Object createResponseHandler(Class<?> iResponseHandlerClass) {
        InvocationHandler inv = new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if ("shouldProcessRequest".equals(method.getName())) {
                    return true;
                }
                if ("getResponseData".equals(method.getName())) {
                    Map requestHeaders = (Map)Class.forName("com.equo.middleware.api.resource.Request").getDeclaredMethod("getHeaderMap", new Class[0]).invoke(args[0], new Object[0]);
                    Map responseHeaders = (Map)args[1];
                    responseHeaders.put("Content-Type", "text/html");
                    byte[] dataText = Base64.getDecoder().decode(requestHeaders.getOrDefault("dataText", ""));
                    return new ByteArrayInputStream(dataText);
                }
                return null;
            }
        };
        return Proxy.newProxyInstance(iResponseHandlerClass.getClassLoader(), new Class[]{iResponseHandlerClass}, inv);
    }

    public void setMiddlewareService(Object middlewareService) {
        this.middlewareService = middlewareService;
        textResourceHandler = this;
    }

    public void unsetMiddlewareService(Object middlewareService) {
        this.middlewareService = null;
    }
}

