/*
 * Decompiled with CFR 0.152.
 */
package org.cef;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import org.cef.CefApp;
import org.cef.CefSettings;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefFrame;
import org.cef.browser.CefMessageRouter;
import org.cef.browser.CefRequestContext;
import org.cef.callback.CefAuthCallback;
import org.cef.callback.CefBeforeDownloadCallback;
import org.cef.callback.CefCallback;
import org.cef.callback.CefContextMenuParams;
import org.cef.callback.CefDownloadItem;
import org.cef.callback.CefDownloadItemCallback;
import org.cef.callback.CefDragData;
import org.cef.callback.CefFileDialogCallback;
import org.cef.callback.CefJSDialogCallback;
import org.cef.callback.CefMenuModel;
import org.cef.callback.CefPrintDialogCallback;
import org.cef.callback.CefPrintJobCallback;
import org.cef.handler.CefClientHandler;
import org.cef.handler.CefContextMenuHandler;
import org.cef.handler.CefDialogHandler;
import org.cef.handler.CefDisplayHandler;
import org.cef.handler.CefDownloadHandler;
import org.cef.handler.CefDragHandler;
import org.cef.handler.CefFindHandler;
import org.cef.handler.CefFocusHandler;
import org.cef.handler.CefJSDialogHandler;
import org.cef.handler.CefKeyboardHandler;
import org.cef.handler.CefLifeSpanHandler;
import org.cef.handler.CefLoadHandler;
import org.cef.handler.CefPrintHandler;
import org.cef.handler.CefRenderHandler;
import org.cef.handler.CefRequestHandler;
import org.cef.handler.CefResourceRequestHandler;
import org.cef.handler.CefScreenInfo;
import org.cef.handler.CefWindowHandler;
import org.cef.misc.BoolRef;
import org.cef.misc.CefPrintSettings;
import org.cef.misc.Dimension;
import org.cef.misc.Point;
import org.cef.misc.Rectangle;
import org.cef.network.CefRequest;

public abstract class CefClient
extends CefClientHandler
implements CefContextMenuHandler,
CefDialogHandler,
CefDisplayHandler,
CefDownloadHandler,
CefDragHandler,
CefFindHandler,
CefFocusHandler,
CefJSDialogHandler,
CefKeyboardHandler,
CefLifeSpanHandler,
CefLoadHandler,
CefPrintHandler,
CefRenderHandler,
CefRequestHandler,
CefWindowHandler {
    private HashMap<Integer, CefBrowser> browser_ = new HashMap();
    private CefContextMenuHandler contextMenuHandler_ = null;
    private CefDialogHandler dialogHandler_ = null;
    private CefDisplayHandler displayHandler_ = null;
    private CefDownloadHandler downloadHandler_ = null;
    private CefDragHandler dragHandler_ = null;
    private CefFindHandler findHandler_ = null;
    private CefFocusHandler focusHandler_ = null;
    private CefJSDialogHandler jsDialogHandler_ = null;
    private CefKeyboardHandler keyboardHandler_ = null;
    private CefLifeSpanHandler lifeSpanHandler_ = null;
    private CefLoadHandler loadHandler_ = null;
    private CefPrintHandler printHandler_ = null;
    private CefRequestHandler requestHandler_ = null;
    protected boolean isDisposed_ = false;

    CefClient() throws UnsatisfiedLinkError {
    }

    @Override
    public void dispose() {
        if (!this.isDisposed_) {
            this.isDisposed_ = true;
            this.cleanupBrowser(-1);
        }
    }

    public CefBrowser createBrowser(String url, boolean isOffscreenRendered, boolean isTransparent) {
        return this.createBrowser(url, isOffscreenRendered, isTransparent, null);
    }

    public abstract CefBrowser createBrowser(String var1, boolean var2, boolean var3, CefRequestContext var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected CefBrowser getBrowser(int identifier) {
        HashMap<Integer, CefBrowser> hashMap = this.browser_;
        synchronized (hashMap) {
            return this.browser_.get(new Integer(identifier));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] getAllBrowser() {
        HashMap<Integer, CefBrowser> hashMap = this.browser_;
        synchronized (hashMap) {
            return this.browser_.values().toArray();
        }
    }

    @Override
    protected CefContextMenuHandler getContextMenuHandler() {
        return this;
    }

    @Override
    protected CefDialogHandler getDialogHandler() {
        return this;
    }

    @Override
    protected CefDisplayHandler getDisplayHandler() {
        return this;
    }

    @Override
    protected CefDownloadHandler getDownloadHandler() {
        return this;
    }

    @Override
    protected CefDragHandler getDragHandler() {
        return this;
    }

    @Override
    protected CefFindHandler getFindHandler() {
        return this;
    }

    @Override
    protected CefFocusHandler getFocusHandler() {
        return this;
    }

    @Override
    protected CefJSDialogHandler getJSDialogHandler() {
        return this;
    }

    @Override
    protected CefKeyboardHandler getKeyboardHandler() {
        return this;
    }

    @Override
    protected CefLifeSpanHandler getLifeSpanHandler() {
        return this;
    }

    @Override
    protected CefLoadHandler getLoadHandler() {
        return this;
    }

    @Override
    protected CefPrintHandler getPrintHandler() {
        return this;
    }

    @Override
    protected CefRenderHandler getRenderHandler() {
        return this;
    }

    @Override
    protected CefRequestHandler getRequestHandler() {
        return this;
    }

    @Override
    protected CefWindowHandler getWindowHandler() {
        return this;
    }

    public CefClient addContextMenuHandler(CefContextMenuHandler handler) {
        if (this.contextMenuHandler_ == null) {
            this.contextMenuHandler_ = handler;
        }
        return this;
    }

    public void removeContextMenuHandler() {
        this.contextMenuHandler_ = null;
    }

    @Override
    public void onBeforeContextMenu(CefBrowser browser, CefFrame frame, CefContextMenuParams params, CefMenuModel model) {
        if (this.contextMenuHandler_ != null && browser != null) {
            this.contextMenuHandler_.onBeforeContextMenu(browser, frame, params, model);
        }
    }

    @Override
    public boolean onContextMenuCommand(CefBrowser browser, CefFrame frame, CefContextMenuParams params, int commandId, int eventFlags) {
        if (this.contextMenuHandler_ != null && browser != null) {
            return this.contextMenuHandler_.onContextMenuCommand(browser, frame, params, commandId, eventFlags);
        }
        return false;
    }

    @Override
    public void onContextMenuDismissed(CefBrowser browser, CefFrame frame) {
        if (this.contextMenuHandler_ != null && browser != null) {
            this.contextMenuHandler_.onContextMenuDismissed(browser, frame);
        }
    }

    public CefClient addDialogHandler(CefDialogHandler handler) {
        if (this.dialogHandler_ == null) {
            this.dialogHandler_ = handler;
        }
        return this;
    }

    public void removeDialogHandler() {
        this.dialogHandler_ = null;
    }

    @Override
    public boolean onFileDialog(CefBrowser browser, CefDialogHandler.FileDialogMode mode, String title, String defaultFilePath, Vector<String> acceptFilters, CefFileDialogCallback callback) {
        if (this.dialogHandler_ != null && browser != null) {
            return this.dialogHandler_.onFileDialog(browser, mode, title, defaultFilePath, acceptFilters, callback);
        }
        return false;
    }

    public CefClient addDisplayHandler(CefDisplayHandler handler) {
        if (this.displayHandler_ == null) {
            this.displayHandler_ = handler;
        }
        return this;
    }

    public void removeDisplayHandler() {
        this.displayHandler_ = null;
    }

    @Override
    public void onAddressChange(CefBrowser browser, CefFrame frame, String url) {
        if (this.displayHandler_ != null && browser != null) {
            this.displayHandler_.onAddressChange(browser, frame, url);
        }
    }

    @Override
    public void onTitleChange(CefBrowser browser, String title) {
        if (this.displayHandler_ != null && browser != null) {
            this.displayHandler_.onTitleChange(browser, title);
        }
    }

    @Override
    public boolean onTooltip(CefBrowser browser, String text) {
        if (this.displayHandler_ != null && browser != null) {
            return this.displayHandler_.onTooltip(browser, text);
        }
        return false;
    }

    @Override
    public void onStatusMessage(CefBrowser browser, String value) {
        if (this.displayHandler_ != null && browser != null) {
            this.displayHandler_.onStatusMessage(browser, value);
        }
    }

    @Override
    public boolean onConsoleMessage(CefBrowser browser, CefSettings.LogSeverity level, String message, String source, int line) {
        if (this.displayHandler_ != null && browser != null) {
            return this.displayHandler_.onConsoleMessage(browser, level, message, source, line);
        }
        return false;
    }

    @Override
    public boolean onCursorChange(CefBrowser browser, int cursorType) {
        if (browser == null) {
            return false;
        }
        if (this.displayHandler_ != null && this.displayHandler_.onCursorChange(browser, cursorType)) {
            return true;
        }
        CefRenderHandler realHandler = browser.getRenderHandler();
        if (realHandler != null) {
            return realHandler.onCursorChange(browser, cursorType);
        }
        return false;
    }

    @Override
    public void onLoadingProgressChange(CefBrowser browser, double progress) {
        if (this.displayHandler_ != null && browser != null) {
            this.displayHandler_.onLoadingProgressChange(browser, progress);
        }
    }

    @Override
    public void onFullscreenModeChange(CefBrowser browser, boolean fullscreen) {
        if (this.displayHandler_ != null && browser != null) {
            this.displayHandler_.onFullscreenModeChange(browser, fullscreen);
        }
    }

    public CefClient addDownloadHandler(CefDownloadHandler handler) {
        if (this.downloadHandler_ == null) {
            this.downloadHandler_ = handler;
        }
        return this;
    }

    public void removeDownloadHandler() {
        this.downloadHandler_ = null;
    }

    @Override
    public void onBeforeDownload(CefBrowser browser, CefDownloadItem downloadItem, String suggestedName, CefBeforeDownloadCallback callback) {
        if (this.downloadHandler_ != null && browser != null) {
            this.downloadHandler_.onBeforeDownload(browser, downloadItem, suggestedName, callback);
        }
    }

    @Override
    public void onDownloadUpdated(CefBrowser browser, CefDownloadItem downloadItem, CefDownloadItemCallback callback) {
        if (this.downloadHandler_ != null && browser != null) {
            this.downloadHandler_.onDownloadUpdated(browser, downloadItem, callback);
        }
    }

    public CefClient addDragHandler(CefDragHandler handler) {
        if (this.dragHandler_ == null) {
            this.dragHandler_ = handler;
        }
        return this;
    }

    public void removeDragHandler() {
        this.dragHandler_ = null;
    }

    @Override
    public boolean onDragEnter(CefBrowser browser, CefDragData dragData, int mask) {
        if (this.dragHandler_ != null && browser != null) {
            return this.dragHandler_.onDragEnter(browser, dragData, mask);
        }
        return false;
    }

    public CefClient addFindHandler(CefFindHandler handler) {
        if (this.findHandler_ == null) {
            this.findHandler_ = handler;
        }
        return this;
    }

    public void removeFindHandler() {
        this.findHandler_ = null;
    }

    @Override
    public void onFindResult(CefBrowser browser, int identifier, int count, Rectangle selectionRect, int activeMatchOrdinal, boolean finalUpdate) {
        if (this.findHandler_ != null) {
            this.findHandler_.onFindResult(browser, identifier, count, selectionRect, activeMatchOrdinal, finalUpdate);
        }
    }

    public CefClient addFocusHandler(CefFocusHandler handler) {
        if (this.focusHandler_ == null) {
            this.focusHandler_ = handler;
        }
        return this;
    }

    public void removeFocusHandler() {
        this.focusHandler_ = null;
    }

    @Override
    public void onTakeFocus(CefBrowser browser, boolean next) {
        if (browser == null) {
            return;
        }
        browser.setFocus(false);
        if (this.focusHandler_ != null) {
            this.focusHandler_.onTakeFocus(browser, next);
        }
    }

    @Override
    public boolean onSetFocus(CefBrowser browser, CefFocusHandler.FocusSource source) {
        if (browser == null) {
            return false;
        }
        boolean alreadyHandled = false;
        if (this.focusHandler_ != null) {
            alreadyHandled = this.focusHandler_.onSetFocus(browser, source);
        }
        return alreadyHandled;
    }

    @Override
    public void onGotFocus(CefBrowser browser) {
        if (browser == null) {
            return;
        }
        browser.setFocus(true);
        if (this.focusHandler_ != null) {
            this.focusHandler_.onGotFocus(browser);
        }
    }

    public CefClient addJSDialogHandler(CefJSDialogHandler handler) {
        if (this.jsDialogHandler_ == null) {
            this.jsDialogHandler_ = handler;
        }
        return this;
    }

    public void removeJSDialogHandler() {
        this.jsDialogHandler_ = null;
    }

    @Override
    public boolean onJSDialog(CefBrowser browser, String origin_url, CefJSDialogHandler.JSDialogType dialog_type, String message_text, String default_prompt_text, CefJSDialogCallback callback, BoolRef suppress_message) {
        if (this.jsDialogHandler_ != null && browser != null) {
            return this.jsDialogHandler_.onJSDialog(browser, origin_url, dialog_type, message_text, default_prompt_text, callback, suppress_message);
        }
        return false;
    }

    @Override
    public boolean onBeforeUnloadDialog(CefBrowser browser, String message_text, boolean is_reload, CefJSDialogCallback callback) {
        if (this.jsDialogHandler_ != null && browser != null) {
            return this.jsDialogHandler_.onBeforeUnloadDialog(browser, message_text, is_reload, callback);
        }
        return false;
    }

    @Override
    public void onResetDialogState(CefBrowser browser) {
        if (this.jsDialogHandler_ != null && browser != null) {
            this.jsDialogHandler_.onResetDialogState(browser);
        }
    }

    @Override
    public void onDialogClosed(CefBrowser browser) {
        if (this.jsDialogHandler_ != null && browser != null) {
            this.jsDialogHandler_.onDialogClosed(browser);
        }
    }

    public CefClient addKeyboardHandler(CefKeyboardHandler handler) {
        if (this.keyboardHandler_ == null) {
            this.keyboardHandler_ = handler;
        }
        return this;
    }

    public void removeKeyboardHandler() {
        this.keyboardHandler_ = null;
    }

    @Override
    public boolean onPreKeyEvent(CefBrowser browser, CefKeyboardHandler.CefKeyEvent event, BoolRef is_keyboard_shortcut) {
        if (this.keyboardHandler_ != null && browser != null) {
            return this.keyboardHandler_.onPreKeyEvent(browser, event, is_keyboard_shortcut);
        }
        return false;
    }

    @Override
    public boolean onKeyEvent(CefBrowser browser, CefKeyboardHandler.CefKeyEvent event) {
        if (this.keyboardHandler_ != null && browser != null) {
            return this.keyboardHandler_.onKeyEvent(browser, event);
        }
        return false;
    }

    public CefClient addLifeSpanHandler(CefLifeSpanHandler handler) {
        if (this.lifeSpanHandler_ == null) {
            this.lifeSpanHandler_ = handler;
        }
        return this;
    }

    public void removeLifeSpanHandler() {
        this.lifeSpanHandler_ = null;
    }

    @Override
    public boolean onBeforePopup(CefBrowser browser, CefFrame frame, String target_url, String target_frame_name) {
        if (this.isDisposed_) {
            return true;
        }
        if (this.lifeSpanHandler_ != null && browser != null) {
            return this.lifeSpanHandler_.onBeforePopup(browser, frame, target_url, target_frame_name);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onAfterCreated(CefBrowser browser) {
        if (browser == null) {
            return;
        }
        Integer identifier = browser.getIdentifier();
        HashMap<Integer, CefBrowser> hashMap = this.browser_;
        synchronized (hashMap) {
            this.browser_.put(identifier, browser);
        }
        if (this.lifeSpanHandler_ != null) {
            this.lifeSpanHandler_.onAfterCreated(browser);
        }
    }

    @Override
    public void onAfterParentChanged(CefBrowser browser) {
        if (browser == null) {
            return;
        }
        if (this.lifeSpanHandler_ != null) {
            this.lifeSpanHandler_.onAfterParentChanged(browser);
        }
    }

    @Override
    public boolean doClose(CefBrowser browser) {
        if (browser == null) {
            return false;
        }
        if (this.lifeSpanHandler_ != null) {
            return this.lifeSpanHandler_.doClose(browser);
        }
        return browser.doClose();
    }

    @Override
    public void onBeforeClose(CefBrowser browser) {
        if (browser == null) {
            return;
        }
        if (this.lifeSpanHandler_ != null) {
            this.lifeSpanHandler_.onBeforeClose(browser);
        }
        browser.onBeforeClose();
        this.cleanupBrowser(browser.getIdentifier());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupBrowser(int identifier) {
        HashMap<Integer, CefBrowser> hashMap = this.browser_;
        synchronized (hashMap) {
            if (identifier >= 0) {
                this.browser_.remove(identifier);
            } else if (!this.browser_.isEmpty()) {
                ArrayList<CefBrowser> browserList = new ArrayList<CefBrowser>(this.browser_.values());
                for (CefBrowser browser : browserList) {
                    browser.close(true);
                }
                return;
            }
            if (this.browser_.isEmpty() && this.isDisposed_) {
                this.removeContextMenuHandler(this);
                this.removeDialogHandler(this);
                this.removeDisplayHandler(this);
                this.removeDownloadHandler(this);
                this.removeDragHandler(this);
                this.removeFindHandler(this);
                this.removeFocusHandler(this);
                this.removeJSDialogHandler(this);
                this.removeKeyboardHandler(this);
                this.removeLifeSpanHandler(this);
                this.removeLoadHandler(this);
                this.removeRenderHandler(this);
                this.removeRequestHandler(this);
                this.removeWindowHandler(this);
                super.dispose();
                CefApp.getInstance().clientWasDisposed(this);
            }
        }
    }

    public CefClient addLoadHandler(CefLoadHandler handler) {
        if (this.loadHandler_ == null) {
            this.loadHandler_ = handler;
        }
        return this;
    }

    public void removeLoadHandler() {
        this.loadHandler_ = null;
    }

    @Override
    public void onLoadingStateChange(CefBrowser browser, boolean isLoading, boolean canGoBack, boolean canGoForward) {
        if (this.loadHandler_ != null && browser != null) {
            this.loadHandler_.onLoadingStateChange(browser, isLoading, canGoBack, canGoForward);
        }
    }

    @Override
    public void onLoadStart(CefBrowser browser, CefFrame frame, CefRequest.TransitionType transitionType) {
        if (this.loadHandler_ != null && browser != null) {
            this.loadHandler_.onLoadStart(browser, frame, transitionType);
        }
    }

    @Override
    public void onLoadEnd(CefBrowser browser, CefFrame frame, int httpStatusCode) {
        if (this.loadHandler_ != null && browser != null) {
            this.loadHandler_.onLoadEnd(browser, frame, httpStatusCode);
        }
    }

    @Override
    public void onLoadError(CefBrowser browser, CefFrame frame, CefLoadHandler.ErrorCode errorCode, String errorText, String failedUrl) {
        if (this.loadHandler_ != null && browser != null) {
            this.loadHandler_.onLoadError(browser, frame, errorCode, errorText, failedUrl);
        }
    }

    public CefClient addPrintHandler(CefPrintHandler handler) {
        if (this.printHandler_ == null) {
            this.printHandler_ = handler;
        }
        return this;
    }

    public void removePrintHandler() {
        this.printHandler_ = null;
    }

    @Override
    public void onPrintStart(CefBrowser browser) {
        if (this.printHandler_ != null && browser != null) {
            this.printHandler_.onPrintStart(browser);
        }
    }

    @Override
    public void onPrintSettings(CefBrowser browser, CefPrintSettings settings, boolean getDefaults) {
        if (this.printHandler_ != null && browser != null) {
            this.printHandler_.onPrintSettings(browser, settings, getDefaults);
        }
    }

    @Override
    public boolean onPrintDialog(CefBrowser browser, boolean hasSelection, CefPrintDialogCallback callback) {
        if (this.printHandler_ != null && browser != null) {
            return this.printHandler_.onPrintDialog(browser, hasSelection, callback);
        }
        return false;
    }

    @Override
    public boolean onPrintJob(CefBrowser browser, String documentName, String pdfFilePath, CefPrintJobCallback callback) {
        if (this.printHandler_ != null && browser != null) {
            return this.printHandler_.onPrintJob(browser, documentName, pdfFilePath, callback);
        }
        return false;
    }

    @Override
    public void onPrintReset(CefBrowser browser) {
        if (this.printHandler_ != null && browser != null) {
            this.printHandler_.onPrintReset(browser);
        }
    }

    @Override
    public Dimension getPdfPaperSize(CefBrowser browser, int deviceUnitsPerInch) {
        if (this.printHandler_ != null && browser != null) {
            return this.printHandler_.getPdfPaperSize(browser, deviceUnitsPerInch);
        }
        return null;
    }

    @Override
    public synchronized void addMessageRouter(CefMessageRouter messageRouter) {
        super.addMessageRouter(messageRouter);
    }

    @Override
    public synchronized void removeMessageRouter(CefMessageRouter messageRouter) {
        super.removeMessageRouter(messageRouter);
    }

    @Override
    public Rectangle getViewRect(CefBrowser browser) {
        if (browser == null) {
            return new Rectangle(0, 0, 0, 0);
        }
        CefRenderHandler realHandler = browser.getRenderHandler();
        if (realHandler != null) {
            return realHandler.getViewRect(browser);
        }
        return new Rectangle(0, 0, 0, 0);
    }

    @Override
    public Point getScreenPoint(CefBrowser browser, Point viewPoint) {
        if (browser == null) {
            return new Point(0, 0);
        }
        CefRenderHandler realHandler = browser.getRenderHandler();
        if (realHandler != null) {
            return realHandler.getScreenPoint(browser, viewPoint);
        }
        return new Point(0, 0);
    }

    @Override
    public void onPopupShow(CefBrowser browser, boolean show) {
        if (browser == null) {
            return;
        }
        CefRenderHandler realHandler = browser.getRenderHandler();
        if (realHandler != null) {
            realHandler.onPopupShow(browser, show);
        }
    }

    @Override
    public void onPopupSize(CefBrowser browser, Rectangle size) {
        if (browser == null) {
            return;
        }
        CefRenderHandler realHandler = browser.getRenderHandler();
        if (realHandler != null) {
            realHandler.onPopupSize(browser, size);
        }
    }

    @Override
    public void onPaint(CefBrowser browser, boolean popup, Rectangle[] dirtyRects, ByteBuffer buffer, int width, int height) {
        if (browser == null) {
            return;
        }
        CefRenderHandler realHandler = browser.getRenderHandler();
        if (realHandler != null) {
            realHandler.onPaint(browser, popup, dirtyRects, buffer, width, height);
        }
    }

    @Override
    public boolean startDragging(CefBrowser browser, CefDragData dragData, int mask, int x, int y) {
        if (browser == null) {
            return false;
        }
        CefRenderHandler realHandler = browser.getRenderHandler();
        if (realHandler != null) {
            return realHandler.startDragging(browser, dragData, mask, x, y);
        }
        return false;
    }

    @Override
    public void updateDragCursor(CefBrowser browser, int operation) {
        if (browser == null) {
            return;
        }
        CefRenderHandler realHandler = browser.getRenderHandler();
        if (realHandler != null) {
            realHandler.updateDragCursor(browser, operation);
        }
    }

    public CefClient addRequestHandler(CefRequestHandler handler) {
        if (this.requestHandler_ == null) {
            this.requestHandler_ = handler;
        }
        return this;
    }

    public void removeRequestHandler() {
        this.requestHandler_ = null;
    }

    @Override
    public boolean onBeforeBrowse(CefBrowser browser, CefFrame frame, CefRequest request, boolean user_gesture, boolean is_redirect) {
        if (this.requestHandler_ != null && browser != null) {
            return this.requestHandler_.onBeforeBrowse(browser, frame, request, user_gesture, is_redirect);
        }
        return false;
    }

    @Override
    public boolean onOpenURLFromTab(CefBrowser browser, CefFrame frame, String target_url, boolean user_gesture) {
        if (this.isDisposed_) {
            return true;
        }
        if (this.requestHandler_ != null && browser != null) {
            return this.requestHandler_.onOpenURLFromTab(browser, frame, target_url, user_gesture);
        }
        return false;
    }

    @Override
    public CefResourceRequestHandler getResourceRequestHandler(CefBrowser browser, CefFrame frame, CefRequest request, boolean isNavigation, boolean isDownload, String requestInitiator, BoolRef disableDefaultHandling) {
        if (this.requestHandler_ != null && browser != null) {
            return this.requestHandler_.getResourceRequestHandler(browser, frame, request, isNavigation, isDownload, requestInitiator, disableDefaultHandling);
        }
        return null;
    }

    @Override
    public boolean getAuthCredentials(CefBrowser browser, String origin_url, boolean isProxy, String host, int port, String realm, String scheme, CefAuthCallback callback) {
        if (this.requestHandler_ != null && browser != null) {
            return this.requestHandler_.getAuthCredentials(browser, origin_url, isProxy, host, port, realm, scheme, callback);
        }
        return false;
    }

    @Override
    public boolean onCertificateError(CefBrowser browser, CefLoadHandler.ErrorCode cert_error, String request_url, CefCallback callback) {
        if (this.requestHandler_ != null) {
            return this.requestHandler_.onCertificateError(browser, cert_error, request_url, callback);
        }
        return false;
    }

    @Override
    public void onRenderProcessTerminated(CefBrowser browser, CefRequestHandler.TerminationStatus status) {
        if (this.requestHandler_ != null) {
            this.requestHandler_.onRenderProcessTerminated(browser, status);
        }
    }

    @Override
    public Rectangle getRect(CefBrowser browser) {
        if (browser == null) {
            return new Rectangle(0, 0, 0, 0);
        }
        CefWindowHandler realHandler = browser.getWindowHandler();
        if (realHandler != null) {
            return realHandler.getRect(browser);
        }
        return new Rectangle(0, 0, 0, 0);
    }

    @Override
    public void onMouseEvent(CefBrowser browser, int event, int screenX, int screenY, int modifier, int button) {
        if (browser == null) {
            return;
        }
        CefWindowHandler realHandler = browser.getWindowHandler();
        if (realHandler != null) {
            realHandler.onMouseEvent(browser, event, screenX, screenY, modifier, button);
        }
    }

    @Override
    public boolean getScreenInfo(CefBrowser arg0, CefScreenInfo arg1) {
        return false;
    }
}

