/*
 * Decompiled with CFR 0.152.
 */
package org.cef.network;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.cef.network.CefPostData;
import org.cef.network.CefRequest_N;

public abstract class CefRequest {
    CefRequest() {
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    public static final CefRequest create() {
        return CefRequest_N.createNative();
    }

    public abstract void dispose();

    public abstract long getIdentifier();

    public abstract boolean isReadOnly();

    public abstract String getURL();

    public abstract void setURL(String var1);

    public abstract String getMethod();

    public abstract void setMethod(String var1);

    public abstract void setReferrer(String var1, ReferrerPolicy var2);

    public abstract String getReferrerURL();

    public abstract ReferrerPolicy getReferrerPolicy();

    public abstract CefPostData getPostData();

    public abstract void setPostData(CefPostData var1);

    public abstract String getHeaderByName(String var1);

    public abstract void setHeaderByName(String var1, String var2, boolean var3);

    public abstract void getHeaderMap(Map<String, String> var1);

    public abstract void setHeaderMap(Map<String, String> var1);

    public abstract void set(String var1, String var2, CefPostData var3, Map<String, String> var4);

    public abstract int getFlags();

    public abstract void setFlags(int var1);

    public abstract String getFirstPartyForCookies();

    public abstract void setFirstPartyForCookies(String var1);

    public abstract ResourceType getResourceType();

    public abstract TransitionType getTransitionType();

    public String toString() {
        String returnValue = "\nHTTP-Request";
        returnValue = String.valueOf(returnValue) + "\n  flags: " + this.getFlags();
        returnValue = String.valueOf(returnValue) + "\n  resourceType: " + (Object)((Object)this.getResourceType());
        returnValue = String.valueOf(returnValue) + "\n  transitionType: " + (Object)((Object)this.getTransitionType());
        returnValue = String.valueOf(returnValue) + "\n  firstPartyForCookies: " + this.getFirstPartyForCookies();
        returnValue = String.valueOf(returnValue) + "\n  referrerURL: " + this.getReferrerURL();
        returnValue = String.valueOf(returnValue) + "\n  referrerPolicy: " + (Object)((Object)this.getReferrerPolicy());
        returnValue = String.valueOf(returnValue) + "\n    " + this.getMethod() + " " + this.getURL() + " HTTP/1.1\n";
        HashMap<String, String> headerMap = new HashMap<String, String>();
        this.getHeaderMap(headerMap);
        Set entrySet = headerMap.entrySet();
        String mimeType = null;
        for (Map.Entry entry : entrySet) {
            String key = (String)entry.getKey();
            returnValue = String.valueOf(returnValue) + "    " + key + "=" + (String)entry.getValue() + "\n";
            if (!key.equals("Content-Type")) continue;
            mimeType = (String)entry.getValue();
        }
        CefPostData pd = this.getPostData();
        if (pd != null) {
            returnValue = String.valueOf(returnValue) + pd.toString(mimeType);
        }
        return returnValue;
    }

    public static final class CefUrlRequestFlags {
        public static final int UR_FLAG_NONE = 0;
        public static final int UR_FLAG_SKIP_CACHE = 1;
        public static final int UR_FLAG_ALLOW_CACHED_CREDENTIALS = 2;
        public static final int UR_FLAG_REPORT_UPLOAD_PROGRESS = 8;
        public static final int UR_FLAG_REPORT_RAW_HEADERS = 32;
        public static final int UR_FLAG_NO_DOWNLOAD_DATA = 64;
        public static final int UR_FLAG_NO_RETRY_ON_5XX = 128;
    }

    public static enum ReferrerPolicy {
        REFERRER_POLICY_DEFAULT,
        REFERRER_POLICY_CLEAR_REFERRER_ON_TRANSITION_FROM_SECURE_TO_INSECURE,
        REFERRER_POLICY_REDUCE_REFERRER_GRANULARITY_ON_TRANSITION_CROSS_ORIGIN,
        REFERRER_POLICY_ORIGIN_ONLY_ON_TRANSITION_CROSS_ORIGIN,
        REFERRER_POLICY_NEVER_CLEAR_REFERRER,
        REFERRER_POLICY_ORIGIN,
        REFERRER_POLICY_CLEAR_REFERRER_ON_TRANSITION_CROSS_ORIGIN,
        REFERRER_POLICY_ORIGIN_CLEAR_ON_TRANSITION_FROM_SECURE_TO_INSECURE,
        REFERRER_POLICY_NO_REFERRER,
        REFERRER_POLICY_LAST_VALUE;

    }

    public static enum ResourceType {
        RT_MAIN_FRAME,
        RT_SUB_FRAME,
        RT_STYLESHEET,
        RT_SCRIPT,
        RT_IMAGE,
        RT_FONT_RESOURCE,
        RT_SUB_RESOURCE,
        RT_OBJECT,
        RT_MEDIA,
        RT_WORKER,
        RT_SHARED_WORKER,
        RT_PREFETCH,
        RT_FAVICON,
        RT_XHR,
        RT_PING,
        RT_SERVICE_WORKER,
        RT_CSP_REPORT,
        RT_PLUGIN_RESOURCE,
        RT_NAVIGATION_PRELOAD_MAIN_FRAME,
        RT_NAVIGATION_PRELOAD_SUB_FRAME;

    }

    public static enum TransitionFlags {
        TT_BLOCKED_FLAG(0x800000),
        TT_FORWARD_BACK_FLAG(0x1000000),
        TT_CHAIN_START_FLAG(0x10000000),
        TT_CHAIN_END_FLAG(0x20000000),
        TT_CLIENT_REDIRECT_FLAG(0x40000000),
        TT_SERVER_REDIRECT_FLAG(Integer.MIN_VALUE);

        private final int flag;

        private TransitionFlags(int flag) {
            this.flag = flag;
        }

        public int getValue() {
            return this.flag;
        }
    }

    public static enum TransitionType {
        TT_LINK(0),
        TT_EXPLICIT(1),
        TT_AUTO_SUBFRAME(3),
        TT_MANUAL_SUBFRAME(4),
        TT_FORM_SUBMIT(7),
        TT_RELOAD(8);

        private int value;

        private TransitionType(int source) {
            this.value = source;
        }

        public int getValue() {
            return this.value;
        }

        public int getSource() {
            return this.value & 0xFF;
        }

        public void addQualifier(TransitionFlags flag) {
            this.value |= flag.getValue();
        }

        public void addQualifiers(int flags) {
            this.value |= flags & 0xFFFFFF00;
        }

        public int getQualifiers() {
            return this.value & 0xFFFFFF00;
        }

        public void removeQualifier(TransitionFlags flag) {
            this.value &= ~flag.getValue();
        }

        public boolean isSet(TransitionFlags flag) {
            return (this.value & flag.getValue()) != 0;
        }

        public boolean isRedirect() {
            return (this.value & 0xC0000000) != 0;
        }
    }
}

