/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.customdialog;

import com.swtxml.resources.IDocumentResource;
import com.swtxml.swt.SwtXmlParser;
import com.swtxml.tinydom.ITagVisitor;
import com.swtxml.tinydom.Tag;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.xml.sax.InputSource;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.customdialog.DVTCustomDialogSnapshotUtils;
import ro.amiq.dvt.customdialog.DVTDialogSerdes;
import ro.amiq.dvt.customdialog.DVTDialogSerdes2;
import ro.amiq.dvt.customdialog.DVTResultBuilder;
import ro.amiq.dvt.customdialog.DVTSnapshotSaveAsDialog;
import ro.amiq.dvt.customdialog.IDVTDialogSerdes;
import ro.amiq.dvt.customdialog.IDVTResultBuilder;
import ro.amiq.dvt.customdialog.core.DVTDialogSnapshotXMLParser1;
import ro.amiq.dvt.customdialog.core.DVTSnapshot;
import ro.amiq.dvt.customdialog.widgets.Container;
import ro.amiq.dvt.customdialog.widgets.DVTWidget;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.Utils;

public class DVTCustomDialog
extends Dialog {
    private static final String DELETE_SNAPSHOT_MESSAGE_FORMAT = "Are you sure you want to delete the {0} snapshot?";
    private static final String DELETE_SNAPSHOT_TITLE = "Delete Snapshot";
    private static final String OVERWRITE_SNAPSHOT_MESSAGE = "You are about to overwrite the entire snapshots file because it contains an error. Are you sure you want to continue?";
    private static final String OVERWRITE_SNAPSHOT_TITLE = "Overwrite Snapshot File";
    private static final String SAME_SNAPSHOT_MESSAGE = "Are you sure you want to undo the changes you made in the dialog?";
    private static final String SAME_SNAPSHOT_TITLE = "Same snapshot selected";
    private static final String UNABLE_TO_PASTE_MESSAGE = "The selected Clipboard content could not be loaded into your dialog";
    private static final String UNABLE_TO_PASTE_TITLE = "Unable to paste";
    private static final String OLD_SNAPSHOT_DETECTED_MESSAGE = "An earlier version of Custom Dialog snapshot file has been detected.\nAfter your first run/save you will upgrade to the new version";
    private static final String OLD_SNAPSHOT_DETECTED_TITLE = "Old Custom Dialog Snapshot detected";
    private static final String SNAPSHOTS_XML_EXTENSION = "snapshots.xml";
    private static final String USE_XML_SNAPSHOTS_SYS_VAR = "DVT_CUSTOM_DIALOG_OVERRIDE_USE_XML_SNAPSHOTS";
    private static final int RESTORE_DEFAULTS_ID = 1025;
    private static final String SNAPSHOT_LABEL = "Snapshot: ";
    public static final String DEFAULT = "default";
    public static final String DVT_CUSTOM_DIALOG_KEY = "dvt_custom_dialog_key";
    private static final String ID = "id";
    private static final String DEFAULT_TITLE = "Custom DVT Run Dialog";
    private static final String READ_ONLY_INDICATIOR = DVTPlugin.getDefault().getPreferenceStore().getString("readOnlyDecorator");
    private Tag fRoot;
    private Combo fSnapshotsCombo;
    private MenuItem fSaveMenuItem;
    private MenuItem fDeleteMenuItem;
    private String fTitleContribution;
    private IProject fProject;
    private IDVTDialogSerdes fDialogSerdes;
    private DVTSnapshot fDefaultSnapshot;
    private Map<String, DVTSnapshot> fSnapshotsLabelMap;
    private File fDialogFile;
    private DocumentResource fDocumentResource;
    private SwtXmlParser fParser;
    private IDVTResultBuilder fResultBuilder;
    private String fResult;
    private boolean fEnableSerdes;
    private boolean fEnableSave;
    private boolean fEnableDelete;
    protected String fPreviousSnapshotName;
    private String fSaveText;
    private boolean fOldVersion;
    private String fOldDefaultsStringRepresentation;
    private String fSnapshotFileName;
    private boolean fSetSnapshotFileLocation = false;
    private boolean fNonBlocking;

    public DVTCustomDialog(Shell parentShell, File dialogDescriptorFile, IProject project, boolean enableSerdes) throws MalformedURLException, IOException {
        super(parentShell);
        this.fProject = project;
        this.fEnableSerdes = enableSerdes;
        this.fResultBuilder = new DVTResultBuilder();
        this.fDialogFile = dialogDescriptorFile;
        this.fDocumentResource = new DocumentResource(dialogDescriptorFile);
        this.fSnapshotFileName = Path.fromOSString((String)dialogDescriptorFile.getAbsolutePath()).removeFileExtension().addFileExtension(SNAPSHOTS_XML_EXTENSION).lastSegment();
        String value = System.getenv(USE_XML_SNAPSHOTS_SYS_VAR);
        this.fOldVersion = "true".equalsIgnoreCase(value) ? false : "false".equalsIgnoreCase(value);
        File serdesFile = null;
        File oldSerdesFile = null;
        if (project != null && project.getLocation() != null) {
            serdesFile = new File(project.getLocation().toFile(), ".dvt" + File.separator + this.fSnapshotFileName);
            oldSerdesFile = new File(project.getLocation().toFile(), ".dvt" + File.separator + dialogDescriptorFile.getName() + ".last");
        }
        this.fDialogSerdes = this.fOldVersion ? new DVTDialogSerdes(dialogDescriptorFile.getName(), project) : ((serdesFile == null || !serdesFile.exists()) && oldSerdesFile != null && oldSerdesFile.exists() ? new DVTDialogSerdes(dialogDescriptorFile.getName(), project) : new DVTDialogSerdes2(this.fSnapshotFileName, project));
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
    }

    public int open() {
        ArrayList<DVTSnapshot> snapshots = new ArrayList<DVTSnapshot>();
        if (this.fEnableSerdes) {
            snapshots.addAll(this.fDialogSerdes.getSnapshots(true));
            for (DVTSnapshot snapshot : snapshots) {
                snapshot.setDialogFile(this.fDialogFile);
            }
            if (this.fDialogSerdes.isCancelled()) {
                return 1;
            }
            if (!this.fOldVersion && this.isBackwardCompatibleMode()) {
                MessageDialog.openWarning((Shell)ro.amiq.dvt.ui.Utils.getActiveShell(), (String)OLD_SNAPSHOT_DETECTED_TITLE, (String)OLD_SNAPSHOT_DETECTED_MESSAGE);
            }
            this.createLabelMap(snapshots);
        }
        return super.open();
    }

    protected final Control createDialogArea(Composite parent) {
        if (!DVTPlugin.getDefault().collect().c()) {
            return null;
        }
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite xmlComposite = new Composite(composite, 0);
        xmlComposite.setLayoutData((Object)new GridData(1808));
        xmlComposite.setLayout((Layout)new GridLayout());
        xmlComposite.setData(DVT_CUSTOM_DIALOG_KEY, (Object)this);
        this.fParser = new SwtXmlParser(xmlComposite, (IDocumentResource)this.fDocumentResource, (Object)this);
        this.fRoot = this.fParser.parse();
        this.fRoot.visitDepthFirst(new ITagVisitor[]{new ITagVisitor(){

            public void visit(Tag tag) {
                Widget widget = (Widget)tag.adaptTo(Widget.class);
                if (widget instanceof DVTWidget) {
                    try {
                        ((DVTWidget)widget).init(tag);
                    }
                    catch (Throwable t) {
                        DVTLogger.INSTANCE.logError(t);
                    }
                }
                if (widget instanceof Container) {
                    String snapshotFileLocation = ((Container)widget).getOwnParameter("snapshotFileLocation");
                    DVTCustomDialog.this.setSnapshotFileLocation(snapshotFileLocation);
                }
            }
        }});
        String title = this.fRoot.getAttribute(ID);
        if (title == null) {
            title = DEFAULT_TITLE;
        }
        this.getShell().setText(title);
        if (this.fEnableSerdes) {
            if (this.fOldVersion) {
                this.fOldDefaultsStringRepresentation = this.fDialogSerdes.getStringRepresentation(this.fRoot);
                this.fDialogSerdes.load(this.fRoot, this.fDialogFile);
            } else {
                this.fDefaultSnapshot = DVTCustomDialogSnapshotUtils.getSnapshotFromRoot(this.fRoot);
                this.fDialogSerdes.load(this.fRoot, this.fDialogFile);
                if (this.isBackwardCompatibleMode()) {
                    ((DVTDialogSerdes)this.fDialogSerdes).makeDVTSnapshotForBackwardCompatibility(this.fRoot);
                    DVTSnapshot defaultTimetampSnapshot = ((DVTDialogSerdes)this.fDialogSerdes).getDVTSnapshotForBackwardCompatibility();
                    defaultTimetampSnapshot.setReadOnly(false);
                    defaultTimetampSnapshot.setSnapshotFileType(DVTDialogSerdes2.SnapshotFileType.LOCAL);
                    defaultTimetampSnapshot.setDialogFile(this.fDialogFile);
                    this.fSnapshotsLabelMap.put(defaultTimetampSnapshot.getName(), defaultTimetampSnapshot);
                }
                this.fDefaultSnapshot.setIsTimestamp(false);
                this.fDefaultSnapshot.setName(DEFAULT);
                this.fDefaultSnapshot.setReadOnly(false);
                this.fDefaultSnapshot.setSnapshotFileType(DVTDialogSerdes2.SnapshotFileType.LOCAL);
                this.fDefaultSnapshot.setDialogFile(this.fDialogFile);
                this.fSnapshotsLabelMap.put(DEFAULT, this.fDefaultSnapshot);
            }
        }
        return composite;
    }

    public Tag getRoot() {
        return this.fRoot;
    }

    private boolean isBackwardCompatibleMode() {
        return this.fDialogSerdes instanceof DVTDialogSerdes;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        if (this.fOldVersion) {
            this.createButton(parent, 1025, "Restore Defaults", false);
        } else {
            GridLayoutFactory.fillDefaults().numColumns(3).extendedMargins(5, 5, 5, 5).applyTo(parent);
            GridDataFactory.fillDefaults().applyTo((Control)parent);
            Composite container = new Composite(parent, 0);
            container.moveAbove((Control)this.getButton(1));
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)container);
            GridLayoutFactory.fillDefaults().numColumns(2).applyTo(container);
            Composite snapshotContainer = new Composite(container, 0);
            GridDataFactory.fillDefaults().grab(true, false).align(4, 0x1000000).applyTo((Control)snapshotContainer);
            GridLayoutFactory.fillDefaults().numColumns(2).extendedMargins(5, 5, 5, 5).applyTo(snapshotContainer);
            Label label = new Label(snapshotContainer, 0);
            label.setText(SNAPSHOT_LABEL);
            this.fSnapshotsCombo = new Combo(snapshotContainer, 8);
            GridDataFactory.fillDefaults().grab(true, false).align(4, 0x1000000).applyTo((Control)this.fSnapshotsCombo);
            Object[] snapshotNames = this.fSnapshotsLabelMap.keySet().toArray(new String[this.fSnapshotsLabelMap.keySet().size()]);
            Arrays.sort(snapshotNames);
            this.fSnapshotsCombo.setItems((String[])snapshotNames);
            String lastRunSnapshotName = this.fDialogSerdes.getLastRunSnapshotName();
            boolean found = false;
            for (Map.Entry<String, DVTSnapshot> entry : this.fSnapshotsLabelMap.entrySet()) {
                String snapshotLabel = entry.getKey();
                DVTSnapshot snapshot = entry.getValue();
                if (!snapshot.getName().equals(lastRunSnapshotName)) continue;
                this.fSnapshotsCombo.setText(snapshotLabel);
                this.fPreviousSnapshotName = snapshotLabel;
                this.fEnableSave = !snapshot.isReadOnly();
                this.fEnableDelete = this.fEnableSave && snapshot.getSnapshotFileType() == this.fDialogSerdes.getSnapshotFileLocationType();
                found = true;
                break;
            }
            if (!found) {
                this.fSnapshotsCombo.setText(DEFAULT);
                this.fPreviousSnapshotName = DEFAULT;
                this.fEnableSave = false;
                this.fEnableDelete = false;
            }
            this.fSnapshotsCombo.addSelectionListener(this.getComboListener());
            Button advancedButton = new Button(container, 0x800404);
            advancedButton.setLayoutData((Object)new GridData());
            this.updateActionLabels();
            advancedButton.addSelectionListener(this.getAdvancedButtonListener(advancedButton));
        }
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 1025) {
            this.fDialogSerdes.loadFromString(this.fRoot, this.fOldDefaultsStringRepresentation);
        } else {
            super.buttonPressed(buttonId);
        }
    }

    private void createLabelMap(List<DVTSnapshot> snapshots) {
        this.fSnapshotsLabelMap = new HashMap<String, DVTSnapshot>();
        for (DVTSnapshot snapshot : snapshots) {
            String label = this.getLabelOfSnapshot(snapshot);
            this.fSnapshotsLabelMap.put(label, snapshot);
        }
    }

    private String getLabelOfSnapshot(DVTSnapshot snapshot) {
        String label = snapshot.getName();
        if (snapshot.isReadOnly()) {
            label = String.valueOf(label) + READ_ONLY_INDICATIOR;
        }
        if (snapshot.getSnapshotFileType() == null) {
            return label;
        }
        switch (snapshot.getSnapshotFileType()) {
            case LOCAL: {
                return label;
            }
            case DEFINED: {
                return String.valueOf(label) + "[" + this.fDialogSerdes.getSnapshotFileLocation() + "]";
            }
        }
        return String.valueOf(label) + " [" + snapshot.getSnapshotFileType().toString() + "]";
    }

    private void updateModelAndActionLabels(String snapshotName) {
        List<DVTSnapshot> snapshots = this.fDialogSerdes.getSnapshots(false);
        snapshots.add(this.fDefaultSnapshot);
        String label = snapshotName;
        for (DVTSnapshot snapshot : snapshots) {
            snapshot.setDialogFile(this.fDialogFile);
            if (!snapshot.getName().equals(snapshotName)) continue;
            label = this.getLabelOfSnapshot(snapshot);
        }
        this.createLabelMap(snapshots);
        Object[] updatedSnapshotNames = this.fSnapshotsLabelMap.keySet().toArray(new String[this.fSnapshotsLabelMap.keySet().size()]);
        Arrays.sort(updatedSnapshotNames);
        this.fSnapshotsCombo.setItems((String[])updatedSnapshotNames);
        this.fSnapshotsCombo.setText(label);
        this.updateActionLabels();
    }

    private void updateActionLabels() {
        DVTSnapshot currentSnapshot = this.fSnapshotsLabelMap.get(this.fSnapshotsCombo.getText());
        String snapshotName = currentSnapshot.getName();
        this.fEnableDelete = !currentSnapshot.isReadOnly() && currentSnapshot.getSnapshotFileType() == this.fDialogSerdes.getSnapshotFileLocationType();
        boolean bl = this.fEnableSave = !currentSnapshot.isReadOnly();
        if (snapshotName.equals(DEFAULT)) {
            this.fEnableSave = false;
            this.fEnableDelete = false;
        } else if (DVTCustomDialogSnapshotUtils.isTimestampSnapshotNameFor(DEFAULT, snapshotName)) {
            this.fEnableSave = false;
        }
        this.fSaveText = "Save";
        if (currentSnapshot.isTimestamp()) {
            String userDefinedSnapshotName = DVTCustomDialogSnapshotUtils.getUserDefinedSnapshotName(currentSnapshot.getName(), this.fSnapshotsLabelMap.values());
            this.fSaveText = String.valueOf(this.fSaveText) + (userDefinedSnapshotName == null || userDefinedSnapshotName.isEmpty() ? "" : " to " + userDefinedSnapshotName);
        }
    }

    public void setSnapshotFileLocation(String snapshotFileLocation) {
        if (snapshotFileLocation == null || snapshotFileLocation.isEmpty()) {
            return;
        }
        if (this.fDialogSerdes == null) {
            return;
        }
        if (this.fSetSnapshotFileLocation) {
            return;
        }
        File file = new File(snapshotFileLocation);
        if (file.isDirectory() && file.exists()) {
            this.fDialogSerdes.setSnapshotFileLocationType(DVTDialogSerdes2.SnapshotFileType.DEFINED);
            this.fDialogSerdes.setSnapshotFileLocation(snapshotFileLocation);
            List<DVTSnapshot> snapshots = this.fDialogSerdes.getSnapshots(false);
            for (DVTSnapshot snapshot : snapshots) {
                snapshot.setDialogFile(this.fDialogFile);
            }
            this.createLabelMap(snapshots);
            this.fSetSnapshotFileLocation = true;
        }
    }

    private SelectionListener getSaveListener() {
        return new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DVTSnapshot currentSnapshot = DVTCustomDialogSnapshotUtils.getSnapshotFromRoot(DVTCustomDialog.this.fRoot);
                currentSnapshot.setDialogFile(DVTCustomDialog.this.fDialogFile);
                String snapshotComboText = DVTCustomDialog.this.fSnapshotsCombo.getText();
                String snapshotName = DVTCustomDialog.this.fSnapshotsLabelMap.get(snapshotComboText).getName();
                if (!DVTCustomDialog.this.fSnapshotsLabelMap.get(snapshotComboText).isTimestamp()) {
                    DVTCustomDialog.this.fDialogSerdes.overwriteSnapshot(currentSnapshot, snapshotName, snapshotName, false, false);
                } else {
                    snapshotComboText = DVTCustomDialogSnapshotUtils.getUserDefinedSnapshotName(snapshotName, DVTCustomDialog.this.fSnapshotsLabelMap.values());
                    DVTCustomDialog.this.fDialogSerdes.overwriteSnapshot(currentSnapshot, snapshotComboText, snapshotComboText, false, false);
                }
                List<DVTSnapshot> snapshots = DVTCustomDialog.this.fDialogSerdes.getSnapshots(false);
                snapshots.add(DVTCustomDialog.this.fDefaultSnapshot);
                for (DVTSnapshot snapshot : snapshots) {
                    snapshot.setDialogFile(DVTCustomDialog.this.fDialogFile);
                }
                DVTCustomDialog.this.createLabelMap(snapshots);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
    }

    private SelectionListener getPasteFromClipboardListener() {
        return new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    boolean loaded;
                    String snapshotString = Utils.pasteFromClipboard();
                    DVTDialogSnapshotXMLParser1 parser = new DVTDialogSnapshotXMLParser1(null);
                    DVTSnapshot snapshot = parser.loadFromString(snapshotString);
                    snapshot.setDialogFile(DVTCustomDialog.this.fDialogFile);
                    if (!parser.getMessages().isEmpty()) {
                        this.openPasteWarning(parser.getMessages().get(0));
                    }
                    if (!(loaded = DVTCustomDialogSnapshotUtils.loadFromSnapshot(DVTCustomDialog.this.fRoot, DVTCustomDialog.this.fDialogFile, snapshot))) {
                        this.openPasteWarning(null);
                    }
                }
                catch (Exception ex) {
                    DVTLogger.INSTANCE.logError((Throwable)ex);
                    this.openPasteWarning(ex.getMessage());
                }
            }

            private void openPasteWarning(String message) {
                MessageDialog.openWarning((Shell)ro.amiq.dvt.ui.Utils.getActiveShell(), (String)DVTCustomDialog.UNABLE_TO_PASTE_TITLE, (String)(DVTCustomDialog.UNABLE_TO_PASTE_MESSAGE + (message == null ? "" : " because:\n\n" + message)));
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
    }

    private SelectionListener getCopyToClipboardListener() {
        return new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Utils.copyToClipboard((String)DVTCustomDialogSnapshotUtils.getSnapshotString(DVTCustomDialogSnapshotUtils.getSnapshotFromRoot(DVTCustomDialog.this.fRoot), DVTCustomDialog.this.fSnapshotsLabelMap.get(DVTCustomDialog.this.fSnapshotsCombo.getText()).getName(), DVTCustomDialog.this.fSnapshotsLabelMap.get(DVTCustomDialog.this.fSnapshotsCombo.getText()).isTimestamp()), (int)3);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
    }

    private SelectionListener getSaveAsListener() {
        return new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DVTSnapshotSaveAsDialog dialog;
                TreeMap<String, Boolean> snapshotReadOnlyMap = new TreeMap<String, Boolean>();
                for (Map.Entry<String, DVTSnapshot> entry : DVTCustomDialog.this.fSnapshotsLabelMap.entrySet()) {
                    String snapshotLabel = entry.getKey();
                    DVTSnapshot snapshot = entry.getValue();
                    if (snapshot.isTimestamp() || snapshotLabel.equals(DVTCustomDialog.DEFAULT)) continue;
                    snapshotReadOnlyMap.put(snapshotLabel, snapshot.isReadOnly());
                }
                String defaultName = DVTCustomDialog.this.fSnapshotsCombo.getText();
                if (DVTCustomDialog.this.fSnapshotsLabelMap.get(defaultName).isTimestamp()) {
                    String userDefinedName = DVTCustomDialogSnapshotUtils.getUserDefinedSnapshotName(DVTCustomDialog.this.fSnapshotsLabelMap.get(defaultName).getName(), DVTCustomDialog.this.fSnapshotsLabelMap.values());
                    for (DVTSnapshot snapshot : DVTCustomDialog.this.fSnapshotsLabelMap.values()) {
                        if (!snapshot.getName().equals(userDefinedName)) continue;
                        defaultName = DVTCustomDialog.this.getLabelOfSnapshot(snapshot);
                    }
                }
                if ((dialog = new DVTSnapshotSaveAsDialog(ro.amiq.dvt.ui.Utils.getActiveShell(), defaultName, snapshotReadOnlyMap)).open() == 0) {
                    String name = dialog.getResult();
                    if (DVTCustomDialog.this.fSnapshotsLabelMap.containsKey(name)) {
                        String snapshotName = DVTCustomDialog.this.fSnapshotsLabelMap.get(name).getName();
                        DVTCustomDialog.this.fDialogSerdes.overwriteSnapshot(DVTCustomDialogSnapshotUtils.getSnapshotFromRoot(DVTCustomDialog.this.fRoot), snapshotName, snapshotName, false, false);
                    } else {
                        if (DVTCustomDialog.this.isBackwardCompatibleMode()) {
                            DVTCustomDialog.this.fDialogSerdes = new DVTDialogSerdes2(DVTCustomDialog.this.fSnapshotFileName, DVTCustomDialog.this.fProject);
                            for (DVTSnapshot snp : DVTCustomDialog.this.fSnapshotsLabelMap.values()) {
                                if (!snp.isTimestamp() || !DVTCustomDialogSnapshotUtils.isTimestampSnapshotNameFor(DVTCustomDialog.DEFAULT, snp.getName())) continue;
                                ((DVTDialogSerdes2)DVTCustomDialog.this.fDialogSerdes).saveSnapshot(snp);
                                DVTCustomDialog.this.fDialogSerdes.getSnapshots(false);
                            }
                        }
                        DVTCustomDialog.this.fDialogSerdes.appendNewSnapshot(DVTCustomDialog.this.fRoot, name, false, false);
                    }
                    DVTCustomDialog.this.updateModelAndActionLabels(name);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
    }

    private SelectionListener getDeleteListener() {
        return new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String snapshotComboText = DVTCustomDialog.this.fSnapshotsCombo.getText();
                boolean confirm = MessageDialog.openConfirm((Shell)ro.amiq.dvt.ui.Utils.getActiveShell(), (String)DVTCustomDialog.DELETE_SNAPSHOT_TITLE, (String)MessageFormat.format(DVTCustomDialog.DELETE_SNAPSHOT_MESSAGE_FORMAT, snapshotComboText));
                if (!confirm) {
                    return;
                }
                DVTCustomDialog.this.fDialogSerdes.remove(DVTCustomDialog.this.fSnapshotsLabelMap.get(snapshotComboText).getName());
                DVTCustomDialog.this.fSnapshotsLabelMap.remove(snapshotComboText);
                DVTCustomDialog.this.updateModelAndActionLabels(DVTCustomDialog.DEFAULT);
                DVTCustomDialog.this.fPreviousSnapshotName = DVTCustomDialog.DEFAULT;
                DVTCustomDialogSnapshotUtils.loadFromSnapshot(DVTCustomDialog.this.fRoot, DVTCustomDialog.this.fDialogFile, DVTCustomDialog.this.fDefaultSnapshot);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
    }

    private SelectionListener getAdvancedButtonListener(final Button buttonMenu) {
        return new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Menu menu = new Menu((Decorations)ro.amiq.dvt.ui.Utils.getActiveShell(), 8);
                DVTCustomDialog.this.fSaveMenuItem = new MenuItem(menu, 8);
                DVTCustomDialog.this.fSaveMenuItem.setEnabled(DVTCustomDialog.this.fEnableSave);
                DVTCustomDialog.this.fSaveMenuItem.setText(DVTCustomDialog.this.fSaveText);
                DVTCustomDialog.this.fSaveMenuItem.addSelectionListener(DVTCustomDialog.this.getSaveListener());
                MenuItem saveAsMenuItem = new MenuItem(menu, 8);
                saveAsMenuItem.setText("Save As...");
                saveAsMenuItem.addSelectionListener(DVTCustomDialog.this.getSaveAsListener());
                DVTCustomDialog.this.fDeleteMenuItem = new MenuItem(menu, 8);
                DVTCustomDialog.this.fDeleteMenuItem.setEnabled(DVTCustomDialog.this.fEnableDelete);
                DVTCustomDialog.this.fDeleteMenuItem.setText("Delete");
                DVTCustomDialog.this.fDeleteMenuItem.addSelectionListener(DVTCustomDialog.this.getDeleteListener());
                MenuItem copyMenuItem = new MenuItem(menu, 8);
                copyMenuItem.setText("Copy To Clipboard");
                copyMenuItem.addSelectionListener(DVTCustomDialog.this.getCopyToClipboardListener());
                MenuItem pasteMenuItem = new MenuItem(menu, 8);
                pasteMenuItem.setText("Paste From Clipboard");
                pasteMenuItem.addSelectionListener(DVTCustomDialog.this.getPasteFromClipboardListener());
                Point loc = buttonMenu.getLocation();
                Rectangle rect = buttonMenu.getBounds();
                Point mLoc = new Point(loc.x - 1, loc.y + rect.height);
                menu.setLocation(ro.amiq.dvt.ui.Utils.getActiveShell().getDisplay().map((Control)buttonMenu.getParent(), null, mLoc));
                menu.setVisible(true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
    }

    private SelectionListener getComboListener() {
        return new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                boolean confirm;
                String snapshotComboText = DVTCustomDialog.this.fSnapshotsCombo.getText();
                DVTSnapshot currentSnapshot = DVTCustomDialogSnapshotUtils.getSnapshotFromRoot(DVTCustomDialog.this.fRoot);
                currentSnapshot.setDialogFile(DVTCustomDialog.this.fDialogFile);
                DVTSnapshot snapshot = DVTCustomDialog.this.fSnapshotsLabelMap.get(DVTCustomDialog.this.fPreviousSnapshotName);
                if (!snapshot.equals(currentSnapshot) && snapshotComboText.equals(DVTCustomDialog.this.fPreviousSnapshotName) && !(confirm = MessageDialog.openConfirm((Shell)ro.amiq.dvt.ui.Utils.getActiveShell(), (String)DVTCustomDialog.SAME_SNAPSHOT_TITLE, (String)DVTCustomDialog.SAME_SNAPSHOT_MESSAGE))) {
                    return;
                }
                boolean hasLoaded = false;
                if (DVTCustomDialog.this.fSnapshotsLabelMap.get(snapshotComboText) != null) {
                    hasLoaded = DVTCustomDialogSnapshotUtils.loadFromSnapshot(DVTCustomDialog.this.fRoot, DVTCustomDialog.this.fDialogFile, DVTCustomDialog.this.fSnapshotsLabelMap.get(snapshotComboText));
                }
                if (!hasLoaded) {
                    DVTCustomDialog.this.fSnapshotsCombo.setText(DVTCustomDialog.this.fPreviousSnapshotName == null ? DVTCustomDialog.DEFAULT : DVTCustomDialog.this.fPreviousSnapshotName);
                } else {
                    DVTCustomDialog.this.fPreviousSnapshotName = DVTCustomDialog.this.fSnapshotsCombo.getText();
                }
                DVTCustomDialog.this.updateActionLabels();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
    }

    protected boolean isResizable() {
        return true;
    }

    public String getResult() {
        return this.fResult;
    }

    public IProject getProject() {
        return this.fProject;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void okPressed() {
        if (this.fEnableSerdes) {
            if (this.fOldVersion) {
                this.fDialogSerdes.save(this.fRoot, "", false);
            } else {
                String snapshotComboText = this.fSnapshotsCombo.getText();
                DVTSnapshot currentSnapshot = DVTCustomDialogSnapshotUtils.getSnapshotFromRoot(this.fRoot);
                currentSnapshot.setDialogFile(this.fDialogFile);
                DVTSnapshot snapshot = this.fSnapshotsLabelMap.get(snapshotComboText);
                if (!this.fDialogSerdes.isSnapshotFileParsedCorectly()) {
                    boolean confirmOverwrite = MessageDialog.openConfirm((Shell)ro.amiq.dvt.ui.Utils.getActiveShell(), (String)OVERWRITE_SNAPSHOT_TITLE, (String)OVERWRITE_SNAPSHOT_MESSAGE);
                    if (!confirmOverwrite) return;
                    this.fDialogSerdes.save(this.fRoot, DEFAULT + DVTCustomDialogSnapshotUtils.getDateFormat().format(new Date()), true);
                } else {
                    if (this.isBackwardCompatibleMode()) {
                        this.fDialogSerdes = new DVTDialogSerdes2(this.fSnapshotFileName, this.fProject);
                        for (DVTSnapshot snp : this.fSnapshotsLabelMap.values()) {
                            if (!snp.isTimestamp() || !DVTCustomDialogSnapshotUtils.isTimestampSnapshotNameFor(DEFAULT, snp.getName())) continue;
                            ((DVTDialogSerdes2)this.fDialogSerdes).saveSnapshot(snp);
                            this.fDialogSerdes.getSnapshots(false);
                        }
                    }
                    if (!currentSnapshot.equals(snapshot)) {
                        this.fDialogSerdes.handleOk(this.fRoot, this.fSnapshotsLabelMap.get(snapshotComboText), this.fDefaultSnapshot);
                    } else {
                        this.fDialogSerdes.updateLastRunSnapshot(snapshot.getName());
                    }
                }
            }
        }
        this.fResultBuilder.computeResult(this.fRoot);
        this.fResult = this.fResultBuilder.getResult();
        this.fTitleContribution = this.fResultBuilder.getTitleContribution();
        if (this.fTitleContribution != null && !this.fTitleContribution.isEmpty()) {
            this.fTitleContribution = "[" + this.fTitleContribution + "] ";
        }
        super.okPressed();
    }

    public String getTitleContribution() {
        return this.fTitleContribution;
    }

    public void setNonBlocking(boolean nonBlocking) {
        this.fNonBlocking = nonBlocking;
    }

    protected int getShellStyle() {
        if (this.fNonBlocking) {
            return 2144;
        }
        return super.getShellStyle();
    }

    public Widget getWidgetForPath(Tag dialogRoot, String path) {
        if (path == null || path.isEmpty()) {
            return null;
        }
        String[] pathSegments = path.split("/");
        if (pathSegments == null || pathSegments.length == 0) {
            return null;
        }
        Pattern widgetIndexPattern = Pattern.compile("[1-9][0-9]*");
        Pattern widgetNamePattern = Pattern.compile("\\w+");
        return this.getWidgetForSegment(pathSegments, 2, widgetIndexPattern, widgetNamePattern, dialogRoot);
    }

    private Widget getWidgetForSegment(String[] pathSegments, int segmentIndex, Pattern widgetIndexPattern, Pattern widgetNamePattern, Tag root) {
        if (segmentIndex >= pathSegments.length) {
            return null;
        }
        String currentSegment = pathSegments[segmentIndex];
        int index = -1;
        Matcher widgetIndexMatcher = widgetIndexPattern.matcher(currentSegment);
        if (widgetIndexMatcher.find()) {
            String widgetIndex = widgetIndexMatcher.group();
            index = Integer.valueOf(widgetIndex);
        }
        String widgetName = null;
        Matcher widgetNameMatcher = widgetNamePattern.matcher(currentSegment);
        if (widgetNameMatcher.find()) {
            widgetName = widgetNameMatcher.group();
        }
        if (index < 0 && segmentIndex > 1 || widgetName == null) {
            return null;
        }
        int count = 0;
        for (Tag child : root.getChildren()) {
            String childName;
            Widget widget = (Widget)child.adaptTo(Widget.class);
            if (widget == null || !widgetName.equals(childName = widget.getClass().getSimpleName()) || ++count != index) continue;
            if (segmentIndex == pathSegments.length - 1) {
                return widget;
            }
            return this.getWidgetForSegment(pathSegments, segmentIndex + 1, widgetIndexPattern, widgetNamePattern, child);
        }
        return null;
    }

    static class DocumentResource
    implements IDocumentResource {
        private InputSource fInputSource;
        private File fFile;

        public DocumentResource(File dialogDescriptor) throws MalformedURLException, IOException {
            this.fFile = dialogDescriptor;
            this.fInputSource = new InputSource(this.fFile.toURI().toURL().openStream());
        }

        public InputStream resolve(String path) {
            return null;
        }

        public InputSource getInputSource() {
            return this.fInputSource;
        }

        public String getDocumentName() {
            return this.fFile.getName();
        }
    }
}

