/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.customdialog;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.ui.Utils;

public class DVTCustomDialogConfirmDialog
extends MessageDialog {
    private IFile fSnapshotFile;
    private static final String CANNOT_LOAD_TITLE = "Cannot Load Custom Dialog Snapshots";

    public DVTCustomDialogConfirmDialog(Shell parentShell, String dialogMessage, IFile snapshotFile) {
        super(parentShell, CANNOT_LOAD_TITLE, null, dialogMessage, 4, new String[]{"OK", "Cancel"}, 0);
        this.fSnapshotFile = snapshotFile;
    }

    protected Control createMessageArea(Composite composite) {
        Image image = this.getImage();
        if (image == null || this.message == null) {
            return composite;
        }
        this.imageLabel = new Label(composite, 0);
        image.setBackground(this.imageLabel.getBackground());
        this.imageLabel.setImage(image);
        GridDataFactory.fillDefaults().align(0x1000000, 1).applyTo((Control)this.imageLabel);
        Link link = new Link(composite, this.getMessageLabelStyle());
        link.setText(this.message);
        DVTUiUtils.setPlatformLinkColor((Link)link);
        GridDataFactory.fillDefaults().align(4, 1).grab(true, false).hint(this.convertHorizontalDLUsToPixels(300), -1).applyTo((Control)link);
        if (this.fSnapshotFile != null && this.fSnapshotFile.exists()) {
            link.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                IDE.openEditor((IWorkbenchPage)Utils.getActiveWorkbenchWindow().getActivePage(), (IFile)(this).DVTCustomDialogConfirmDialog.this.fSnapshotFile);
                            }
                            catch (PartInitException e) {
                                DVTLogger.INSTANCE.logError((Throwable)e);
                            }
                        }
                    });
                    DVTCustomDialogConfirmDialog.this.cancelPressed();
                    DVTCustomDialogConfirmDialog.this.close();
                }
            });
        }
        return composite;
    }
}

