/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.customdialog;

import com.swtxml.tinydom.ITagVisitor;
import com.swtxml.tinydom.Tag;
import com.swtxml.util.types.SimpleTypes;
import java.io.File;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.apache.xerces.jaxp.DocumentBuilderFactoryImpl;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import ro.amiq.dvt.customdialog.core.DVTDialogElement;
import ro.amiq.dvt.customdialog.core.DVTSnapshot;
import ro.amiq.dvt.customdialog.widgets.Container;
import ro.amiq.dvt.customdialog.widgets.DVTWidget;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.XMLErrorHandler;

public class DVTCustomDialogSnapshotUtils {
    public static final String SNAPSHOT_TAG_FORMAT = "<snapshot name=\"{0}\" timestamp=\"{1}\">\n";
    public static final String ELEMENT_TAG_FORMAT = "<element path=\"{0}\" value=\"{1}\"/>\n";
    public static final String SNAPSHOT_END_TAG = "</snapshot>";
    public static final String TAB = "    ";
    private static final String ELEMENT_NOT_FOUND_TITLE = "Element Not Found";
    private static final String ELEMENT_NOT_FOUND_MESSAGE_FORMAT = "The element with the following XPath: {0} could not be found. The {1} snapshot will not be loaded";
    public static final String DATE_FORMAT_STRING = " [yyyy-MM-dd HH:mm:ss]";
    public static final String DATE_FORMAT_REGEX = " \\[\\d+-\\d+-\\d+ \\d+:\\d+:\\d+\\]";

    public static SimpleDateFormat getDateFormat() {
        return new SimpleDateFormat(DATE_FORMAT_STRING);
    }

    public static DVTSnapshot getSnapshotFromRoot(Tag root) {
        DVTSnapshot snapshot = new DVTSnapshot();
        if (root == null) {
            return snapshot;
        }
        Widget rootWidget = (Widget)root.adaptTo(Widget.class);
        if (rootWidget == null) {
            return snapshot;
        }
        String path = "/" + rootWidget.getClass().getSimpleName();
        DVTCustomDialogSnapshotUtils.addChildren(snapshot, root, path);
        return snapshot;
    }

    private static void addChildren(DVTSnapshot snapshot, Tag root, String path) {
        HashMap<String, Integer> widgetCount = new HashMap<String, Integer>();
        for (Tag child : root.getChildren()) {
            Widget widget = (Widget)child.adaptTo(Widget.class);
            if (widget == null) continue;
            DVTDialogElement element = new DVTDialogElement();
            String widgetName = widget.getClass().getSimpleName();
            int count = 1;
            if (widgetCount.keySet().contains(widgetName)) {
                count = (Integer)widgetCount.get(widgetName);
            }
            element.setPath(String.valueOf(path) + "/" + widgetName + "[" + count + "]");
            String value = DVTCustomDialogSnapshotUtils.getWidgetValue(widget);
            if (value != null) {
                element.setValue(value);
            } else {
                element.setValue("");
            }
            DVTCustomDialogSnapshotUtils.addChildren(snapshot, child, String.valueOf(path) + "/" + widget.getClass().getSimpleName() + "[" + count + "]");
            widgetCount.put(widgetName, ++count);
            snapshot.addElement(element);
        }
    }

    private static String getWidgetValue(Widget widget) {
        String value = null;
        if (widget instanceof Button) {
            value = Boolean.toString(((Button)widget).getSelection());
        } else if (widget instanceof Text) {
            value = ((Text)widget).getText();
        } else if (widget instanceof DVTWidget) {
            value = ((DVTWidget)widget).getStringRepresentation();
        } else if (widget instanceof Combo) {
            value = ((Combo)widget).getText();
        } else if (widget instanceof org.eclipse.swt.widgets.List) {
            value = DVTStringUtil.join(Arrays.asList(((org.eclipse.swt.widgets.List)widget).getSelection()), (String)";");
        } else if (widget instanceof Spinner) {
            value = "" + ((Spinner)widget).getSelection();
        } else if (widget instanceof Slider) {
            value = "" + ((Slider)widget).getSelection();
        }
        return value;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean loadFromSnapshot(Tag root, File dialogFile, DVTSnapshot snapshot) {
        Widget rootWidget;
        if (root == null || snapshot == null) {
            return false;
        }
        List<DVTDialogElement> elements = snapshot.getElements();
        if (elements == null || elements.isEmpty()) {
            return false;
        }
        if (dialogFile != null) {
            try {
                DocumentBuilder builder = DVTCustomDialogSnapshotUtils.getDocumentBuilder();
                builder.setErrorHandler((ErrorHandler)XMLErrorHandler.INSTANCE);
                Document doc = builder.parse(dialogFile);
                doc.getDocumentElement().normalize();
                XPath xPath = XPathFactory.newInstance().newXPath();
                for (DVTDialogElement element : snapshot.getElements()) {
                    String path = element.getPath();
                    Node node = (Node)xPath.compile(path).evaluate(doc, XPathConstants.NODE);
                    if (node == null) {
                        DVTCustomDialogSnapshotUtils.reportElementNotFound(element.getPath(), snapshot.getName());
                        return false;
                    }
                    xPath.reset();
                }
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
        if ((rootWidget = (Widget)root.adaptTo(Widget.class)) == null) {
            return false;
        }
        String path = "/" + rootWidget.getClass().getSimpleName();
        HashMap<String, Integer> numbersMap = new HashMap<String, Integer>();
        for (Tag child : root.getChildren()) {
            Widget widget = (Widget)child.adaptTo(Widget.class);
            if (widget == null) continue;
            String widgetName = widget.getClass().getSimpleName();
            int count = 1;
            if (numbersMap.keySet().contains(widgetName)) {
                count = (Integer)numbersMap.get(widgetName);
            }
            for (DVTDialogElement snapshotElement : snapshot.getElements()) {
                String basicPath = String.valueOf(path) + "/" + widgetName + "[" + count + "]";
                if (snapshotElement.getValue() == null || !basicPath.equals(snapshotElement.getPath())) continue;
                DVTCustomDialogSnapshotUtils.setWidgetValue(widget, snapshotElement);
                break;
            }
            DVTCustomDialogSnapshotUtils.loadChildren(dialogFile, snapshot, child, String.valueOf(path) + "/" + widget.getClass().getSimpleName() + "[" + count + "]");
            numbersMap.put(widgetName, ++count);
        }
        root.visitDepthFirst(new ITagVisitor[]{new ITagVisitor(){

            public void visit(Tag tag) {
                Widget widget = (Widget)tag.adaptTo(Widget.class);
                if (widget instanceof Container) {
                    ((Container)widget).snapshotLoaded();
                }
            }
        }});
        return true;
    }

    private static void loadChildren(File dialogFile, DVTSnapshot snapshot, Tag root, String path) {
        HashMap<String, Integer> numbersMap = new HashMap<String, Integer>();
        for (Tag child : root.getChildren()) {
            Widget widget = (Widget)child.adaptTo(Widget.class);
            if (widget == null) continue;
            String widgetName = widget.getClass().getSimpleName();
            int count = 1;
            if (numbersMap.keySet().contains(widgetName)) {
                count = (Integer)numbersMap.get(widgetName);
            }
            for (DVTDialogElement snapshotElement : snapshot.getElements()) {
                String basicPath = String.valueOf(path) + "/" + widgetName + "[" + count + "]";
                if (snapshotElement.getValue() == null || !basicPath.equals(snapshotElement.getPath())) continue;
                DVTCustomDialogSnapshotUtils.setWidgetValue(widget, snapshotElement);
                break;
            }
            DVTCustomDialogSnapshotUtils.loadChildren(dialogFile, snapshot, child, String.valueOf(path) + "/" + widget.getClass().getSimpleName() + "[" + count + "]");
            numbersMap.put(widgetName, ++count);
        }
    }

    private static void setWidgetValue(Widget widget, DVTDialogElement element) {
        if (widget instanceof Button) {
            ((Button)widget).setSelection(new Boolean(element.getValue()).booleanValue());
        } else if (widget instanceof Text) {
            ((Text)widget).setText(element.getValue());
        } else if (widget instanceof DVTWidget) {
            ((DVTWidget)widget).setStringRepresentation(element.getValue());
        } else if (widget instanceof Combo) {
            ((Combo)widget).setText(element.getValue());
        } else if (widget instanceof org.eclipse.swt.widgets.List) {
            ((org.eclipse.swt.widgets.List)widget).setSelection((String[])SimpleTypes.STRING_ARRAY.convert(element.getValue()));
        } else if (widget instanceof Spinner) {
            try {
                ((Spinner)widget).setSelection(Integer.parseInt(element.getValue()));
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (widget instanceof Slider) {
            try {
                ((Slider)widget).setSelection(Integer.parseInt(element.getValue()));
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    public static boolean checkXPathsAreEqual(File dialogFile, String xPathString1, String xPathString2) {
        Node node2;
        Node node1;
        block10: {
            Document doc;
            block9: {
                block8: {
                    block7: {
                        if (dialogFile != null) break block7;
                        return false;
                    }
                    doc = DVTCustomDialogSnapshotUtils.getDocument(dialogFile);
                    if (doc != null) break block8;
                    return false;
                }
                node1 = DVTCustomDialogSnapshotUtils.getXPathNode(xPathString1, doc);
                if (node1 != null) break block9;
                return false;
            }
            node2 = DVTCustomDialogSnapshotUtils.getXPathNode(xPathString2, doc);
            if (node2 != null) break block10;
            return false;
        }
        try {
            if (node1.equals(node2)) {
                return true;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return false;
    }

    public static Document getDocument(File dialogFile) {
        try {
            DocumentBuilder builder = DVTCustomDialogSnapshotUtils.getDocumentBuilder();
            builder.setErrorHandler((ErrorHandler)XMLErrorHandler.INSTANCE);
            Document doc = builder.parse(dialogFile);
            doc.getDocumentElement().normalize();
            return doc;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    private static DocumentBuilder getDocumentBuilder() throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        if (factory instanceof DocumentBuilderFactoryImpl) {
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        } else {
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
        }
        return factory.newDocumentBuilder();
    }

    public static Node getXPathNode(String xPathString, Document doc) {
        XPathExpression xPathExpression;
        block5: {
            block4: {
                try {
                    if (xPathString != null) break block4;
                    return null;
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    return null;
                }
            }
            XPath xPath = XPathFactory.newInstance().newXPath();
            xPathExpression = xPath.compile(xPathString);
            xPath.reset();
            if (xPathExpression != null) break block5;
            return null;
        }
        return (Node)xPathExpression.evaluate(doc, XPathConstants.NODE);
    }

    private static void reportElementNotFound(String path, String snapshotName) {
        new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), ELEMENT_NOT_FOUND_TITLE, null, MessageFormat.format(ELEMENT_NOT_FOUND_MESSAGE_FORMAT, path, snapshotName), 4, new String[]{IDialogConstants.OK_LABEL}, 0).open();
    }

    public static String getSnapshotString(DVTSnapshot snapshot, String name, boolean timestampSnapshot) {
        String result = TAB + MessageFormat.format(SNAPSHOT_TAG_FORMAT, name, Boolean.toString(timestampSnapshot));
        for (DVTDialogElement element : snapshot.getElements()) {
            String value = DVTCustomDialogSnapshotUtils.translateValue(element);
            result = String.valueOf(result) + "        " + MessageFormat.format(ELEMENT_TAG_FORMAT, element.getPath(), value);
        }
        result = String.valueOf(result) + "    </snapshot>";
        return result;
    }

    public static String translateValue(DVTDialogElement element) {
        return element.getValue() == null ? "" : DVTStringUtil.escapeXMLString((String)element.getValue(), (boolean)true);
    }

    public static String getUserDefinedSnapshotName(String timestamptSnapshotName, Collection<DVTSnapshot> availableSnapshots) {
        for (DVTSnapshot snapshot : availableSnapshots) {
            if (!DVTCustomDialogSnapshotUtils.isTimestampSnapshotNameFor(snapshot.getName(), timestamptSnapshotName)) continue;
            return snapshot.getName();
        }
        return "";
    }

    public static boolean isTimestampSnapshotNameFor(String userDefinedSnapshotName, String snapshotName) {
        if (userDefinedSnapshotName.endsWith("[USER]")) {
            return snapshotName.matches(String.valueOf(Pattern.quote(userDefinedSnapshotName)) + DATE_FORMAT_REGEX + "[USER]");
        }
        if (userDefinedSnapshotName.endsWith("[COMMON]")) {
            return snapshotName.matches(String.valueOf(Pattern.quote(userDefinedSnapshotName)) + DATE_FORMAT_REGEX + "[COMMON]");
        }
        return snapshotName.matches(String.valueOf(Pattern.quote(userDefinedSnapshotName)) + DATE_FORMAT_REGEX);
    }
}

