/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.customdialog;

import com.swtxml.tinydom.ITagVisitor;
import com.swtxml.tinydom.Tag;
import com.swtxml.util.types.SimpleTypes;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import ro.amiq.dvt.customdialog.DVTCustomDialogSnapshotUtils;
import ro.amiq.dvt.customdialog.DVTDialogSerdes2;
import ro.amiq.dvt.customdialog.IDVTDialogSerdes;
import ro.amiq.dvt.customdialog.core.DVTSnapshot;
import ro.amiq.dvt.customdialog.widgets.DVTWidget;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTStringUtil;

public class DVTDialogSerdes
implements IDVTDialogSerdes {
    private static final String COMMA = ",";
    private static final String ID = "id";
    public static final String NEWLINE = System.getProperty("line.separator");
    private File fSerdesFile;
    private DVTSnapshot fBackwardCompatibilitySnapshot;

    public DVTDialogSerdes(String dialogName, IProject project) {
        if (project != null && project.getLocation() != null) {
            this.fSerdesFile = new File(project.getLocation().toFile(), ".dvt" + File.separator + dialogName + ".last");
        }
    }

    @Override
    public void loadFromString(final Tag root, String stringRepresentation) {
        if (root == null || stringRepresentation == null) {
            return;
        }
        String[] serdesLines = stringRepresentation.split(NEWLINE);
        final LinkedList<SerdesEntry> serdesEntries = new LinkedList<SerdesEntry>();
        String[] stringArray = serdesLines;
        int n = serdesLines.length;
        int n2 = 0;
        while (n2 < n) {
            String serdesLine = stringArray[n2];
            String[] serdesLinePieces = serdesLine.split(COMMA);
            if (serdesLinePieces.length != 3 && serdesLinePieces.length != 2) {
                return;
            }
            serdesEntries.add(new SerdesEntry(serdesLinePieces));
            ++n2;
        }
        root.visitDepthFirst(new ITagVisitor[]{new ITagVisitor(){

            public void visit(Tag tag) {
                if (tag == root) {
                    return;
                }
                String id = tag.getAttribute(DVTDialogSerdes.ID);
                if (id == null) {
                    return;
                }
                Widget widget = (Widget)tag.adaptTo(Widget.class);
                if (widget == null) {
                    return;
                }
                if (serdesEntries.isEmpty()) {
                    return;
                }
                SerdesEntry serdesElement = (SerdesEntry)serdesEntries.poll();
                if (!id.equals(serdesElement.id) || !widget.getClass().getSimpleName().equals(serdesElement.className)) {
                    return;
                }
                if (widget instanceof Button) {
                    ((Button)widget).setSelection(new Boolean(serdesElement.value).booleanValue());
                } else if (widget instanceof Text) {
                    ((Text)widget).setText(serdesElement.value);
                } else if (widget instanceof DVTWidget) {
                    ((DVTWidget)widget).setStringRepresentation(serdesElement.value);
                } else if (widget instanceof Combo) {
                    ((Combo)widget).setText(serdesElement.value);
                } else if (widget instanceof org.eclipse.swt.widgets.List) {
                    ((org.eclipse.swt.widgets.List)widget).setSelection((String[])SimpleTypes.STRING_ARRAY.convert(serdesElement.value));
                }
            }
        }});
    }

    @Override
    public void load(Tag root, File dialogFile) {
        if (this.fSerdesFile != null && this.fSerdesFile.exists()) {
            this.loadFromString(root, DVTFileUtils.getInstance().readFileContent(this.fSerdesFile));
        }
    }

    @Override
    public String getStringRepresentation(final Tag root) {
        if (root == null) {
            return "";
        }
        final StringBuilder sb = new StringBuilder();
        root.visitDepthFirst(new ITagVisitor[]{new ITagVisitor(){

            public void visit(Tag tag) {
                if (tag == root) {
                    return;
                }
                String id = tag.getAttribute(DVTDialogSerdes.ID);
                if (id == null) {
                    return;
                }
                Widget widget = (Widget)tag.adaptTo(Widget.class);
                if (widget == null) {
                    return;
                }
                String value = null;
                if (widget instanceof Button) {
                    value = Boolean.toString(((Button)widget).getSelection());
                } else if (widget instanceof Text) {
                    value = ((Text)widget).getText();
                } else if (widget instanceof DVTWidget) {
                    value = ((DVTWidget)widget).getStringRepresentation();
                } else if (widget instanceof Combo) {
                    value = ((Combo)widget).getText();
                } else if (widget instanceof org.eclipse.swt.widgets.List) {
                    value = DVTStringUtil.join(Arrays.asList(((org.eclipse.swt.widgets.List)widget).getSelection()), (String)";");
                } else if (widget instanceof Spinner) {
                    value = "" + ((Spinner)widget).getSelection();
                } else if (widget instanceof Slider) {
                    value = "" + ((Slider)widget).getSelection();
                }
                if (value == null) {
                    return;
                }
                sb.append(id).append(DVTDialogSerdes.COMMA).append(widget.getClass().getSimpleName()).append(DVTDialogSerdes.COMMA).append(value).append(NEWLINE);
            }
        }});
        return sb.toString();
    }

    @Override
    public void save(Tag root, String snapshotName, boolean defaultSnapshot) {
        if (this.fSerdesFile != null) {
            DVTFileUtils.getInstance().writeStringToFile(this.fSerdesFile, this.getStringRepresentation(root), false);
        }
    }

    @Override
    public void overwriteSnapshot(DVTSnapshot snapshot, String oldSnapshotName, String newSnapshotName, boolean defaultSnapshot, boolean updateLastSnapshot) {
    }

    @Override
    public boolean isSnapshotFileParsedCorectly() {
        return true;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public List<DVTSnapshot> getSnapshots(boolean printMessages) {
        return new ArrayList<DVTSnapshot>();
    }

    @Override
    public void appendNewSnapshot(Tag root, String snapshotName, boolean defaultSnapshot, boolean updateLastSnapshot) {
    }

    @Override
    public void updateLastRunSnapshot(StringBuilder sb, String snapshotName) {
    }

    @Override
    public void updateLastRunSnapshot(String snapshotName) {
    }

    @Override
    public void handleOk(Tag root, DVTSnapshot snapshot, DVTSnapshot defaultSnapshot) {
    }

    public DVTSnapshot getDVTSnapshotForBackwardCompatibility() {
        return this.fBackwardCompatibilitySnapshot;
    }

    public void makeDVTSnapshotForBackwardCompatibility(Tag root) {
        this.fBackwardCompatibilitySnapshot = DVTCustomDialogSnapshotUtils.getSnapshotFromRoot(root);
        this.fBackwardCompatibilitySnapshot.setIsTimestamp(true);
        String formattedTimestamp = new SimpleDateFormat(" [yyyy-MM-dd HH:mm:ss]").format(this.fSerdesFile.lastModified());
        this.fBackwardCompatibilitySnapshot.setName("default" + formattedTimestamp);
    }

    @Override
    public String getLastRunSnapshotName() {
        return this.fBackwardCompatibilitySnapshot.getName();
    }

    @Override
    public void remove(String snapshotName) {
    }

    @Override
    public void setSnapshotFileLocationType(DVTDialogSerdes2.SnapshotFileType snapshotFileSaveLocationType) {
    }

    @Override
    public DVTDialogSerdes2.SnapshotFileType getSnapshotFileLocationType() {
        return DVTDialogSerdes2.SnapshotFileType.LOCAL;
    }

    @Override
    public void setSnapshotFileLocation(String snapshotFileLocation) {
    }

    @Override
    public String getSnapshotFileLocation() {
        return null;
    }

    private static class SerdesEntry {
        String id;
        String className;
        String value;

        public SerdesEntry(String[] serdesLinePieces) {
            Assert.isTrue((serdesLinePieces.length == 3 || serdesLinePieces.length == 2 ? 1 : 0) != 0);
            this.id = serdesLinePieces[0];
            this.className = serdesLinePieces[1];
            this.value = serdesLinePieces.length == 3 ? serdesLinePieces[2] : "";
        }
    }
}

