/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.customdialog;

import com.swtxml.tinydom.Tag;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import ro.amiq.dvt.builders.DVTBuildConsoleRegistry;
import ro.amiq.dvt.customdialog.DVTCustomDialogConfirmDialog;
import ro.amiq.dvt.customdialog.DVTCustomDialogSnapshotUtils;
import ro.amiq.dvt.customdialog.IDVTDialogSerdes;
import ro.amiq.dvt.customdialog.core.DVTDialogElement;
import ro.amiq.dvt.customdialog.core.DVTDialogSnapshotXMLParser;
import ro.amiq.dvt.customdialog.core.DVTDialogSnapshots;
import ro.amiq.dvt.customdialog.core.DVTSnapshot;
import ro.amiq.dvt.settings.DVTSConstants;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTStringUtil;

public class DVTDialogSerdes2
implements IDVTDialogSerdes {
    private static final String CANNOT_ADD_SNAPSHOT_TITLE = "Cannot add snapshot";
    private static final String CANNOT_ADD_SNAPSHOT_MESSAGE_FORMAT = "Cannot add snapshot to {0} because the file seems to be corrupted";
    private static final String OVERWRITE_SNAPSHOT_PATTERN_FORMAT = "(?s)(<snapshot\\s+name=\\\"{0}\\\"(?:\\s+timestamp=\\\"\\w+\\\")?)(.*?>)(.*?)(</snapshot>?)";
    private static final String XML_HEADER_FORMAT = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\n <dialog-snapshots last-snapshot=\"{0}\" version=\"1\">\n</dialog-snapshots>";
    private static final String READ_ONLY_SNAPSHOT_TITLE = "Snapshot File is Read-Only";
    private static final String READ_ONLY_SNAPSHOT_MESSAGE_FORMAT = "Your snapshot file: \n{0} \nis read-only.\n\n";
    private static final String LAST_SNAPSHOT_PATTERN_STRING = "(?s)<dialog-snapshots.*?last-snapshot=\"(.*?)\"";
    private static final String CANNOT_LOAD_FORMAT = "Cannot load Custom Dialog snapshots from:\n\n    <a href=\"link\">{0}</a>\n\nThe file cannot be parsed because:\n\n    {1}\n\nIf you launch the run configuration, the snapshots file will be overwritten.\n\nDo you want to continue?";
    private static final String TAB = "    ";
    private File fSerdesFile;
    private Map<File, SnapshotFileType> fSerdesFiles;
    private IProject fProject;
    private String fSnapshotFileName;
    private String fLastRunSnapshotName = "";
    private SnapshotFileType fSnapshotSaveLocationType = SnapshotFileType.LOCAL;
    private boolean fIsSnapshotFileParsedCorectly = true;
    private boolean fCancelled;
    private Map<String, DVTSnapshot> fSnapshotsModel;
    private String fSnapshotSaveLocation;

    public DVTDialogSerdes2(String snapshotFileName, IProject project) {
        File userFile;
        this.fSerdesFiles = new LinkedHashMap<File, SnapshotFileType>();
        this.fProject = project;
        this.fSnapshotFileName = snapshotFileName;
        File dotDVTDir = null;
        if (project != null && project.getLocation() != null) {
            this.fSerdesFile = new File(project.getLocation().toFile(), ".dvt" + File.separator + this.fSnapshotFileName);
            dotDVTDir = new File(project.getLocation().toFile(), ".dvt");
        }
        if (DVTSConstants.DVT_COMMON_SETTINGS != null) {
            String[] stringArray = DVTSConstants.DVT_COMMON_SETTINGS;
            int n = DVTSConstants.DVT_COMMON_SETTINGS.length;
            int n2 = 0;
            while (n2 < n) {
                String path = stringArray[n2];
                File commonFile = new File(path, this.fSnapshotFileName);
                if (commonFile.exists()) {
                    this.fSerdesFiles.put(commonFile, SnapshotFileType.COMMON);
                }
                ++n2;
            }
        }
        if (DVTSConstants.DVT_USER_SETTINGS != null && (userFile = new File(DVTSConstants.DVT_USER_SETTINGS, this.fSnapshotFileName)).exists()) {
            this.fSerdesFiles.put(userFile, SnapshotFileType.USER);
        }
        this.fSnapshotSaveLocationType = dotDVTDir != null && dotDVTDir.exists() ? SnapshotFileType.LOCAL : SnapshotFileType.USER;
        this.fSerdesFiles.put(this.fSerdesFile, SnapshotFileType.LOCAL);
    }

    @Override
    public List<DVTSnapshot> getSnapshots(boolean printMessages) {
        this.fIsSnapshotFileParsedCorectly = true;
        this.fCancelled = false;
        this.fSnapshotsModel = new HashMap<String, DVTSnapshot>();
        for (Map.Entry<File, SnapshotFileType> entry : this.fSerdesFiles.entrySet()) {
            File file = entry.getKey();
            if (file == null || !file.exists()) continue;
            try {
                DVTDialogSnapshotXMLParser parser = DVTDialogSnapshotXMLParser.newParser(file, true);
                DVTDialogSnapshots dialogSnapshots = parser.load();
                this.addToModel(dialogSnapshots, entry.getValue());
                this.fLastRunSnapshotName = dialogSnapshots.getLastSnapshot();
                if (!printMessages || parser.getMessages().isEmpty()) continue;
                IFile iFile = this.getIFile(file);
                DVTCustomDialogConfirmDialog dialog = new DVTCustomDialogConfirmDialog(Utils.getActiveShell(), MessageFormat.format(CANNOT_LOAD_FORMAT, file.getPath(), parser.getMessages().get(0)), iFile);
                int result = dialog.open();
                this.fCancelled = result != 0;
                this.fIsSnapshotFileParsedCorectly = false;
                if (this.fProject == null) continue;
                for (String message : parser.getMessages()) {
                    DVTBuildConsoleRegistry.getConsole((IProject)this.fProject).print(message);
                }
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                this.fIsSnapshotFileParsedCorectly = false;
                if (!printMessages) continue;
                DVTCustomDialogConfirmDialog dialog = new DVTCustomDialogConfirmDialog(Utils.getActiveShell(), MessageFormat.format(CANNOT_LOAD_FORMAT, file.getPath(), e.getMessage()), this.getIFile(file));
                int result = dialog.open();
                this.fCancelled = result != 0;
            }
        }
        return new ArrayList<DVTSnapshot>(this.fSnapshotsModel.values());
    }

    private IFile getIFile(File file) {
        IFile[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(URIUtil.toURI((IPath)Path.fromOSString((String)file.getAbsolutePath())));
        IFile iFile = null;
        if (files != null && files.length > 0) {
            iFile = files[0];
        }
        return iFile;
    }

    private void addToModel(DVTDialogSnapshots dialogSnapshots, SnapshotFileType snapshotFileType) {
        for (DVTSnapshot snapshot : dialogSnapshots.getSnapshots()) {
            if (snapshotFileType != this.fSnapshotSaveLocationType && snapshot.isTimestamp()) continue;
            snapshot.setSnapshotFileType(snapshotFileType);
            this.fSnapshotsModel.put(snapshot.getName(), snapshot);
        }
    }

    @Override
    public void load(Tag root, File dialogFile) {
        if ((this.fSnapshotSaveLocationType == SnapshotFileType.LOCAL && this.fSerdesFile != null && this.fSerdesFile.exists() || this.fSnapshotSaveLocationType != SnapshotFileType.LOCAL) && this.fSnapshotsModel.containsKey(this.fLastRunSnapshotName)) {
            DVTCustomDialogSnapshotUtils.loadFromSnapshot(root, dialogFile, this.fSnapshotsModel.get(this.fLastRunSnapshotName));
        }
    }

    @Override
    public void save(Tag root, String snapshotName, boolean timestampSnapshot) {
        DVTSnapshot snapshot = DVTCustomDialogSnapshotUtils.getSnapshotFromRoot(root);
        File saveFile = this.getFileLocationFromSnapshotSaveLocationType(this.fSnapshotSaveLocationType);
        if (saveFile != null) {
            try {
                IFile snapshotFile;
                DVTDialogSnapshotXMLParser parser = DVTDialogSnapshotXMLParser.newParser(saveFile, true);
                snapshot.setName(snapshotName);
                snapshot.setIsTimestamp(timestampSnapshot);
                parser.save(snapshot, snapshotName);
                if (this.fSnapshotSaveLocationType != SnapshotFileType.LOCAL) {
                    this.fSerdesFiles.put(saveFile, this.fSnapshotSaveLocationType);
                }
                if ((snapshotFile = this.getIFile(saveFile)) != null) {
                    snapshotFile.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
                }
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
    }

    public void saveSnapshot(DVTSnapshot snapshot) {
        File saveFile = this.getFileLocationFromSnapshotSaveLocationType(this.fSnapshotSaveLocationType);
        if (saveFile != null) {
            try {
                DVTDialogSnapshotXMLParser parser = DVTDialogSnapshotXMLParser.newParser(saveFile, true);
                parser.save(snapshot, snapshot.getName());
                IFile snapshotFile = this.getIFile(saveFile);
                if (snapshotFile != null) {
                    snapshotFile.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
                }
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
    }

    private File getFileLocationFromSnapshotSaveLocationType(SnapshotFileType snapshotFileSaveLocationType) {
        File saveFile = this.fSerdesFile;
        if (snapshotFileSaveLocationType == null) {
            return saveFile;
        }
        switch (snapshotFileSaveLocationType) {
            case DEFINED: {
                if (this.fSnapshotSaveLocation == null) break;
                saveFile = new File(this.fSnapshotSaveLocation, this.fSnapshotFileName);
                break;
            }
            case LOCAL: {
                saveFile = this.fSerdesFile;
                break;
            }
            case USER: {
                if (DVTSConstants.DVT_USER_SETTINGS == null) break;
                saveFile = new File(DVTSConstants.DVT_USER_SETTINGS, this.fSnapshotFileName);
                break;
            }
            case COMMON: {
                if (DVTSConstants.DVT_COMMON_SETTINGS == null || DVTSConstants.DVT_COMMON_SETTINGS.length == 0) break;
                saveFile = new File(DVTSConstants.DVT_COMMON_SETTINGS[0], this.fSnapshotFileName);
                break;
            }
        }
        return saveFile;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void appendNewSnapshot(Tag root, String snapshotName, boolean timestampSnapshot, boolean updateLastSnapshot) {
        File saveFile = this.getFileLocationFromSnapshotSaveLocationType(this.fSnapshotSaveLocationType);
        if (saveFile != null && saveFile.exists()) {
            if (!saveFile.canWrite()) {
                MessageDialog.openWarning((Shell)Utils.getActiveShell(), (String)READ_ONLY_SNAPSHOT_TITLE, (String)(String.valueOf(MessageFormat.format(READ_ONLY_SNAPSHOT_MESSAGE_FORMAT, saveFile.getPath())) + "The " + snapshotName + " snapshot cannot be added"));
                return;
            }
            String snapshotContent = TAB + MessageFormat.format("<snapshot name=\"{0}\" timestamp=\"{1}\">\n", snapshotName, Boolean.toString(timestampSnapshot));
            for (DVTDialogElement element : DVTCustomDialogSnapshotUtils.getSnapshotFromRoot(root).getElements()) {
                String value = DVTCustomDialogSnapshotUtils.translateValue(element);
                snapshotContent = String.valueOf(snapshotContent) + "        " + MessageFormat.format("<element path=\"{0}\" value=\"{1}\"/>\n", element.getPath(), value);
            }
            snapshotContent = String.valueOf(snapshotContent) + "    </snapshot>\n";
            String currentContent = DVTFileUtils.getInstance().readFileContent(saveFile);
            StringBuilder sb = new StringBuilder(currentContent);
            int idxInsert = sb.indexOf("</dialog-snapshots>");
            if (idxInsert < 0) {
                MessageDialog.openError((Shell)Utils.getActiveShell(), (String)CANNOT_ADD_SNAPSHOT_TITLE, (String)MessageFormat.format(CANNOT_ADD_SNAPSHOT_MESSAGE_FORMAT, saveFile.getPath()));
                return;
            }
            sb.insert(idxInsert, snapshotContent);
            if (updateLastSnapshot) {
                this.updateLastRunSnapshot(sb, snapshotName);
            }
            try {
                if (saveFile.equals(this.fSerdesFile)) {
                    IFile snapshotFile = this.fProject.getFile(".dvt" + File.separator + this.fSnapshotFileName);
                    snapshotFile.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
                    snapshotFile.setContents((InputStream)new ByteArrayInputStream(sb.toString().getBytes(StandardCharsets.UTF_8)), 3, null);
                    return;
                }
                Throwable snapshotFile = null;
                Object var11_15 = null;
                try {
                    BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(saveFile));
                    try {
                        try (BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(os));){
                            bw.write(sb.toString());
                        }
                        if (os == null) return;
                    }
                    catch (Throwable throwable) {
                        if (snapshotFile == null) {
                            snapshotFile = throwable;
                        } else if (snapshotFile != throwable) {
                            snapshotFile.addSuppressed(throwable);
                        }
                        if (os == null) throw snapshotFile;
                        ((OutputStream)os).close();
                        throw snapshotFile;
                    }
                    ((OutputStream)os).close();
                    return;
                }
                catch (Throwable throwable) {
                    if (snapshotFile == null) {
                        snapshotFile = throwable;
                        throw snapshotFile;
                    } else {
                        if (snapshotFile == throwable) throw snapshotFile;
                        snapshotFile.addSuppressed(throwable);
                    }
                    throw snapshotFile;
                }
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
            return;
        }
        this.save(root, snapshotName, updateLastSnapshot);
        if (updateLastSnapshot) return;
        this.updateLastRunSnapshot("default");
    }

    @Override
    public void overwriteSnapshot(DVTSnapshot snapshot, String oldSnapshotName, String newSnapshotName, boolean timestampSnapshot, boolean updateLastSnapshot) {
        String snapshotContent = MessageFormat.format("<snapshot name=\"{0}\" timestamp=\"{1}\">\n", newSnapshotName, Boolean.toString(timestampSnapshot));
        for (DVTDialogElement element : snapshot.getElements()) {
            String value = DVTCustomDialogSnapshotUtils.translateValue(element);
            snapshotContent = String.valueOf(snapshotContent) + "        " + MessageFormat.format("<element path=\"{0}\" value=\"{1}\"/>\n", element.getPath(), value);
        }
        snapshotContent = String.valueOf(snapshotContent) + "    </snapshot>";
        this.overwriteSnapshot(oldSnapshotName, snapshotContent);
        if (updateLastSnapshot) {
            this.updateLastRunSnapshot(newSnapshotName);
        }
    }

    @Override
    public void updateLastRunSnapshot(StringBuilder sb, String snapshotName) {
        String patternString = LAST_SNAPSHOT_PATTERN_STRING;
        Pattern pattern = Pattern.compile(patternString);
        Matcher matcher = pattern.matcher(sb.toString());
        if (matcher.find()) {
            sb.replace(matcher.start(1), matcher.end(1), snapshotName);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void updateLastRunSnapshot(String snapshotName) {
        File saveFile = this.getFileLocationFromSnapshotSaveLocationType(this.fSnapshotSaveLocationType);
        try {
            StringBuilder sb = new StringBuilder();
            if (!(this.fSerdesFile != null && this.fSerdesFile.exists() || this.fSnapshotSaveLocationType != SnapshotFileType.LOCAL)) {
                sb.append(MessageFormat.format(XML_HEADER_FORMAT, snapshotName));
            } else {
                sb = new StringBuilder(DVTFileUtils.getInstance().readFileContent(saveFile));
                String patternString = LAST_SNAPSHOT_PATTERN_STRING;
                Pattern pattern = Pattern.compile(patternString);
                Matcher matcher = pattern.matcher(sb.toString());
                if (matcher.find()) {
                    sb.replace(matcher.start(1), matcher.end(1), snapshotName);
                }
            }
            if (this.fSnapshotSaveLocationType == SnapshotFileType.LOCAL) {
                IFile snapshotFile = this.fProject.getFile(".dvt" + File.separator + this.fSnapshotFileName);
                if (!snapshotFile.exists()) {
                    snapshotFile.create((InputStream)new ByteArrayInputStream(sb.toString().getBytes(StandardCharsets.UTF_8)), 3, null);
                    return;
                } else {
                    snapshotFile.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
                    snapshotFile.setContents((InputStream)new ByteArrayInputStream(sb.toString().getBytes(StandardCharsets.UTF_8)), 3, null);
                }
                return;
            }
            Throwable throwable = null;
            Object var5_7 = null;
            try {
                BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(saveFile));
                try {
                    try (BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(os));){
                        bw.write(sb.toString());
                    }
                    if (os == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (os == null) throw throwable;
                    ((OutputStream)os).close();
                    throw throwable;
                }
                ((OutputStream)os).close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    @Override
    public String getLastRunSnapshotName() {
        return this.fLastRunSnapshotName;
    }

    @Override
    public boolean isSnapshotFileParsedCorectly() {
        return this.fIsSnapshotFileParsedCorectly;
    }

    @Override
    public void loadFromString(Tag root, String stringRepresentation) {
    }

    @Override
    public String getStringRepresentation(Tag root) {
        return null;
    }

    @Override
    public boolean isCancelled() {
        return this.fCancelled;
    }

    @Override
    public void handleOk(Tag root, DVTSnapshot snapshot, DVTSnapshot defaultSnapshot) {
        if (this.fSerdesFile != null && this.fSerdesFile.exists() && !this.fSerdesFile.canWrite()) {
            MessageDialog.openWarning((Shell)Utils.getActiveShell(), (String)READ_ONLY_SNAPSHOT_TITLE, (String)(String.valueOf(MessageFormat.format(READ_ONLY_SNAPSHOT_MESSAGE_FORMAT, this.fSerdesFile.getPath())) + "The last runned snapshot cannot be updated"));
            return;
        }
        String userDefinedSnapshotName = snapshot.getName();
        if (snapshot.isTimestamp()) {
            ArrayList<DVTSnapshot> snapshots = new ArrayList<DVTSnapshot>(this.fSnapshotsModel.values());
            snapshots.add(defaultSnapshot);
            userDefinedSnapshotName = DVTCustomDialogSnapshotUtils.getUserDefinedSnapshotName(snapshot.getName(), snapshots);
        }
        boolean found = false;
        String newTimestampSnapshotName = String.valueOf(userDefinedSnapshotName) + DVTCustomDialogSnapshotUtils.getDateFormat().format(new Date());
        if (this.fSnapshotsModel != null) {
            for (DVTSnapshot snp : this.fSnapshotsModel.values()) {
                if (!DVTCustomDialogSnapshotUtils.isTimestampSnapshotNameFor(userDefinedSnapshotName, snp.getName()) || snp.isReadOnly()) continue;
                this.overwriteSnapshot(DVTCustomDialogSnapshotUtils.getSnapshotFromRoot(root), snp.getName(), newTimestampSnapshotName, true, true);
                found = true;
                break;
            }
        }
        if (!found) {
            this.appendNewSnapshot(root, newTimestampSnapshotName, true, true);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void overwriteSnapshot(String snapshotName, String snapshotContent) {
        File file = new File(this.fSnapshotsModel.get(snapshotName).getFilePath());
        String currentContent = DVTFileUtils.getInstance().readFileContent(file);
        String patternString = MessageFormat.format(OVERWRITE_SNAPSHOT_PATTERN_FORMAT, Pattern.quote(snapshotName));
        Pattern pattern = Pattern.compile(String.valueOf(snapshotContent == null || snapshotContent.isEmpty() ? "\\s*" : "") + patternString);
        Matcher matcher = pattern.matcher(currentContent);
        if (!matcher.find()) return;
        StringBuilder sb = new StringBuilder(currentContent);
        sb.replace(matcher.start(), matcher.end(4), snapshotContent);
        try {
            if (this.fSnapshotSaveLocationType == SnapshotFileType.LOCAL) {
                IFile snapshotFile = this.fProject.getFile(".dvt" + File.separator + this.fSnapshotFileName);
                snapshotFile.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
                snapshotFile.setContents((InputStream)new ByteArrayInputStream(sb.toString().getBytes(StandardCharsets.UTF_8)), 3, null);
                return;
            }
            Throwable throwable = null;
            Object var11_13 = null;
            try {
                BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(this.getFileLocationFromSnapshotSaveLocationType(this.fSnapshotSaveLocationType)));
                try {
                    try (BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(os));){
                        bw.write(sb.toString());
                    }
                    if (os == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (os == null) throw throwable;
                    ((OutputStream)os).close();
                    throw throwable;
                }
                ((OutputStream)os).close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    @Override
    public void remove(String snapshotName) {
        this.overwriteSnapshot(snapshotName, "");
    }

    @Override
    public void setSnapshotFileLocationType(SnapshotFileType snapshotFileSaveLocationType) {
        this.fSnapshotSaveLocationType = snapshotFileSaveLocationType;
    }

    @Override
    public SnapshotFileType getSnapshotFileLocationType() {
        return this.fSnapshotSaveLocationType;
    }

    @Override
    public void setSnapshotFileLocation(String snapshotFileLocation) {
        this.fSnapshotSaveLocation = snapshotFileLocation;
        this.fSerdesFiles.put(new File(String.valueOf(snapshotFileLocation) + File.separator + this.fSnapshotFileName), SnapshotFileType.DEFINED);
    }

    @Override
    public String getSnapshotFileLocation() {
        return this.fSnapshotSaveLocation;
    }

    public static enum SnapshotFileType {
        DEFINED,
        LOCAL,
        USER,
        COMMON;


        public static SnapshotFileType from(String n) {
            if (n == null) {
                return null;
            }
            SnapshotFileType[] snapshotFileTypeArray = SnapshotFileType.values();
            int n2 = snapshotFileTypeArray.length;
            int n3 = 0;
            while (n3 < n2) {
                SnapshotFileType result = snapshotFileTypeArray[n3];
                if (result.toString().equalsIgnoreCase(n.trim())) {
                    return result;
                }
                ++n3;
            }
            return null;
        }

        public static String valuesList() {
            return DVTStringUtil.join(Arrays.asList(SnapshotFileType.values()), (String)",");
        }
    }
}

