/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.customdialog;

import com.swtxml.tinydom.ITagVisitor;
import com.swtxml.tinydom.Tag;
import java.util.Arrays;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import ro.amiq.dvt.customdialog.IDVTResultBuilder;
import ro.amiq.dvt.customdialog.widgets.Container;
import ro.amiq.dvt.customdialog.widgets.DVTWidget;
import ro.amiq.dvt.customdialog.widgets.RaAdditionalArgsText;
import ro.amiq.dvt.customdialog.widgets.RaRunModeCheckBox;
import ro.amiq.dvt.customdialog.widgets.RaWaveViewerArgumentsGroup;
import ro.amiq.dvt.utils.DVTStringUtil;

public class DVTResultBuilder
implements IDVTResultBuilder {
    private static final String ID = "id";
    private StringBuilder fResult;
    private StringBuilder fTitleContribution;

    @Override
    public void computeResult(final Tag root) {
        this.fResult = new StringBuilder();
        this.fTitleContribution = new StringBuilder();
        root.visitDepthFirst(new ITagVisitor[]{new ITagVisitor(){

            public void visit(Tag tag) {
                if (tag == root) {
                    return;
                }
                String name = tag.getAttribute(DVTResultBuilder.ID);
                if (name == null) {
                    return;
                }
                Widget widget = (Widget)tag.adaptTo(Widget.class);
                if (widget instanceof Control && !((Control)widget).isEnabled()) {
                    return;
                }
                String value = "";
                if (widget instanceof Button) {
                    boolean selection = ((Button)widget).getSelection();
                    String checkboxOnValue = Container.getStringParameter(tag, "checkboxOnValue");
                    String checkboxOffValue = Container.getStringParameter(tag, "checkboxOffValue");
                    if (checkboxOnValue != null || checkboxOffValue != null) {
                        name = "";
                        value = selection ? (checkboxOnValue == null ? "" : checkboxOnValue) : (checkboxOffValue == null ? "" : checkboxOffValue);
                    } else if (!selection) {
                        name = "";
                    }
                } else if (widget instanceof Text) {
                    value = ((Text)widget).getText();
                } else if (widget instanceof DVTWidget) {
                    value = ((DVTWidget)widget).getValue();
                } else if (widget instanceof Combo) {
                    value = ((Combo)widget).getText();
                } else if (widget instanceof List) {
                    value = DVTStringUtil.join(Arrays.asList(((List)widget).getSelection()), (String)Container.getStringParameter(tag, "listSeparator"));
                } else if (widget instanceof Spinner) {
                    value = "" + ((Spinner)widget).getSelection();
                } else if (widget instanceof Slider) {
                    value = "" + ((Slider)widget).getSelection();
                }
                if (value == null) {
                    value = "";
                }
                if (value.length() != 0 && Container.getStringParameter(tag, "quoteWith") != null) {
                    value = String.valueOf(Container.getStringParameter(tag, "quoteWith")) + value + Container.getStringParameter(tag, "quoteWith");
                }
                if (value.trim().length() == 0 && Container.getBooleanParameter(tag, "noIdForEmptyValues").booleanValue()) {
                    return;
                }
                if (widget instanceof RaAdditionalArgsText) {
                    DVTResultBuilder.this.fResult.append(" ").append(name).append("=").append(" ").append(value);
                } else if (widget instanceof RaWaveViewerArgumentsGroup || widget instanceof RaRunModeCheckBox) {
                    DVTResultBuilder.this.fResult.append(" ").append(value);
                } else {
                    DVTResultBuilder.this.fResult.append(name).append(value);
                }
                if (Container.getBooleanParameter(tag, "showInTitle").booleanValue()) {
                    DVTResultBuilder.this.fTitleContribution.append(name).append(value);
                }
            }
        }});
    }

    @Override
    public String getResult() {
        return this.fResult.toString();
    }

    @Override
    public String getTitleContribution() {
        return this.fTitleContribution.toString();
    }
}

