/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.customdialog;

import java.util.Arrays;
import java.util.Map;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.utils.DVTColorUtil;

public class DVTSnapshotSaveAsDialog
extends Dialog {
    private String title = "Save snapsot as...";
    private String message;
    private String value = "";
    private IInputValidator validator;
    private Text errorMessageText;
    private String errorMessage;
    private Map<String, Boolean> fSnapshotReadOnlyMap;
    private Combo fSnapshotCombo;

    public DVTSnapshotSaveAsDialog(Shell parentShell, String defaultName, Map<String, Boolean> snapshotReadOnlyMap) {
        super(parentShell);
        this.message = "Save " + defaultName + " under new name:";
        this.fSnapshotReadOnlyMap = snapshotReadOnlyMap;
        this.value = defaultName;
        this.validator = new IInputValidator(){

            public String isValid(String newText) {
                if (newText == null || newText.isEmpty()) {
                    return "Please fill in a snapshot name.";
                }
                if (DVTSnapshotSaveAsDialog.this.fSnapshotReadOnlyMap.get(DVTSnapshotSaveAsDialog.this.value) != null && DVTSnapshotSaveAsDialog.this.fSnapshotReadOnlyMap.get(DVTSnapshotSaveAsDialog.this.value).booleanValue()) {
                    return "The selected snapshot is read-only.";
                }
                if (DVTSnapshotSaveAsDialog.this.value.equals("default")) {
                    return "Cannot overwrite default snapshot.";
                }
                return null;
            }
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.value = this.fSnapshotCombo.getText();
            if (this.fSnapshotReadOnlyMap.keySet().contains(this.value)) {
                boolean confirm = MessageDialog.openConfirm((Shell)Utils.getActiveShell(), (String)"Overwrite Snapshot", (String)("Are you sure you want to overwrite the existing " + this.value + " snapshot?"));
                if (!confirm) return;
                super.okPressed();
            }
        } else {
            this.value = null;
        }
        super.buttonPressed(buttonId);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.fSnapshotCombo.setFocus();
        if (this.value != null) {
            this.fSnapshotCombo.setItems(this.fSnapshotReadOnlyMap.keySet().toArray(new String[this.fSnapshotReadOnlyMap.keySet().size()]));
            this.fSnapshotCombo.setText(this.value);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        if (this.message != null) {
            Label label = new Label(composite, 64);
            label.setText(this.message);
            GridData data = new GridData(1796);
            data.widthHint = this.convertHorizontalDLUsToPixels(300);
            label.setLayoutData((Object)data);
            label.setFont(parent.getFont());
        }
        this.fSnapshotCombo = new Combo(parent, 0);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 0x1000008).applyTo((Control)this.fSnapshotCombo);
        Object[] snapshotNames = this.fSnapshotReadOnlyMap.keySet().toArray(new String[this.fSnapshotReadOnlyMap.keySet().size()]);
        Arrays.sort(snapshotNames);
        this.fSnapshotCombo.setItems((String[])snapshotNames);
        this.fSnapshotCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DVTSnapshotSaveAsDialog.this.value = DVTSnapshotSaveAsDialog.this.fSnapshotCombo.getText();
                DVTSnapshotSaveAsDialog.this.validateInput();
            }
        });
        this.fSnapshotCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DVTSnapshotSaveAsDialog.this.value = DVTSnapshotSaveAsDialog.this.fSnapshotCombo.getText();
                DVTSnapshotSaveAsDialog.this.validateInput();
            }
        });
        this.errorMessageText = new Text(composite, 2120);
        this.errorMessageText.setLayoutData((Object)new GridData(768));
        DVTColorUtil.INSTANCE.setBackground((Control)this.errorMessageText, DVTColorUtil.INSTANCE.getBackground((Control)this.errorMessageText.getParent()), true);
        this.setErrorMessage(this.errorMessage);
        DVTSnapshotSaveAsDialog.applyDialogFont((Control)composite);
        return composite;
    }

    public String getValue() {
        return this.value;
    }

    protected void validateInput() {
        String errorMessage = null;
        if (this.validator != null) {
            errorMessage = this.validator.isValid(this.fSnapshotCombo.getText());
        }
        this.setErrorMessage(errorMessage);
        this.getButton(0).setEnabled(errorMessage == null);
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        if (this.errorMessageText != null && !this.errorMessageText.isDisposed()) {
            this.errorMessageText.setText(errorMessage == null ? " \n " : errorMessage);
            boolean hasError = errorMessage != null && StringConverter.removeWhiteSpaces((String)errorMessage).length() > 0;
            this.errorMessageText.setEnabled(hasError);
            this.errorMessageText.setVisible(hasError);
            DVTColorUtil.INSTANCE.setBackground((Control)this.errorMessageText, hasError ? DVTUiUtils.COLOR_RED : DVTColorUtil.INSTANCE.getBackground((Control)this.errorMessageText.getParent()));
            DVTColorUtil.INSTANCE.setForeground((Control)this.errorMessageText, hasError ? DVTUiUtils.COLOR_BLACK : DVTColorUtil.INSTANCE.getDefaultForeground((Control)this.errorMessageText));
            this.errorMessageText.getParent().update();
            Button button = this.getButton(0);
            if (button != null) {
                button.setEnabled(errorMessage == null);
            }
        }
    }

    public String getResult() {
        return this.value;
    }
}

