/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.customdialog.core;

import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.IDynamicVariable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.customdialog.DVTCustomDialog;
import ro.amiq.dvt.externaltools.DVTProjectEnhancedDynamicVariableResolver;
import ro.amiq.dvt.externaltools.IAccumulatingValueReturningVariableResolver;

public class DVTCustomDialogVariableResolver
extends DVTProjectEnhancedDynamicVariableResolver
implements IAccumulatingValueReturningVariableResolver {
    private static final String NON_BLOCKING = "non-blocking:";

    public String resolveValue(IDynamicVariable variable, String argument) throws CoreException {
        final boolean nonBlocking = argument.startsWith(NON_BLOCKING);
        if (nonBlocking) {
            argument = argument.substring(NON_BLOCKING.length());
        }
        String customSnapshotsDirString = null;
        int indexOfPathSeparator = argument.indexOf(File.pathSeparator);
        if (indexOfPathSeparator != -1) {
            customSnapshotsDirString = argument.substring(indexOfPathSeparator + 1);
            argument = argument.substring(0, indexOfPathSeparator);
        }
        final File[] dialogDescriptor = new File[]{new File(argument)};
        final String[] result = new String[1];
        IProject project = this.getProject();
        String configLoc = this.getConfigLocation();
        if (!dialogDescriptor[0].exists() && configLoc != null) {
            dialogDescriptor[0] = new File(new File(configLoc).getParentFile(), argument);
        }
        if (!dialogDescriptor[0].exists() && project != null) {
            dialogDescriptor[0] = new File(project.getLocation().toFile(), argument);
        }
        if (!dialogDescriptor[0].exists()) {
            throw new CoreException((IStatus)new Status(4, "ro.amiq.dvt.customdialog", "Could not locate DVT Custom Dialog descriptor file '" + argument + "'." + "The file must be provided either as relative to project root," + "to the Run Configuration .launch file or " + "as an absolute path."));
        }
        final File[] customSnapshotsDir = new File[1];
        if (customSnapshotsDirString != null) {
            customSnapshotsDir[0] = new File(customSnapshotsDirString);
            if (!customSnapshotsDir[0].exists() && configLoc != null) {
                customSnapshotsDir[0] = new File(new File(configLoc).getParentFile(), customSnapshotsDirString);
            }
            if (!customSnapshotsDir[0].exists() && project != null) {
                customSnapshotsDir[0] = new File(project.getLocation().toFile(), customSnapshotsDirString);
            }
            if (!customSnapshotsDir[0].exists()) {
                throw new CoreException((IStatus)new Status(4, "ro.amiq.dvt.customdialog", "Could not locate DVT Custom Dialog snapshots directory '" + customSnapshotsDirString + "'." + "The file must be provided either as relative to project root," + "to the Run Configuration .launch file or " + "as an absolute path."));
            }
        }
        final IProject finalProject = project;
        final Exception[] exc = new Exception[1];
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    DVTCustomDialog dialog = new DVTCustomDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), dialogDescriptor[0], finalProject, true);
                    dialog.setNonBlocking(nonBlocking);
                    if (customSnapshotsDir.length > 0 && customSnapshotsDir[0] != null) {
                        dialog.setSnapshotFileLocation(customSnapshotsDir[0].getAbsolutePath());
                    }
                    dialog.open();
                    if (dialog.getReturnCode() == 1) {
                        throw new DebugException((IStatus)new Status(8, "ro.amiq.dvt", 8, "Failed to expand Custom Dialog. Input was canceled", null));
                    }
                    result[0] = dialog.getResult();
                    IAccumulatingValueReturningVariableResolver.AccumulatingValueReturningVariableResolverRepo.accumulate((String)"ro.amiq.dvt.DVTCustomDialog.titleContribution", (String)dialog.getTitleContribution());
                }
                catch (Exception e) {
                    exc[0] = e;
                }
            }
        });
        if (exc[0] instanceof DebugException) {
            throw (DebugException)exc[0];
        }
        if (exc[0] != null) {
            throw new CoreException((IStatus)new Status(4, "ro.amiq.dvt.customdialog", "Unable to create Custom DVT Run Dialog due to:\n\n" + exc[0].getMessage(), (Throwable)exc[0]));
        }
        return result[0];
    }
}

