/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.customdialog.core;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import ro.amiq.dvt.customdialog.core.DVTDialogSnapshotXMLParser1;
import ro.amiq.dvt.customdialog.core.DVTDialogSnapshots;
import ro.amiq.dvt.customdialog.core.DVTSnapshot;
import ro.amiq.dvt.utils.XMLErrorHandler;

public abstract class DVTDialogSnapshotXMLParser {
    protected static final String TAG_DIALOG_SNAPSHOTS = "dialog-snapshots";
    private static final String LAST_VERSION = "1";
    private final File file;
    protected List<String> messages = new ArrayList<String>();

    protected DVTDialogSnapshotXMLParser(File file) {
        this.file = file;
    }

    public abstract void save(DVTSnapshot var1, String var2) throws Exception;

    public abstract DVTDialogSnapshots load() throws Exception;

    public abstract DVTSnapshot loadFromString(String var1) throws Exception;

    public File getFile() {
        return this.file;
    }

    public static DVTDialogSnapshotXMLParser newParser(File file, boolean useLastVersion) throws Exception {
        if (useLastVersion) {
            return DVTDialogSnapshotXMLParser.newParser(file, LAST_VERSION);
        }
        String version = DVTDialogSnapshotXMLParser.detectVersion(file);
        return DVTDialogSnapshotXMLParser.newParser(file, version);
    }

    private static DVTDialogSnapshotXMLParser newParser(File file, String version) throws Exception {
        if (LAST_VERSION.equals(version)) {
            return new DVTDialogSnapshotXMLParser1(file);
        }
        throw new IllegalArgumentException("Unknown custom dialog snapshot file version " + version + ".");
    }

    private static String detectVersion(File file) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setErrorHandler((ErrorHandler)XMLErrorHandler.INSTANCE);
        Document document = builder.parse(file);
        NodeList snapshotsNodes = document.getElementsByTagName(TAG_DIALOG_SNAPSHOTS);
        if (snapshotsNodes.getLength() < 1) {
            return null;
        }
        Element waiversNode = (Element)snapshotsNodes.item(0);
        return waiversNode.getAttribute("version");
    }

    public List<String> getMessages() {
        return this.messages;
    }
}

