/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.customdialog.core;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.StringReader;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import ro.amiq.dvt.customdialog.core.DVTDialogElement;
import ro.amiq.dvt.customdialog.core.DVTDialogSnapshotXMLParser;
import ro.amiq.dvt.customdialog.core.DVTDialogSnapshots;
import ro.amiq.dvt.customdialog.core.DVTSnapshot;
import ro.amiq.dvt.utils.XMLErrorHandler;

public class DVTDialogSnapshotXMLParser1
extends DVTDialogSnapshotXMLParser {
    public static final String VERSION_ID = "1";
    private static final String ATTR_VERSION = "version";
    private static final String ATTR_LAST_SNAPSHOT = "last-snapshot";
    private static final String TAG_SNAPSHOT = "snapshot";
    private static final String ATTR_TIMESTAMP = "timestamp";
    private static final String ATTR_NAME = "name";
    private static final String TAG_ELEMENT = "element";
    private static final String ATTR_PATH = "path";
    private static final String ATTR_VALUE = "value";

    public DVTDialogSnapshotXMLParser1(File file) {
        super(file);
    }

    @Override
    public void save(DVTSnapshot snapshot, String lastSnapshotName) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.newDocument();
        Element elem = document.createElement("dialog-snapshots");
        document.appendChild(elem);
        elem.setAttribute(ATTR_VERSION, VERSION_ID);
        elem.setAttribute(ATTR_LAST_SNAPSHOT, lastSnapshotName);
        if (snapshot != null) {
            this.appendSnapshotNode(snapshot, elem, document);
        }
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        Throwable throwable = null;
        Object var9_10 = null;
        try (BufferedWriter output = new BufferedWriter(new FileWriter(this.getFile()));){
            StreamResult result = new StreamResult(output);
            DOMSource source = new DOMSource(document);
            transformer.transform(source, result);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void appendSnapshotNode(DVTSnapshot snapshot, Element root, Document document) {
        Element snapshotElement = document.createElement(TAG_SNAPSHOT);
        root.appendChild(snapshotElement);
        snapshotElement.setAttribute(ATTR_NAME, snapshot.getName());
        snapshotElement.setAttribute(ATTR_TIMESTAMP, String.valueOf(snapshot.isTimestamp()));
        if (snapshot.getElements() != null) {
            for (DVTDialogElement element : snapshot.getElements()) {
                this.appendElementNode(element, snapshotElement, document);
            }
        }
    }

    private void appendElementNode(DVTDialogElement element, Element root, Document document) {
        Element elem = document.createElement(TAG_ELEMENT);
        root.appendChild(elem);
        elem.setAttribute(ATTR_PATH, element.getPath());
        elem.setAttribute(ATTR_VALUE, element.getValue());
    }

    @Override
    public DVTSnapshot loadFromString(String xmlString) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setErrorHandler((ErrorHandler)XMLErrorHandler.INSTANCE);
        InputSource is = new InputSource(new StringReader(xmlString));
        Document document = builder.parse(is);
        NodeList snapshotNodes = document.getElementsByTagName(TAG_SNAPSHOT);
        if (snapshotNodes.getLength() < 1) {
            return null;
        }
        DVTSnapshot snapshot = new DVTSnapshot();
        Element snapshotNode = (Element)snapshotNodes.item(0);
        String snapshotName = snapshotNode.getAttribute(ATTR_NAME);
        if (snapshotName == null || snapshotName.isEmpty()) {
            this.reportNoNameForSnapshot();
            return null;
        }
        snapshot.setName(snapshotName);
        String isTimestamp = snapshotNode.getAttribute(ATTR_TIMESTAMP);
        if (isTimestamp == null || isTimestamp.isEmpty() || isTimestamp.equalsIgnoreCase("false")) {
            snapshot.setIsTimestamp(false);
        } else if (isTimestamp.equalsIgnoreCase("true")) {
            snapshot.setIsTimestamp(true);
        } else {
            this.reportUnknownUserDefined(snapshotName, isTimestamp);
            return null;
        }
        NodeList elementNodes = snapshotNode.getElementsByTagName(TAG_ELEMENT);
        int j = 0;
        while (j < elementNodes.getLength()) {
            DVTDialogElement element = new DVTDialogElement();
            Element elementNode = (Element)elementNodes.item(j);
            if (elementNode.hasAttribute(ATTR_PATH)) {
                String path = elementNode.getAttribute(ATTR_PATH);
                element.setPath(path);
            }
            if (elementNode.hasAttribute(ATTR_VALUE)) {
                String value = elementNode.getAttribute(ATTR_VALUE);
                element.setValue(value);
            }
            snapshot.addElement(element);
            ++j;
        }
        return snapshot;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public DVTDialogSnapshots load() throws Exception {
        this.messages.clear();
        factory = DocumentBuilderFactory.newInstance();
        factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        builder = factory.newDocumentBuilder();
        builder.setErrorHandler((ErrorHandler)XMLErrorHandler.INSTANCE);
        document = builder.parse(this.getFile());
        dialogSnapshotsNodes = document.getElementsByTagName("dialog-snapshots");
        filePath = this.getFile().getAbsolutePath();
        if (dialogSnapshotsNodes.getLength() == 0) {
            this.reportNoDialogSnapshots(filePath);
        }
        dialogSnapshots = new DVTDialogSnapshots();
        readOnly = this.getFile().canWrite() == false;
        dialogSnapshotsNode = (Element)dialogSnapshotsNodes.item(0);
        lastSnapshot = dialogSnapshotsNode.getAttribute("last-snapshot");
        dialogSnapshots.setLastSnapshot(lastSnapshot == null ? "" : lastSnapshot);
        snapshotNodes = dialogSnapshotsNode.getElementsByTagName("snapshot");
        snapshots = new ArrayList<DVTSnapshot>();
        i = 0;
        while (i < snapshotNodes.getLength()) {
            block8: {
                block9: {
                    block7: {
                        snapshot = new DVTSnapshot();
                        snapshotNode = (Element)snapshotNodes.item(i);
                        snapshotName = snapshotNode.getAttribute("name");
                        if (snapshotName != null && !snapshotName.isEmpty()) break block7;
                        this.reportNoNameForSnapshot();
                        break block8;
                    }
                    snapshot.setName(snapshotName);
                    isTimestamp = snapshotNode.getAttribute("timestamp");
                    if (isTimestamp != null && !isTimestamp.isEmpty() && !isTimestamp.equalsIgnoreCase("false")) break block9;
                    snapshot.setIsTimestamp(false);
                    ** GOTO lbl37
                }
                if (!isTimestamp.equalsIgnoreCase("true")) {
                    this.reportUnknownUserDefined(snapshotName, isTimestamp);
                } else {
                    snapshot.setIsTimestamp(true);
lbl37:
                    // 2 sources

                    elementNodes = snapshotNode.getElementsByTagName("element");
                    j = 0;
                    while (j < elementNodes.getLength()) {
                        element = new DVTDialogElement();
                        elementNode = (Element)elementNodes.item(j);
                        if (elementNode.hasAttribute("path")) {
                            path = elementNode.getAttribute("path");
                            element.setPath(path);
                        }
                        if (elementNode.hasAttribute("value")) {
                            value = elementNode.getAttribute("value");
                            element.setValue(value);
                        }
                        snapshot.addElement(element);
                        ++j;
                    }
                    snapshot.setFilePath(filePath);
                    snapshot.setReadOnly(readOnly);
                    snapshots.add(snapshot);
                }
            }
            ++i;
        }
        dialogSnapshots.setSnapshots(snapshots);
        return dialogSnapshots;
    }

    private void reportNoDialogSnapshots(String fileName) {
        this.reportProblem("There is no dialog-snapshots tag in the following file: " + fileName);
    }

    private void reportUnknownUserDefined(String snapshotName, String value) {
        this.reportProblem("Snapshot '" + snapshotName + "' has an unknown user-defined attribute: " + value + "; valid values are: true / false");
    }

    private void reportNoNameForSnapshot() {
        this.reportProblem("The Custom Dialog Snapshots File contains an snapshot tag without a name attribute");
    }

    public void reportProblem(String message) {
        this.messages.add("Skipping snapshot from '" + this.getFile().getAbsolutePath() + "': " + message);
    }
}

