/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.customdialog.core;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import ro.amiq.dvt.customdialog.DVTCustomDialogSnapshotUtils;
import ro.amiq.dvt.customdialog.DVTDialogSerdes2;
import ro.amiq.dvt.customdialog.core.DVTDialogElement;

public class DVTSnapshot {
    private ArrayList<DVTDialogElement> elements = new ArrayList();
    private String name;
    private boolean timestamp;
    private boolean readOnly;
    private DVTDialogSerdes2.SnapshotFileType snapshotFileType;
    private String filePath;
    private File dialogFile;

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean isReadOnly) {
        this.readOnly = isReadOnly;
    }

    public DVTDialogSerdes2.SnapshotFileType getSnapshotFileType() {
        return this.snapshotFileType;
    }

    public void setSnapshotFileType(DVTDialogSerdes2.SnapshotFileType snapshotFileType) {
        this.snapshotFileType = snapshotFileType;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public List<DVTDialogElement> getElements() {
        return this.elements;
    }

    public void addElement(DVTDialogElement element) {
        this.elements.add(element);
    }

    public boolean isTimestamp() {
        return this.timestamp;
    }

    public void setIsTimestamp(boolean isUserDefined) {
        this.timestamp = isUserDefined;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DVTSnapshot)) {
            return false;
        }
        DVTSnapshot snapshot = (DVTSnapshot)obj;
        if (snapshot.getElements().size() != this.elements.size()) {
            return false;
        }
        int i = 0;
        while (i < this.elements.size()) {
            if (!snapshot.getElements().get(i).getValue().equals(this.elements.get(i).getValue())) {
                return false;
            }
            if (!snapshot.getElements().get(i).getPath().equals(this.elements.get(i).getPath())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.dialogFile == null ? 0 : this.dialogFile.hashCode());
        if (this.elements == null || this.elements.isEmpty()) {
            return result;
        }
        Document doc = DVTCustomDialogSnapshotUtils.getDocument(this.dialogFile);
        if (doc == null) {
            return result;
        }
        for (DVTDialogElement element : this.elements) {
            if (element == null) continue;
            Node xPathNode = DVTCustomDialogSnapshotUtils.getXPathNode(element.getPath(), doc);
            result = 31 * result + (xPathNode == null ? 0 : xPathNode.hashCode());
            result = 31 * result + (element.getValue() == null ? 0 : element.getValue().hashCode());
        }
        return result;
    }

    public File getDialogFile() {
        return this.dialogFile;
    }

    public void setDialogFile(File dialogFile) {
        this.dialogFile = dialogFile;
    }
}

