/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.customdialog.core;

import java.io.File;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.cli.AbstractCliHandlerDelegate;
import ro.amiq.dvt.customdialog.DVTCustomDialog;
import ro.amiq.dvt.startup.cli.DVTCliException;
import ro.amiq.dvt.startup.cli.DVTCliHandlerV1;

public class OpenCustomDialogHandler
extends AbstractCliHandlerDelegate {
    public String getCommandName() {
        return "openCustomDialog";
    }

    public void handle(IProgressMonitor monitor, DVTCliHandlerV1.ResultBuilder result, String cwd, CommandLine commandLine) throws CoreException, DVTCliException {
        File[] dialogDescriptor;
        String dialogDescriptorPath = commandLine.getOptionValue("file");
        if (dialogDescriptorPath == null) {
            throw new DVTCliException("No dialog descriptor file specified.");
        }
        String projectName = null;
        if (commandLine.hasOption("project")) {
            projectName = commandLine.getOptionValue("project");
        }
        final boolean nonBlocking = commandLine.hasOption("nonblocking");
        final IProject[] project = new IProject[1];
        if (projectName != null) {
            project[0] = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            if (project[0] == null || !project[0].exists()) {
                throw new DVTCliException("Project '" + projectName + "' does not exist in the workspace.");
            }
        }
        if (!(dialogDescriptor = new File[]{new File(dialogDescriptorPath)})[0].exists() && project[0] != null) {
            dialogDescriptor[0] = new File(project[0].getLocation().toFile(), dialogDescriptorPath);
        }
        if (!dialogDescriptor[0].exists()) {
            throw new DVTCliException("Dialog descriptor file '" + dialogDescriptor[0].getAbsolutePath() + "' does not exist.");
        }
        final String[] dialogResult = new String[1];
        if (!dialogDescriptor[0].exists()) {
            throw new CoreException((IStatus)new Status(4, "ro.amiq.dvt.customdialog", "Could not locate DVT Custom Dialog descriptor file '" + dialogDescriptor[0].getAbsolutePath() + "'." + "The file must be provided either as relative to project root or " + "as an absolute path."));
        }
        final Exception[] exc = new Exception[1];
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    DVTCustomDialog dialog = new DVTCustomDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), dialogDescriptor[0], project[0], true);
                    dialog.setNonBlocking(nonBlocking);
                    dialog.open();
                    if (dialog.getReturnCode() == 1) {
                        throw new OperationCanceledException();
                    }
                    dialogResult[0] = dialog.getResult();
                }
                catch (Exception e) {
                    exc[0] = e;
                }
            }
        });
        if (exc[0] instanceof OperationCanceledException) {
            throw (OperationCanceledException)exc[0];
        }
        if (exc[0] != null) {
            throw new CoreException((IStatus)new Status(4, "ro.amiq.dvt.customdialog", "Unable to create Custom DVT Run Dialog:", (Throwable)exc[0]));
        }
        result.append(dialogResult[0]);
    }

    public Options getOptions() {
        Options options = new Options();
        OptionBuilder.hasArg();
        OptionBuilder.isRequired();
        options.addOption(OptionBuilder.create((String)"file"));
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((String)"project"));
        options.addOption(OptionBuilder.create((String)"nonblocking"));
        return options;
    }

    public boolean c() {
        return DVTPlugin.getDefault().collect().ccc();
    }
}

