/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.customdialog.model;

import com.swtxml.tinydom.Tag;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class XPath {
    private static final Pattern SEGMENT_PATTERN = Pattern.compile("(\\w+)(?:\\[(\\d+)\\])?");
    public static final Pattern XPATH_PATTERN = Pattern.compile("(?:/" + SEGMENT_PATTERN + ")+");
    public List<Segment> segments = new ArrayList<Segment>();

    public static final XPath from(String s) {
        String[] pieces;
        XPath result = new XPath();
        if (s.startsWith("/")) {
            s = s.substring(1);
        }
        String[] stringArray = pieces = s.split("/");
        int n = pieces.length;
        int n2 = 0;
        while (n2 < n) {
            String piece = stringArray[n2];
            Matcher matcher = SEGMENT_PATTERN.matcher(piece);
            if (!matcher.matches()) {
                return null;
            }
            if (matcher.group(1) == null) {
                return null;
            }
            Segment segment = new Segment();
            segment.name = matcher.group(1);
            try {
                segment.count = Integer.parseInt(matcher.group(2));
            }
            catch (NumberFormatException numberFormatException) {}
            if (segment.count == 0) {
                segment.count = 1;
            }
            result.segments.add(segment);
            ++n2;
        }
        return result;
    }

    public static XPath from(Tag root, String xpathString) {
        if (xpathString == null) {
            return null;
        }
        XPath xpath = XPath.from(xpathString);
        if (xpath == null) {
            return null;
        }
        List<Segment> segments = xpath.segments;
        List children = Arrays.asList(root);
        for (Segment segment : segments) {
            for (Tag child : children) {
                if (child.getName().equals(segment.name)) {
                    --segment.count;
                }
                if (segment.count != 0) continue;
                segment.tag = child;
                children = child.getChildren();
                break;
            }
            if (segment.count == 0) continue;
            return null;
        }
        return xpath;
    }

    public static class Segment {
        public String name;
        public int count;
        public Tag tag;

        public String toString() {
            return String.valueOf(this.name) + "[" + this.count + "]" + "(" + this.tag + ")";
        }
    }
}

