/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.customdialog.newwizard;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import ro.amiq.dvt.customdialog.newwizard.DVTCustomDialogWizardPage;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTFileUtils;

public class DVTCustomDialogWizard
extends Wizard
implements INewWizard {
    private DVTCustomDialogWizardPage fPage;
    private static final String DEFAULT_CONTENT = DVTCustomDialogWizard.getStreamContent(DVTCustomDialogWizard.class.getResourceAsStream("template.swtxml"));

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public boolean performFinish() {
        final IFile file = this.fPage.getSelectedFile();
        File outFile = file.getLocation().toFile();
        DVTFileUtils.getInstance().writeStringToFile(outFile, DEFAULT_CONTENT, false);
        try {
            file.refreshLocal(0, null);
        }
        catch (CoreException coreException) {}
        this.getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }
        });
        return true;
    }

    public void addPages() {
        this.fPage = new DVTCustomDialogWizardPage("New DVT Custom Dialog", "New DVT Custom Dialog");
        this.addPage((IWizardPage)this.fPage);
    }

    public boolean canFinish() {
        return this.fPage.getErrorMessage() != null;
    }

    public static String getStreamContent(InputStream inputStream) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            byte[] buf = new byte[1024];
            int len = inputStream.read(buf);
            while (len > 0) {
                bos.write(buf, 0, len);
                len = inputStream.read(buf);
            }
            inputStream.close();
        }
        catch (IOException iOException) {}
        return new String(bos.toByteArray());
    }
}

