/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.customdialog.newwizard;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import ro.amiq.dvt.ui.ContainerSelectionGroup;

public class DVTCustomDialogWizardPage
extends WizardPage {
    private ContainerSelectionGroup containerSelectionGroup;
    private Text fNameText;
    private Listener fListener = new Listener(){

        public void handleEvent(Event event) {
            DVTCustomDialogWizardPage.this.updateMessage();
        }
    };

    protected DVTCustomDialogWizardPage(String pageName, String title) {
        super(pageName, title, null);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        Label nameLabel = new Label(composite, 0);
        nameLabel.setText("Custom Dialog Name: ");
        nameLabel.setLayoutData((Object)new GridData(1, 1, false, false));
        this.fNameText = new Text(composite, 2048);
        this.fNameText.setText("customdialog");
        this.fNameText.setLayoutData((Object)new GridData(4, 1, true, false));
        this.fNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DVTCustomDialogWizardPage.this.updateMessage();
            }
        });
        this.containerSelectionGroup = new ContainerSelectionGroup((IContainer)ResourcesPlugin.getWorkspace().getRoot(), composite, this.fListener, true, null, false, true, true);
        GridData containerSelectionData = new GridData(4, 4, true, true);
        this.containerSelectionGroup.setLayoutData((Object)containerSelectionData);
        containerSelectionData.horizontalSpan = 2;
        this.containerSelectionGroup.setLayoutData((Object)containerSelectionData);
        this.setControl((Control)composite);
    }

    private void updateMessage() {
        if (this.getSelectedFile() == null) {
            this.setErrorMessage("Please select a parent folder for the Custom Dialog");
        } else if (this.fNameText.getText().trim().length() == 0) {
            this.setErrorMessage("Please type a name for the Custom Dialog");
        } else if (this.getSelectedFile().exists()) {
            this.setErrorMessage("There is already a Custom Dialog called '" + this.fNameText.getText() + "' in the folder you selected.");
        } else {
            this.setErrorMessage(null);
        }
    }

    public IFile getSelectedFile() {
        IPath fp = this.containerSelectionGroup.getContainerFullPath();
        if (fp == null) {
            return null;
        }
        IPath resultPath = fp.append(String.valueOf(this.fNameText.getText()) + ".swtxml");
        return ResourcesPlugin.getWorkspace().getRoot().getFile(resultPath);
    }

    public void setVisible(boolean visible) {
        this.updateMessage();
        super.setVisible(visible);
    }
}

