/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.customdialog.widgets;

import com.swtxml.tinydom.Tag;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.fieldassist.ContentAssistCommandAdapter;
import ro.amiq.dvt.customdialog.widgets.ContentAssistableTextWidget;
import ro.amiq.dvt.customdialog.widgets.DVTWidget;
import ro.amiq.dvt.ui.widget.utils.DVTWidgetContentAssistProposalProvider;
import ro.amiq.dvt.utils.DVTStringUtil;

public class AutocompleteText
extends DVTWidget
implements ContentAssistableTextWidget {
    private static final String ITEM_SEPARATOR = ";";
    private DVTWidgetContentAssistProposalProvider fItemsProposer;
    private TextContentAdapter fContentAdapter;
    private Text fText = new Text((Composite)this, 2048);
    private List<String> fItems;
    private String text;

    public AutocompleteText(Composite parent, int style) {
        super(parent, style);
        this.fText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.fText.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                AutocompleteText.this.fText.setSelection(AutocompleteText.this.fText.getText().length());
            }

            public void focusLost(FocusEvent e) {
            }
        });
        this.fItems = new ArrayList<String>();
        this.fContentAdapter = new TextContentAdapter();
        this.fItemsProposer = new DVTWidgetContentAssistProposalProvider(this.fItems.toArray(new String[this.fItems.size()]), false);
        new ContentAssistCommandAdapter((Control)this.fText, (IControlContentAdapter)this.fContentAdapter, (IContentProposalProvider)this.fItemsProposer, "org.eclipse.ui.edit.text.contentAssist.proposals", this.getAutoactivationCharacters(), true);
    }

    private char[] getAutoactivationCharacters() {
        String lowercaseLetters = "abcdefghijklmnopqrstuvwxyz";
        String uppercaseLetters = lowercaseLetters.toUpperCase();
        String numbers = "0123456789";
        String allChars = String.valueOf(lowercaseLetters) + uppercaseLetters + numbers + "=";
        return allChars.toCharArray();
    }

    @Override
    public String getValue() {
        return this.fText.getText();
    }

    @Override
    public void setValue(String value) {
        if (value == null) {
            return;
        }
        this.fText.setText(value);
        this.fText.setSelection(value.length());
    }

    @Override
    public void init(Tag tag) {
        String prevValue = this.getValue();
        if ((prevValue == null || prevValue.isEmpty()) && this.text != null) {
            this.setValue(this.text);
        }
    }

    @Override
    public void setStringRepresentation(String value) {
        this.setValue(value);
    }

    @Override
    public String getStringRepresentation() {
        return this.getValue();
    }

    @Override
    public void addProposalsToContentAssist(String[] newProposals) {
        this.fItems.addAll(Arrays.asList(newProposals));
        this.fItemsProposer.setProposals(this.fItems.toArray(new String[this.fItems.size()]));
    }

    @Override
    public TextContentAdapter getContentAdapter() {
        return this.fContentAdapter;
    }

    @Override
    public Text getActualTextWidget() {
        return this.fText;
    }

    @Override
    public int getCursorPosition() {
        return this.fText.getCaretPosition();
    }

    public void setAutocompleteItems(String items) {
        this.fItems.addAll(Arrays.asList(items.split(ITEM_SEPARATOR)));
        this.fItemsProposer.setProposals(this.fItems.toArray(new String[this.fItems.size()]));
    }

    public String getAutocompleteItems() {
        if (this.fItems.isEmpty()) {
            return "";
        }
        return DVTStringUtil.join(this.fItems, (String)ITEM_SEPARATOR);
    }

    public void setText(String initialText) {
        this.text = initialText;
    }

    public String getText() {
        return this.text;
    }
}

