/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.customdialog.widgets;

import com.swtxml.tinydom.Tag;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import ro.amiq.dvt.customdialog.widgets.ContentAssistableTextWidget;
import ro.amiq.dvt.customdialog.widgets.DVTRedirectedOutputWidget;
import ro.amiq.dvt.customdialog.widgets.FilterListGroup;

public abstract class BaseSelector
extends DVTRedirectedOutputWidget {
    private FilterListGroup fFilteredList;
    private String fValue;
    private ILabelProvider fLabelProvider;
    private String fQuestion;
    private String fFieldSeparator = " ";

    public BaseSelector(Composite parent, int style) {
        super(parent, style);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        this.setLayout((Layout)layout);
        this.fLabelProvider = this.getLabelProvider();
        this.fFilteredList = new FilterListGroup(this, style, this.fLabelProvider);
        this.fFilteredList.setListElements(this.getDefaultElements());
        this.fFilteredList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BaseSelector.this.updateValueFromSelection();
            }
        });
        this.fFilteredList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BaseSelector.this.updateValueFromSelection();
            }
        });
        this.redirectListSelectionToOutput(this.fFilteredList);
    }

    @Override
    public void init(Tag tag) {
        Object[] elements = this.computeElements();
        this.fFilteredList.setListElements(elements);
        this.fValue = this.fLabelProvider.getText(elements[elements.length - 1]);
        this.setSelectionFromValue();
        this.initOutput();
    }

    @Override
    public void setValue(String value) {
        this.fValue = value;
        this.setSelectionFromValue();
    }

    public void setComparator(Comparator<?> comparator) {
        this.fFilteredList.setComparator(comparator);
    }

    private void setSelectionFromValue() {
        if (this.fValue == null) {
            this.fFilteredList.setSelection(new Object[0]);
            return;
        }
        Object[] elements = this.fFilteredList.getListElements();
        if (elements == null) {
            return;
        }
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (this.fValue.equals(this.fLabelProvider.getText(element))) {
                this.fFilteredList.setSelection(new Object[]{element});
                return;
            }
            ++n2;
        }
    }

    @Override
    public void setStringRepresentation(String value) {
        this.setValue(value);
    }

    @Override
    public String getStringRepresentation() {
        return this.getValue();
    }

    @Override
    public String getValue() {
        return this.fValue;
    }

    private void updateValueFromSelection() {
        this.fValue = "";
        if (this.fFilteredList.isEmpty()) {
            return;
        }
        Object[] selection = this.fFilteredList.getSelection();
        if (selection.length == 0) {
            return;
        }
        Object[] objectArray = selection;
        int n = selection.length;
        int n2 = 0;
        while (n2 < n) {
            Object selectionItem = objectArray[n2];
            this.fValue = String.valueOf(this.fValue) + this.fLabelProvider.getText(selectionItem) + this.getFieldSeparator();
            ++n2;
        }
        this.fValue = this.fValue.substring(0, this.fValue.length() - this.getFieldSeparator().length());
    }

    @Override
    public void appendContentToOuputContentAssist() {
        List<Object> elements = Arrays.asList(this.computeElements());
        ((ContentAssistableTextWidget)((Object)this.fOutput)).addProposalsToContentAssist(elements.stream().map(element -> this.getLabelProvider().getText(element)).collect(Collectors.toList()).toArray(new String[elements.size()]));
    }

    public void setQuestion(String question) {
        this.fQuestion = question;
        this.fFilteredList.setText(this.fQuestion);
    }

    public String getQuestion() {
        return this.fQuestion;
    }

    public void setMinHeight(int minHeight) {
        this.fFilteredList.setMinHeight(minHeight);
    }

    public int getMinHeight() {
        return this.fFilteredList.getMinHeight();
    }

    public void setMinWidth(int minWidth) {
        try {
            this.fFilteredList.setMinHeight(minWidth);
        }
        catch (Exception exception) {}
    }

    public int getMinWidth() {
        return this.fFilteredList.getMinWidth();
    }

    public void setFieldSeparator(String value) {
        this.fFieldSeparator = value;
    }

    public String getFieldSeparator() {
        return this.fFieldSeparator;
    }

    protected abstract Object[] getDefaultElements();

    protected abstract ILabelProvider getLabelProvider();

    protected abstract Object[] computeElements();
}

