/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.customdialog.widgets;

import com.swtxml.tinydom.Tag;
import com.swtxml.util.parser.KeyValueParser;
import com.swtxml.util.parser.Strictness;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import ro.amiq.dvt.customdialog.DVTCustomDialog;
import ro.amiq.dvt.customdialog.model.XPath;
import ro.amiq.dvt.customdialog.widgets.DVTWidget;
import ro.amiq.dvt.startup.core.DVTLogger;

public class Container
extends DVTWidget {
    private static final String SNAPSHOT_LOADED = "snapshotLoaded";
    private static final String CONTAINER = "container";
    public static final String QUOTE_WITH = "quoteWith";
    public static final String CHECKBOX_ON_VALUE = "checkboxOnValue";
    public static final String CHECKBOX_OFF_VALUE = "checkboxOffValue";
    public static final String LIST_SEPARATOR = "listSeparator";
    public static final String NO_ID_FOR_EMPTY_VALUES = "noIdForEmptyValues";
    public static final String SHOW_IN_TITLE = "showInTitle";
    public static final String SNAPSHOT_FILE_LOCATION = "snapshotFileLocation";
    private static final Pattern ENABLER_VALUE_PATTERN = Pattern.compile("\\s*==\\s*\\w*\\s*");
    private static final Map<String, String> fDefaults = new HashMap<String, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(Container.LIST_SEPARATOR, ";");
        }
    };
    private LinkedHashMap<StartEnd, Widget> fEnablers;
    private ScriptEngine fScriptEngine;
    private Tag fTag;
    private String fValue;
    private String fParameters;
    private String fEnablerExpression;

    public Container(Composite parent, int style) {
        super(parent, style);
    }

    @Override
    public void init(Tag tag) {
        this.fTag = tag;
        this.initCode();
        this.initEnablers();
        this.installEnablementListeners();
        this.updateEnablement();
    }

    private void initEnablers() {
        if (this.fEnablerExpression == null) {
            return;
        }
        this.fEnablers = new LinkedHashMap();
        Matcher xPathMatcher = XPath.XPATH_PATTERN.matcher(this.fEnablerExpression);
        while (xPathMatcher.find()) {
            String enablerPath = xPathMatcher.group(0);
            Widget widget = this.getWidget(enablerPath);
            if (widget == null) {
                return;
            }
            int end = -1;
            if (widget instanceof Button) {
                end = xPathMatcher.end();
            }
            if (widget instanceof Combo || widget instanceof Text) {
                end = this.getEndOfTextEntry(xPathMatcher.end());
            }
            if (end == -1) continue;
            this.fEnablers.put(new StartEnd(xPathMatcher.start(), end), widget);
        }
    }

    private int getEndOfTextEntry(int end) {
        Matcher matcher = ENABLER_VALUE_PATTERN.matcher(this.fEnablerExpression.substring(end));
        if (matcher.find()) {
            return end + matcher.end();
        }
        return -1;
    }

    private void initCode() {
        String code = this.fTag.getCharacters();
        if (code == null || code.trim().isEmpty()) {
            return;
        }
        ScriptEngineManager manager = new ScriptEngineManager();
        this.fScriptEngine = manager.getEngineByName("rhino");
        if (this.fScriptEngine == null) {
            return;
        }
        try {
            this.fScriptEngine.put(CONTAINER, (Object)this);
            this.fScriptEngine.eval(code);
            this.logExecution(code);
        }
        catch (ScriptException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void installEnablementListeners() {
        if (this.fEnablers == null) {
            return;
        }
        SelectionListener selectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Container.this.updateEnablement();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        };
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Container.this.updateEnablement();
            }
        };
        for (Widget widget : this.fEnablers.values()) {
            if (widget instanceof Button) {
                ((Button)widget).addSelectionListener(selectionListener);
            }
            if (widget instanceof Combo) {
                ((Combo)widget).addSelectionListener(selectionListener);
            }
            if (!(widget instanceof Text)) continue;
            ((Text)widget).addModifyListener(modifyListener);
        }
    }

    public void snapshotLoaded() {
        if (this.fEnablerExpression != null) {
            this.updateEnablement();
        }
        if (this.fScriptEngine == null) {
            return;
        }
        String script = "snapshotLoaded();";
        try {
            this.logExecution(script);
            this.fScriptEngine.eval(script);
        }
        catch (ScriptException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void updateEnablement() {
        if (this.fEnablers == null) {
            return;
        }
        try {
            this.setEnabledRecursively((Control)this, this.computeEnablement());
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private boolean computeEnablement() throws Exception {
        StringBuilder expression = new StringBuilder();
        int currentIndex = 0;
        for (Map.Entry<StartEnd, Widget> entry : this.fEnablers.entrySet()) {
            StartEnd startEnd = entry.getKey();
            Widget widget = entry.getValue();
            if (widget instanceof Button) {
                expression.append(this.fEnablerExpression.substring(currentIndex, startEnd.start));
                expression.append(((Button)widget).getSelection());
            }
            if (widget instanceof Combo) {
                expression.append(this.fEnablerExpression.substring(currentIndex, startEnd.start));
                int selectionIndex = ((Combo)widget).getSelectionIndex();
                if (selectionIndex == -1) {
                    expression.append(false);
                    currentIndex = startEnd.end;
                    continue;
                }
                String item = ((Combo)widget).getItem(selectionIndex);
                if (item == null) {
                    expression.append(false);
                    currentIndex = startEnd.end;
                    continue;
                }
                String enablerValue = this.getEnablerValue(startEnd.start, startEnd.end);
                expression.append(item.equals(enablerValue));
            }
            if (widget instanceof Text) {
                expression.append(this.fEnablerExpression.substring(currentIndex, startEnd.start));
                String item = ((Text)widget).getText();
                if (item == null || item.isEmpty()) {
                    expression.append(false);
                    currentIndex = startEnd.end;
                    continue;
                }
                String enablerValue = this.getEnablerValue(startEnd.start, startEnd.end);
                expression.append(item.equals(enablerValue));
            }
            currentIndex = startEnd.end;
        }
        if (expression.length() == 0) {
            return true;
        }
        expression.append(this.fEnablerExpression.substring(currentIndex, this.fEnablerExpression.length()));
        ScriptEngine scriptEngine = new ScriptEngineManager().getEngineByName("rhino");
        if (scriptEngine == null) {
            return true;
        }
        try {
            this.logExecution(expression.toString());
            Object resultObject = scriptEngine.eval(expression.toString());
            if (resultObject instanceof Boolean) {
                return (Boolean)resultObject;
            }
        }
        catch (ScriptException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return true;
    }

    private String getEnablerValue(int start, int stop) {
        String entry = this.fEnablerExpression.substring(start, stop);
        String[] split = entry.split("==");
        if (split.length != 2) {
            return null;
        }
        return split[1].trim();
    }

    private void logExecution(String expression) {
        if (expression == null) {
            return;
        }
        StringBuilder linified = new StringBuilder("Custom Dialog executing:\n");
        String[] lines = expression.split("\n");
        int i = 0;
        while (i < lines.length) {
            linified.append(String.format("%3d", i + 1)).append("    ").append(lines[i]).append("\n");
            ++i;
        }
        DVTLogger.INSTANCE.logInfo(linified.toString());
    }

    @Override
    public void setValue(String value) {
        this.fValue = value;
    }

    @Override
    public String getValue() {
        return this.fValue;
    }

    @Override
    public void setStringRepresentation(String value) {
        this.setValue(value);
    }

    @Override
    public String getStringRepresentation() {
        return this.getValue();
    }

    public void setParameters(String parameters) {
        this.fParameters = parameters;
    }

    public String getParameters() {
        return this.fParameters;
    }

    public void setEnabler(String enabler) {
        this.fEnablerExpression = enabler;
    }

    public String getEnabler() {
        return this.fEnablerExpression;
    }

    private void setEnabledRecursively(Control control, boolean enabled) {
        control.setEnabled(enabled);
        if (control instanceof Composite) {
            Control[] controlArray = ((Composite)control).getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                this.setEnabledRecursively(child, enabled);
                ++n2;
            }
        }
    }

    public Widget getWidget(String xPath) {
        DVTCustomDialog dialog = this.getDialog();
        if (dialog == null) {
            return null;
        }
        Tag root = dialog.getRoot();
        if (root == null) {
            return null;
        }
        XPath xpath = XPath.from(root, xPath);
        if (xpath == null) {
            return null;
        }
        XPath.Segment lastSegment = xpath.segments.get(xpath.segments.size() - 1);
        if (lastSegment.tag == null) {
            return null;
        }
        return (Widget)lastSegment.tag.adaptTo(Widget.class);
    }

    public void setEnabledRecursively(boolean enabled) {
        this.setEnabledRecursively((Control)this, enabled);
    }

    public static Object getDefaultParameter(String name) {
        return fDefaults.get(name);
    }

    public String getOwnParameter(String name) {
        if (this.fParameters == null) {
            return null;
        }
        return (String)KeyValueParser.parse((String)this.fParameters, (Strictness)Strictness.NICE, (boolean)false).get(name);
    }

    public static String getStringParameter(Tag tag, String name) {
        String result = fDefaults.get(name);
        Tag parent = tag;
        while ((parent = parent.getParent()) != null) {
            if (!(parent.adaptTo(Widget.class) instanceof Container) || ((Container)((Object)parent.adaptTo(Widget.class))).getOwnParameter(name) == null) continue;
            return ((Container)((Object)parent.adaptTo(Widget.class))).getOwnParameter(name);
        }
        return result;
    }

    public static String getStringParameter(Control control, String name) {
        String result = fDefaults.get(name);
        Control parent = control;
        while ((parent = parent.getParent()) != null) {
            if (!(parent instanceof Container) || ((Container)parent).getOwnParameter(name) == null) continue;
            return ((Container)parent).getOwnParameter(name);
        }
        return result;
    }

    public static Boolean getBooleanParameter(Tag tag, String name) {
        return Boolean.parseBoolean(Container.getStringParameter(tag, name));
    }

    public static Boolean getBooleanParameter(Control control, String name) {
        return Boolean.parseBoolean(Container.getStringParameter(control, name));
    }

    private static class StartEnd {
        int start;
        int end;

        public StartEnd(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public String toString() {
            return "StartEnd [start=" + this.start + ", end=" + this.end + "]";
        }
    }
}

