/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.customdialog.widgets;

import com.swtxml.tinydom.Tag;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import ro.amiq.dvt.customdialog.DVTCustomDialog;
import ro.amiq.dvt.customdialog.widgets.ContentAssistableTextWidget;
import ro.amiq.dvt.customdialog.widgets.DVTWidget;
import ro.amiq.dvt.customdialog.widgets.FilterListGroup;

public abstract class DVTRedirectedOutputWidget
extends DVTWidget {
    protected DVTWidget fOutput;
    private String fOuputPath;

    public DVTRedirectedOutputWidget(Composite parent, int style) {
        super(parent, style);
    }

    public void initOutput() {
        if (this.fOutput != null) {
            return;
        }
        DVTCustomDialog rootDialog = this.getDialog();
        Tag root = rootDialog.getRoot();
        if (root == null) {
            return;
        }
        Widget widgetForPath = rootDialog.getWidgetForPath(root, this.getOuputPath());
        if (!(widgetForPath instanceof DVTWidget)) {
            return;
        }
        this.fOutput = (DVTWidget)widgetForPath;
        if (this.fOutput instanceof ContentAssistableTextWidget) {
            this.appendContentToOuputContentAssist();
        }
    }

    public abstract void appendContentToOuputContentAssist();

    public void redirectListSelectionToOutput(final FilterListGroup list) {
        list.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                if (DVTRedirectedOutputWidget.this.fOutput == null) {
                    return;
                }
                Object[] listSelection = list.getListSelection();
                if (listSelection == null || listSelection.length != 1) {
                    return;
                }
                Object selectedItem = listSelection[0];
                if (selectedItem == null) {
                    return;
                }
                String insertedItem = selectedItem.toString();
                if (DVTRedirectedOutputWidget.this.fOutput instanceof ContentAssistableTextWidget) {
                    ContentAssistableTextWidget caTextWidget = (ContentAssistableTextWidget)((Object)DVTRedirectedOutputWidget.this.fOutput);
                    int prevCursorPosition = caTextWidget.getCursorPosition();
                    TextContentAdapter textContentAdapter = caTextWidget.getContentAdapter();
                    Text actualTextWidget = caTextWidget.getActualTextWidget();
                    textContentAdapter.insertControlContents((Control)actualTextWidget, insertedItem, prevCursorPosition);
                    DVTRedirectedOutputWidget.this.fOutput.setFocus();
                    textContentAdapter.setCursorPosition((Control)actualTextWidget, prevCursorPosition + insertedItem.length());
                } else {
                    DVTRedirectedOutputWidget.this.fOutput.setValue(String.valueOf(DVTRedirectedOutputWidget.this.fOutput.getValue()) + insertedItem);
                    DVTRedirectedOutputWidget.this.fOutput.setFocus();
                }
            }
        });
        list.getParent().addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent event) {
                if (DVTRedirectedOutputWidget.this.fOutput != null) {
                    event.doit = false;
                }
            }
        });
    }

    public void setOuputPath(String ouputPath) {
        this.fOuputPath = ouputPath;
    }

    public String getOuputPath() {
        return this.fOuputPath;
    }
}

