/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.customdialog.widgets;

import com.swtxml.tinydom.Tag;
import java.io.File;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import ro.amiq.dvt.customdialog.widgets.DVTWidget;

public class DirectoryChooser
extends DVTWidget {
    private Button fBrowseButton;
    private Text fDirectoryText;
    private Group fGroup = new Group((Composite)this, 0);
    private String fQuestion;

    public DirectoryChooser(Composite parent, int style) {
        super(parent, style);
        this.fGroup.setLayout((Layout)new GridLayout(2, false));
        this.fGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        this.fDirectoryText = new Text((Composite)this.fGroup, 2048);
        this.fDirectoryText.setLayoutData((Object)new GridData(4, 128, true, false));
        this.fBrowseButton = new Button((Composite)this.fGroup, 8);
        this.fBrowseButton.setLayoutData((Object)new GridData(1, 128, false, false));
        this.fBrowseButton.setText("Browse...");
        this.fBrowseButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog directoryDialog = new DirectoryDialog(DirectoryChooser.this.getShell());
                directoryDialog.setMessage(DirectoryChooser.this.fQuestion == null ? "" : DirectoryChooser.this.fQuestion);
                if (new File(DirectoryChooser.this.fDirectoryText.getText()).exists()) {
                    directoryDialog.setFilterPath(DirectoryChooser.this.fDirectoryText.getText());
                } else if (DirectoryChooser.this.getProject() != null) {
                    directoryDialog.setFilterPath(DirectoryChooser.this.getProject().getLocation().toOSString());
                } else {
                    directoryDialog.setFilterPath(null);
                }
                String selectedDirectory = directoryDialog.open();
                if (selectedDirectory != null) {
                    DirectoryChooser.this.fDirectoryText.setText(selectedDirectory);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    @Override
    public String getValue() {
        return this.fDirectoryText.getText();
    }

    @Override
    public void init(Tag tag) {
    }

    @Override
    public void setValue(String value) {
        if (value == null) {
            return;
        }
        this.fDirectoryText.setText(value);
    }

    @Override
    public void setStringRepresentation(String value) {
        this.setValue(value);
    }

    @Override
    public String getStringRepresentation() {
        return this.getValue();
    }

    public void setQuestion(String question) {
        this.fQuestion = question;
        this.fGroup.setText(this.fQuestion);
    }

    public String getQuestion() {
        return this.fQuestion;
    }
}

