/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.customdialog.widgets;

import com.swtxml.tinydom.Tag;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.tools.ant.DirectoryScanner;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.BuildConfigManagerCommon;
import ro.amiq.dvt.customdialog.widgets.Container;
import ro.amiq.dvt.customdialog.widgets.DVTWidget;
import ro.amiq.dvt.customdialog.widgets.FilterListGroup;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.dvt.utils.TimeoutUtils;

public class DirectoryFilesListing
extends DVTWidget {
    private AtomicBoolean fListingCancelled = new AtomicBoolean(false);
    private boolean fDidFinishScanning;
    private FilterListGroup fFilteredList;
    private static final int DEFAULT_TIMEOUT_SECONDS = 10;
    private static final String DISPLAY_FILE_BASENAME = "basename";
    private static final String DISPLAY_FILE_FULLNAME = "fullname";
    private static final String DISPLAY_FILE_FULLPATH = "fullpath";
    private static final String DISPLAY_FILE_RELATIVEPATH = "relativepath";
    private File fRootDirectory;
    private String fQuestion;
    private String[] fIncludePaths;
    private String[] fExcludePaths;
    private boolean fShowHiddenFiles = false;
    private String fOutputOption = "fullname";
    private int fTimeoutSeconds = 10;
    private EnumSet<FileType> fFileTypes = EnumSet.of(FileType.FILE);

    public DirectoryFilesListing(Composite parent, int style) {
        super(parent, style);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        this.setLayout((Layout)layout);
        this.fFilteredList = new FilterListGroup(this, style);
    }

    @Override
    public void init(Tag tag) {
        this.updateList();
    }

    @Override
    public String getValue() {
        Object[] selectedElements = this.fFilteredList.getSelection();
        if (selectedElements == null) {
            return "";
        }
        ArrayList<String> result = new ArrayList<String>();
        Object[] objectArray = selectedElements;
        int n = selectedElements.length;
        int n2 = 0;
        while (n2 < n) {
            Object selectedElement = objectArray[n2];
            String selectedFileName = selectedElement.toString();
            File selectedFile = new File(selectedFileName);
            if (this.fOutputOption.equalsIgnoreCase(DISPLAY_FILE_BASENAME)) {
                int index = selectedFile.getName().lastIndexOf(46);
                if (index > 0) {
                    result.add(selectedFile.getName().substring(0, index));
                } else {
                    result.add(selectedFile.getName());
                }
            } else if (this.fOutputOption.equalsIgnoreCase(DISPLAY_FILE_FULLNAME)) {
                result.add(selectedFile.getName());
            } else if (this.fOutputOption.equalsIgnoreCase(DISPLAY_FILE_FULLPATH)) {
                File fullPathFile = new File(this.fRootDirectory + File.separator + selectedFileName);
                result.add(fullPathFile.getAbsolutePath());
            } else {
                result.add(selectedFileName);
            }
            ++n2;
        }
        return DVTStringUtil.join(result, (String)Container.getStringParameter((Control)this, "listSeparator"));
    }

    @Override
    public void setValue(String value) {
    }

    @Override
    public void setStringRepresentation(String value) {
        this.fFilteredList.setStringRepresentation(value);
    }

    @Override
    public String getStringRepresentation() {
        return this.fFilteredList.getStringRepresentation();
    }

    private void updateList() {
        if (this.fFilteredList == null) {
            return;
        }
        if (this.fRootDirectory == null) {
            this.setRootDirectory("");
        }
        if (!this.fRootDirectory.exists()) {
            return;
        }
        DirectoryScanner ds = new DirectoryScanner();
        ds.setBasedir(this.fRootDirectory);
        ds.setIncludes(this.fIncludePaths);
        ds.setExcludes(this.fExcludePaths);
        ds.setMaxLevelsOfSymlinks(1);
        this.fDidFinishScanning = false;
        this.fListingCancelled.set(false);
        ProgressMonitorDialog pmd = new ProgressMonitorDialog(DVTUiUtils.getActiveWorkbenchShell());
        try {
            pmd.run(true, true, monitor -> {
                monitor.beginTask("List directory's children...", -1);
                this.fDidFinishScanning = TimeoutUtils.INSTANCE.runWithTimeout((long)this.fTimeoutSeconds * 1000L, monitor, () -> ds.scan());
                if (monitor.isCanceled()) {
                    this.fListingCancelled.set(true);
                }
            });
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        if (!this.fDidFinishScanning) {
            if (this.fListingCancelled.get()) {
                this.fFilteredList.setListElements(new String[]{"Operation canceled by user"});
                return;
            }
            new MessageDialog(DVTUiUtils.getActiveWorkbenchShell(), "Directory Files Listing", null, "Too many files! Timed out after " + this.fTimeoutSeconds + " seconds.\n\nYou can change the timeout interval by modifying the 'timeoutSeconds' parameter.", 4, new String[]{"Ok"}, 0).open();
            return;
        }
        ArrayList<String> visibleFiles = new ArrayList<String>();
        if (this.fFileTypes.contains((Object)FileType.FILE)) {
            this.collect(visibleFiles, ds.getIncludedFiles());
        }
        if (this.fFileTypes.contains((Object)FileType.DIR)) {
            this.collect(visibleFiles, ds.getIncludedDirectories());
        }
        Object[] fElements = visibleFiles.toArray(new String[visibleFiles.size()]);
        this.fFilteredList.setListElements(fElements);
    }

    private void collect(List<String> result, String[] candidates) {
        String[] stringArray = candidates;
        int n = candidates.length;
        int n2 = 0;
        while (n2 < n) {
            String incFileName = stringArray[n2];
            File file = new File(incFileName);
            if (this.fShowHiddenFiles || !file.isHidden()) {
                result.add(incFileName);
            }
            ++n2;
        }
    }

    public void setRootDirectory(String rootDirectory) {
        this.fRootDirectory = new File(rootDirectory = this.resolveEnvVars(rootDirectory)).isAbsolute() || this.getProject() == null ? new File(rootDirectory) : new File(this.getProject().getLocation().toOSString(), rootDirectory);
        try {
            this.fRootDirectory = this.fRootDirectory.getCanonicalFile();
        }
        catch (IOException iOException) {}
    }

    private String resolveEnvVars(String string) {
        String result = DVTUtilsCommon.INSTANCE.replaceAllSystemVariables((CharSequence)string, DVTUtilsCommon.ReplaceSysvarsPolicy.LEAVE_UNREPLACED, envVarName -> BuildConfigManager.getUserDefinedEnvVar((IProject)this.getProject(), (String)envVarName, (BuildConfigManagerCommon.EnvVarReplacementPriorityPolicy)BuildConfigManagerCommon.EnvVarReplacementPriorityPolicy.LAST_INVOCATION));
        if (result != null) {
            return result;
        }
        return string;
    }

    public String getRootDirectory() {
        return this.fRootDirectory.getAbsolutePath();
    }

    public void setQuestion(String question) {
        this.fQuestion = question;
        this.fFilteredList.setText(this.fQuestion);
    }

    public String getQuestion() {
        return this.fQuestion;
    }

    public void setOutputOption(String option) {
        if (!(option.equalsIgnoreCase(DISPLAY_FILE_BASENAME) || option.equalsIgnoreCase(DISPLAY_FILE_FULLNAME) || option.equalsIgnoreCase(DISPLAY_FILE_FULLPATH) || option.equalsIgnoreCase(DISPLAY_FILE_RELATIVEPATH))) {
            return;
        }
        this.fOutputOption = option;
    }

    public String getOutputOption() {
        return this.fOutputOption;
    }

    public void setShowHiddenFiles(boolean showHiddenFiles) {
        this.fShowHiddenFiles = showHiddenFiles;
    }

    public boolean getShowHiddenFiles() {
        return this.fShowHiddenFiles;
    }

    public void setIncludePaths(String[] includePaths) {
        this.fIncludePaths = includePaths;
        if (this.fIncludePaths == null || this.fIncludePaths.length == 0) {
            this.fIncludePaths = new String[]{"*"};
        }
        int j = 0;
        while (j < this.fIncludePaths.length) {
            this.fIncludePaths[j] = this.resolveEnvVars(this.fIncludePaths[j]);
            ++j;
        }
    }

    public String[] getIncludePaths() {
        return this.fIncludePaths;
    }

    public void setExcludePaths(String[] excludePaths) {
        if (excludePaths == null) {
            this.fExcludePaths = new String[0];
        }
        this.fExcludePaths = excludePaths;
    }

    public String[] getExcludePaths() {
        return this.fExcludePaths;
    }

    public String getTimeoutSeconds() {
        return String.valueOf(this.fTimeoutSeconds);
    }

    public void setTimeoutSeconds(String timeout) {
        int to = Integer.parseInt(timeout);
        if (to < 0) {
            to = 10;
        }
        this.fTimeoutSeconds = to;
    }

    public String[] getFileType() {
        ArrayList<String> result = new ArrayList<String>();
        for (FileType fileType : this.fFileTypes) {
            result.add(fileType.name());
        }
        return result.toArray(new String[result.size()]);
    }

    public void setFileType(String[] fileTypeStrings) {
        ArrayList<FileType> fileTypes = new ArrayList<FileType>();
        String[] stringArray = fileTypeStrings;
        int n = fileTypeStrings.length;
        int n2 = 0;
        while (n2 < n) {
            String fileTypeString = stringArray[n2];
            fileTypes.add(FileType.valueOf(fileTypeString));
            ++n2;
        }
        this.fFileTypes = EnumSet.copyOf(fileTypes);
    }

    static enum FileType {
        DIR,
        FILE;

    }
}

